/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.PTPropertyChangeListener;
import org.eclipse.nebula.widgets.opal.propertytable.PTWidget;
import org.eclipse.nebula.widgets.opal.propertytable.PTWidgetFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PropertyTable
extends Composite {
    static final int VIEW_AS_FLAT_LIST = 0;
    static final int VIEW_AS_CATEGORIES = 1;
    boolean showButtons;
    boolean showDescription;
    boolean sorted;
    int styleOfView;
    final List<PTProperty> properties;
    private boolean hasBeenBuilt = false;
    private final List<PTPropertyChangeListener> changeListeners;
    private PTWidget widget;
    private boolean bulkUpdateInProgress = false;

    public PropertyTable(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(512));
        this.showButtons = true;
        this.showDescription = true;
        this.sorted = true;
        this.styleOfView = 1;
        this.properties = new ArrayList<PTProperty>();
        this.changeListeners = new ArrayList<PTPropertyChangeListener>();
        this.widget = PTWidgetFactory.build(this);
        this.addListener(11, event -> {
            if (!this.hasBeenBuilt) {
                this.widget.build();
                this.hasBeenBuilt = true;
            }
        });
    }

    public void addChangeListener(PTPropertyChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public PTProperty addProperty(PTProperty property) {
        if (this.properties.contains(property)) {
            throw new IllegalArgumentException("A property called '" + property.getName() + "' has already been declared.");
        }
        this.properties.add(property);
        property.setParentTable(this);
        return property;
    }

    public void firePTPropertyChangeListeners(PTProperty property) {
        for (PTPropertyChangeListener listener : this.changeListeners) {
            listener.propertyHasChanged(property);
        }
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (PTProperty prop : this.properties) {
            map.put(prop.getName(), prop.getValue());
        }
        return map;
    }

    public List<PTProperty> getPropertiesAsList() {
        return new ArrayList<PTProperty>(this.properties);
    }

    public PropertyTable hideButtons() {
        this.showButtons = false;
        return this.rebuild();
    }

    public PropertyTable hideDescription() {
        this.showDescription = false;
        return this.rebuild();
    }

    PropertyTable rebuild() {
        if (this.bulkUpdateInProgress) {
            return this;
        }
        try {
            this.setRedraw(false);
            this.widget = this.widget.disposeAndBuild(this);
            if (this.hasBeenBuilt) {
                this.setLayout((Layout)new FillLayout());
                this.widget.build();
                this.layout();
            }
        }
        finally {
            this.setRedraw(true);
            this.redraw();
        }
        return this;
    }

    public void refreshValues() {
        this.rebuild();
    }

    public void removeChangeListener(PTPropertyChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    public void setProperties(Map<String, Object> newValues) {
        for (PTProperty prop : this.properties) {
            if (newValues == null) {
                prop.setValue(null);
                continue;
            }
            Object value = newValues.get(prop.getName());
            prop.setValue(value);
        }
        this.rebuild();
    }

    public PropertyTable showButtons() {
        this.showButtons = true;
        return this.rebuild();
    }

    public PropertyTable showDescription() {
        this.showDescription = true;
        return this.rebuild();
    }

    public PropertyTable sort() {
        this.sorted = true;
        this.widget.refillData();
        return this;
    }

    public PropertyTable unsort() {
        this.sorted = false;
        this.widget.refillData();
        return this;
    }

    public PropertyTable viewAsCategories() {
        this.styleOfView = 1;
        return this.rebuild();
    }

    public PropertyTable viewAsFlatList() {
        this.styleOfView = 0;
        return this.rebuild();
    }

    public PropertyTable discardChanges() {
        this.bulkUpdateInProgress = true;
        for (PTProperty prop : this.properties) {
            prop.discardChange();
        }
        this.bulkUpdateInProgress = false;
        return this.rebuild();
    }
}

