/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.nebulaslider.snippets;

import org.eclipse.nebula.widgets.opal.nebulaslider.NebulaSlider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NebulaSliderSnippet {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new GridLayout(2, false));
        shell.setBackground(display.getSystemColor(1));
        NebulaSliderSnippet.createLeftLabel(shell, "Minimum");
        Text min = NebulaSliderSnippet.createTextWidget(shell, 0);
        NebulaSliderSnippet.createLeftLabel(shell, "Maximum");
        Text max = NebulaSliderSnippet.createTextWidget(shell, 1000);
        NebulaSliderSnippet.createLeftLabel(shell, "Value");
        Text value = NebulaSliderSnippet.createTextWidget(shell, 632);
        Button update = new Button((Composite)shell, 8);
        update.setLayoutData((Object)new GridData(3, 2, false, false, 2, 1));
        update.setText("Redraw Slider");
        NebulaSlider slider = new NebulaSlider((Composite)shell, 0);
        slider.setMinimum(0);
        slider.setMaximum(1000);
        slider.setValue(632);
        slider.setBackground(display.getSystemColor(1));
        slider.addListener(13, e -> System.out.println("New value is " + slider.getValue()));
        GridData layoutData = new GridData(4, 2, true, false, 2, 1);
        layoutData.widthHint = 600;
        layoutData.heightHint = 50;
        slider.setLayoutData((Object)layoutData);
        update.addListener(13, e -> {
            int minValue = 0;
            try {
                minValue = Integer.valueOf(min.getText());
            }
            catch (NumberFormatException nfe) {
                NebulaSliderSnippet.showError(shell, "The value [" + min.getText() + "] is not a number");
                return;
            }
            int maxValue = 0;
            try {
                maxValue = Integer.valueOf(max.getText());
            }
            catch (NumberFormatException nfe) {
                NebulaSliderSnippet.showError(shell, "The value [" + max.getText() + "] is not a number");
                return;
            }
            if (maxValue < minValue) {
                NebulaSliderSnippet.showError(shell, "The minimum is greater than the maximum");
                return;
            }
            int newValue = 0;
            try {
                newValue = Integer.valueOf(value.getText());
            }
            catch (NumberFormatException nfe) {
                NebulaSliderSnippet.showError(shell, "The value [" + value.getText() + "] is not a number");
                return;
            }
            if (newValue < minValue || newValue > maxValue) {
                NebulaSliderSnippet.showError(shell, "The value [" + newValue + "] should be between " + minValue + " and " + maxValue);
                return;
            }
            slider.setMinimum(minValue);
            slider.setMaximum(maxValue);
            slider.setValue(newValue);
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void createLeftLabel(Shell shell, String text) {
        Label lbl = new Label((Composite)shell, 0);
        lbl.setText(text);
        lbl.setBackground(shell.getDisplay().getSystemColor(1));
        lbl.setLayoutData((Object)new GridData(3, 2, false, false));
    }

    private static Text createTextWidget(Shell shell, int value) {
        Text txt = new Text((Composite)shell, 2048);
        txt.setText(String.valueOf(value));
        txt.setTextLimit(3);
        GridData gd = new GridData(4, 2, false, false);
        gd.minimumWidth = 40;
        txt.setLayoutData((Object)gd);
        return txt;
    }

    private static void showError(Shell shell, String message) {
        MessageBox mb = new MessageBox(shell, 33);
        mb.setText("Error");
        mb.setMessage(message);
        mb.open();
    }
}

