/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.led;

import org.eclipse.nebula.widgets.led.BaseLED;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class DotsLed
extends BaseLED {
    private boolean areDotsLight;

    public DotsLed(Composite parent, int style) {
        super(parent, DotsLed.checkStyle(style));
    }

    private static int checkStyle(int style) {
        int mask = 2048;
        int newStyle = style & 0x800;
        return newStyle |= 0x20000000;
    }

    @Override
    protected void paintInternal() {
        Rectangle clientArea = this.getClientArea();
        int x = clientArea.width / 2;
        int y = (clientArea.height - 40) / 2;
        this.gc.setBackground(this.areDotsLight ? this.selectedColor : this.idleColor);
        this.gc.fillOval(x, y, 10, 10);
        this.gc.fillOval(x, y += 20, 10, 10);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int x = wHint == -1 ? 30 : wHint;
        int y = hHint == -1 ? 100 : hHint;
        return new Point(x, y);
    }

    public void switchOn() {
        this.checkWidget();
        this.areDotsLight = true;
        this.redraw();
    }

    public void switchOff() {
        this.checkWidget();
        this.areDotsLight = false;
        this.redraw();
    }
}

