/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.compositetable.AbstractGridRowLayout;
import org.eclipse.nebula.widgets.compositetable.AbstractNativeHeader;
import org.eclipse.nebula.widgets.compositetable.ColumnControlListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

class HeaderLayout
extends AbstractGridRowLayout {
    private static final int MINIMUM_COL_WIDTH = 5;
    private boolean layingOut = false;
    private int[] lastWidths = null;
    private AbstractNativeHeader header = null;
    private int lastChildWidth = -1;
    private int lastShellWidth = -1;
    private List columnControlListeners = new ArrayList();
    private ControlListener headerControlListener = null;
    private boolean wasResized = true;
    private DisposeListener headerDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            HeaderLayout.this.asHeader(e.widget).removeColumnControlListener(HeaderLayout.this.headerControlListener);
        }
    };

    public HeaderLayout() {
    }

    public HeaderLayout(int[] weights) {
        super(weights);
    }

    public HeaderLayout(int[] weights, boolean fittingHorizontally) {
        super(weights, fittingHorizontally);
    }

    @Override
    protected Point computeSize(Composite child, int wHint, int hHint, boolean flushCache) {
        this.storeHeader(child);
        return super.computeSize(child, wHint, hHint, flushCache);
    }

    private void storeHeader(Composite child) {
        this.header = this.getHeader((Widget)child);
    }

    @Override
    protected void layout(final Composite child, boolean flushCache) {
        this.storeHeader(child);
        int childWidth = child.getSize().x;
        int shellWidth = child.getShell().getSize().x;
        if (childWidth == this.lastChildWidth && shellWidth > this.lastShellWidth) {
            return;
        }
        if (childWidth > this.lastChildWidth) {
            final Table headerTable = this.getHeader((Widget)child).headerTable;
            headerTable.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    headerTable.removePaintListener((PaintListener)this);
                    HeaderLayout.this.layout(child);
                }
            });
        } else {
            this.layout(child);
        }
        this.lastChildWidth = childWidth;
        this.lastShellWidth = shellWidth;
    }

    private void layout(Composite child) {
        this.layingOut = true;
        try {
            super.layout(child, true);
            this.storeLastWidths(this.getHeader((Widget)child).headerTable);
        }
        finally {
            this.layingOut = false;
        }
    }

    protected void storeLastWidths(Table table) {
        if (this.lastWidths == null) {
            this.lastWidths = new int[table.getColumnCount()];
        }
        TableColumn[] columns = table.getColumns();
        int col = 0;
        while (col < columns.length) {
            this.lastWidths[col] = columns[col].getWidth();
            ++col;
        }
    }

    @Override
    public int[] getWeights() {
        if (this.header == null) {
            return super.getWeights();
        }
        int[] weightsOrder = this.header.headerTable.getColumnOrder();
        int[] rawWeights = super.getWeights();
        int[] orderedWeights = new int[weightsOrder.length];
        int i = 0;
        while (i < orderedWeights.length) {
            orderedWeights[i] = rawWeights[weightsOrder[i]];
            ++i;
        }
        return orderedWeights;
    }

    @Override
    public AbstractGridRowLayout setWeights(int[] weights) {
        if (this.header == null) {
            super.setWeights(weights);
        } else {
            int[] weightsOrder = this.header.headerTable.getColumnOrder();
            int[] orderedWeights = new int[weightsOrder.length];
            int i = 0;
            while (i < orderedWeights.length) {
                orderedWeights[weightsOrder[i]] = weights[i];
                super.setWeights(orderedWeights);
                ++i;
            }
        }
        return this;
    }

    @Override
    protected int computeMaxHeight(Composite rowOrHeader) {
        return this.getHeader((Widget)rowOrHeader).headerTable.getHeaderHeight();
    }

    @Override
    protected Point computeColumnSize(Widget columnObject, int wHint, int hHint, boolean flush) {
        TableColumn tableColumn = (TableColumn)columnObject;
        int currentWidth = tableColumn.getWidth();
        int headerHeight = tableColumn.getParent().getHeaderHeight();
        return new Point(currentWidth, headerHeight);
    }

    @Override
    protected Widget getColumnAt(Composite rowOrHeader, int offset) {
        Table headerTable = this.getHeader((Widget)rowOrHeader).headerTable;
        int[] columnOrder = headerTable.getColumnOrder();
        return headerTable.getColumn(columnOrder[offset]);
    }

    @Override
    protected int getNumColumns(Composite rowOrHeader) {
        return this.getHeader((Widget)rowOrHeader).headerTable.getColumnCount();
    }

    @Override
    protected void setBounds(Widget columnObject, int left, int top, int width, int height) {
        TableColumn tableColumn = (TableColumn)columnObject;
        tableColumn.setWidth(width + 4);
    }

    private AbstractNativeHeader asHeader(Widget rowOrHeader) {
        if (!(rowOrHeader instanceof AbstractNativeHeader)) {
            throw new IllegalArgumentException("HeaderLayout must be used on an AbstractHeader");
        }
        return (AbstractNativeHeader)rowOrHeader;
    }

    private AbstractNativeHeader getHeader(Widget rowOrHeader) {
        AbstractNativeHeader header = this.asHeader(rowOrHeader);
        if (this.headerControlListener == null) {
            this.headerControlListener = new HeaderControlListener();
            header.addColumnControlListener(this.headerControlListener);
            header.addDisposeListener(this.headerDisposeListener);
        }
        return header;
    }

    private boolean resizedColumnIsNotTheLastColumn(int resizedColumnNumber, Table table) {
        return resizedColumnNumber < table.getColumnCount() - 1;
    }

    private int computePercentage(int totalAvailableWidth, int columnWidth) {
        return (int)((double)columnWidth / (double)totalAvailableWidth * 100.0);
    }

    private void adjustWeights(AbstractNativeHeader header, TableColumn resizedColumn) {
        int totalAvailableWidth = this.getAvailableWidth(header);
        int resizedColumnNumber = 0;
        int newTotalWidth = 0;
        TableColumn[] columns = resizedColumn.getParent().getColumns();
        int i = 0;
        while (i < columns.length) {
            newTotalWidth += columns[i].getWidth();
            if (columns[i] == resizedColumn) {
                resizedColumnNumber = i;
            }
            ++i;
        }
        Table table = resizedColumn.getParent();
        int[] columnOrder = table.getColumnOrder();
        int resizedColumnPosition = 0;
        int i2 = 0;
        while (i2 < columnOrder.length) {
            if (columnOrder[i2] == resizedColumnNumber) {
                resizedColumnPosition = i2;
                break;
            }
            ++i2;
        }
        if (this.resizedColumnIsNotTheLastColumn(resizedColumnPosition, resizedColumn.getParent())) {
            int columnToTheRightOfResizedColumnWidth;
            int resizedColumnWidth = resizedColumn.getWidth();
            int columnWidthChange = this.lastWidths[columnOrder[resizedColumnPosition]] - resizedColumnWidth;
            int columnWidthChangeTooFar = 5 - resizedColumnWidth;
            if (columnWidthChangeTooFar > 0) {
                columnWidthChange -= columnWidthChangeTooFar;
                resizedColumnWidth = 5;
                resizedColumn.setWidth(resizedColumnWidth);
            }
            if ((columnWidthChangeTooFar = 5 - (columnToTheRightOfResizedColumnWidth = this.lastWidths[columnOrder[resizedColumnPosition + 1]] + columnWidthChange)) > 0) {
                columnWidthChange += columnWidthChangeTooFar;
                resizedColumn.setWidth(resizedColumnWidth -= columnWidthChangeTooFar);
                columnToTheRightOfResizedColumnWidth = 5;
            }
            TableColumn columnToTheRightOfResizedColumn = columns[columnOrder[resizedColumnPosition + 1]];
            columnToTheRightOfResizedColumn.setWidth(columnToTheRightOfResizedColumnWidth);
            if (this.isFittingHorizontally()) {
                this.adjustWeightedHeader(header, resizedColumnPosition, resizedColumn, columnToTheRightOfResizedColumn, totalAvailableWidth, newTotalWidth);
            } else if (this.isWidthWiderThanAllColumns(header)) {
                this.adjustScaledAbsoluteWidthWeights(resizedColumnPosition, resizedColumnWidth, columnToTheRightOfResizedColumnWidth, header.getSize().x);
            } else {
                this.adjustNonScaledAbsoluteWidthWeights(resizedColumnPosition, resizedColumnWidth, columnToTheRightOfResizedColumnWidth);
            }
            this.fireColumnResizedEvent(resizedColumnPosition, resizedColumnWidth, columnToTheRightOfResizedColumnWidth);
        } else {
            this.layout(header, true);
        }
    }

    void addColumnControlListener(ColumnControlListener l) {
        this.columnControlListeners.add(l);
    }

    void removeColumnControlListener(ColumnControlListener l) {
        this.columnControlListeners.remove(l);
    }

    private void fireColumnResizedEvent(int resizedColumnNumber, int resizedColumnWidth, int columnToTheRightOfResizedColumnWidth) {
        for (ColumnControlListener l : this.columnControlListeners) {
            l.columnResized(resizedColumnNumber, resizedColumnWidth, columnToTheRightOfResizedColumnWidth);
        }
    }

    private void fireColumnMovedEvent(int[] newColumnOrder) {
        for (ColumnControlListener l : this.columnControlListeners) {
            l.columnMoved(newColumnOrder);
        }
    }

    private void adjustWeightedHeader(AbstractNativeHeader header, int resizedColumnPosition, TableColumn resizedColumn, TableColumn columnToTheRightOfResizedColumn, int totalAvailableWidth, int newTotalWidth) {
        int resizedColumnPercentage;
        int[] weights = this.getWeights();
        weights[resizedColumnPosition] = resizedColumnPercentage = this.computePercentage(totalAvailableWidth, resizedColumn.getWidth());
        this.giveRemainderToWeightAtColumn(resizedColumnPosition + 1);
        this.setWeights(weights);
    }

    private void adjustScaledAbsoluteWidthWeights(int resizedColumnPosition, int resizedColumnWidth, int columnToTheRightOfResizedColumnWidth, int headerWidth) {
        int sumOfAllWeights = this.getSumOfAllWeights();
        double scalingFactor = (double)headerWidth / (double)sumOfAllWeights;
        int unscaledResizedColumWidth = (int)((double)resizedColumnWidth / scalingFactor);
        int unscaledColumnToTheRightOfResizedColumnWidth = (int)((double)columnToTheRightOfResizedColumnWidth / scalingFactor);
        this.adjustNonScaledAbsoluteWidthWeights(resizedColumnPosition, unscaledResizedColumWidth, unscaledColumnToTheRightOfResizedColumnWidth);
    }

    private void adjustNonScaledAbsoluteWidthWeights(int resizedColumnPosition, int resizedColumnWidth, int columnToTheRightOfResizedColumnWidth) {
        int oldWeightSum;
        int[] weights = this.getWeights();
        int currentWeightSum = oldWeightSum = this.getSumOfAllWeights();
        currentWeightSum += weights[resizedColumnPosition] - resizedColumnWidth;
        int weightSumChange = oldWeightSum - (currentWeightSum += weights[resizedColumnPosition + 1] - columnToTheRightOfResizedColumnWidth);
        weights[resizedColumnPosition] = resizedColumnWidth;
        weights[resizedColumnPosition + 1] = columnToTheRightOfResizedColumnWidth -= weightSumChange;
        this.setWeights(weights);
    }

    private void giveRemainderToWeightAtColumn(int columnNumber) {
        int[] weights = this.getWeights();
        int totalWeightPercentage = 0;
        int i = 0;
        while (i < weights.length) {
            totalWeightPercentage += weights[i];
            ++i;
        }
        int spareWidthPercentage = 100 - totalWeightPercentage;
        int n = columnNumber;
        weights[n] = weights[n] + spareWidthPercentage;
    }

    private class HeaderControlListener
    implements ControlListener {
        private HeaderControlListener() {
        }

        public void controlMoved(ControlEvent e) {
            if (HeaderLayout.this.wasResized) {
                HeaderLayout.this.wasResized = false;
                return;
            }
            Table table = HeaderLayout.this.header.headerTable;
            HeaderLayout.this.fireColumnMovedEvent(table.getColumnOrder());
            HeaderLayout.this.storeLastWidths(table);
        }

        public void controlResized(ControlEvent e) {
            if (HeaderLayout.this.lastWidths == null) {
                return;
            }
            HeaderLayout.this.wasResized = true;
            if (!HeaderLayout.this.layingOut) {
                HeaderLayout.this.layingOut = true;
                try {
                    TableColumn tableColumn = (TableColumn)e.widget;
                    AbstractNativeHeader header = HeaderLayout.this.asHeader((Widget)tableColumn.getParent().getParent());
                    HeaderLayout.this.adjustWeights(header, tableColumn);
                    HeaderLayout.this.storeLastWidths(tableColumn.getParent());
                }
                finally {
                    HeaderLayout.this.layingOut = false;
                }
            }
        }
    }
}

