/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal.dialog;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.xviewer.XViewerText;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerTextWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DialogWithEntry
extends MessageDialog {
    XViewerTextWidget text;
    Composite comp;
    String entryText = "";
    String validationRegularExpression = null;
    String validationErrorString = "";
    Button ok;
    MouseMoveListener listener;
    Label errorLabel;
    boolean fillVertically = false;
    private static Font font = null;
    private Button fontButton;

    public DialogWithEntry(String dialogTitle, String dialogMessage) {
        super(Display.getCurrent().getActiveShell(), dialogTitle, null, dialogMessage, 3, new String[]{XViewerText.get("button.ok"), XViewerText.get("button.cancel")}, 0);
    }

    public DialogWithEntry(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
    }

    protected Control createCustomArea(Composite parent) {
        this.comp = new Composite(parent, 0);
        this.comp.setLayout((Layout)new GridLayout(2, false));
        this.comp.setLayoutData((Object)new GridData(1808));
        this.listener = new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                DialogWithEntry.this.setInitialButtonState();
            }
        };
        this.comp.addMouseMoveListener(this.listener);
        Composite headerComp = new Composite(this.comp, 0);
        headerComp.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        headerComp.setLayoutData((Object)gd);
        if (this.fillVertically) {
            Button button = new Button(headerComp, 8);
            button.setText(XViewerText.get("button.clear"));
            button.addListener(13, e -> this.text.setText(""));
            this.fontButton = new Button(headerComp, 32);
            this.fontButton.setText(XViewerText.get("DialogWithEntry.button.font"));
            this.fontButton.addListener(13, e -> {
                if (this.fontButton.getSelection()) {
                    if (font == null) {
                        font = new Font((Device)Display.getCurrent(), "Courier New", 8, 0);
                    }
                    this.text.setFont(font);
                } else {
                    this.text.setFont(null);
                }
            });
        }
        this.errorLabel = new Label(headerComp, 0);
        this.errorLabel.setSize(this.errorLabel.computeSize(-1, -1));
        this.errorLabel.setText("");
        if (!this.fillVertically) {
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.errorLabel.setLayoutData((Object)gd);
        }
        this.createExtendedAreaPre(this.comp);
        this.text = new XViewerTextWidget();
        this.text.setFillHorizontally(true);
        this.text.setFocus();
        this.text.setDisplayLabel(false);
        if (this.fillVertically) {
            this.text.setFillVertically(true);
            this.text.setHeight(200);
            this.text.setFont(font);
        }
        this.text.createWidgets(this.comp, 2);
        if (!this.entryText.equals("")) {
            this.text.set(this.entryText);
        }
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DialogWithEntry.this.handleModified();
            }
        };
        this.text.addModifyListener(modifyListener);
        this.createExtendedArea(this.comp);
        this.comp.layout();
        parent.layout();
        return this.comp;
    }

    protected void createExtendedAreaPre(Composite parent) {
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createExtendedArea(Composite parent) {
    }

    public void setInitialButtonState() {
        if (this.ok == null) {
            this.ok = this.getButton(0);
            this.handleModified();
        }
        this.comp.removeMouseMoveListener(this.listener);
    }

    public void handleModified() {
        if (this.text != null) {
            this.entryText = this.text.get();
            if (!this.isEntryValid()) {
                this.getButton(this.getDefaultButtonIndex()).setEnabled(false);
                this.errorLabel.setText(this.validationErrorString);
                this.errorLabel.update();
                this.comp.layout();
            } else {
                this.getButton(this.getDefaultButtonIndex()).setEnabled(true);
                this.errorLabel.setText("");
                this.errorLabel.update();
                this.comp.layout();
            }
        }
    }

    public String getEntry() {
        return this.entryText;
    }

    public void setEntry(String entry) {
        if (this.text != null) {
            this.text.set(entry);
        }
        this.entryText = entry;
    }

    public boolean isEntryValid() {
        if (this.validationRegularExpression == null) {
            return true;
        }
        Matcher m = Pattern.compile(this.validationRegularExpression).matcher(this.text.get());
        return m.find();
    }

    public void setValidationRegularExpression(String regExp) {
        this.validationRegularExpression = regExp;
    }

    public void setValidationErrorString(String errorText) {
        this.validationErrorString = errorText;
    }

    public void setModeless() {
        this.setShellStyle(2144);
        this.setBlockOnOpen(false);
    }

    public void setSelectionListener(SelectionListener listener) {
        int i = 0;
        while (i < this.getButtonLabels().length) {
            Button button = this.getButton(i);
            button.addSelectionListener(listener);
            ++i;
        }
    }

    public boolean isFillVertically() {
        return this.fillVertically;
    }

    public void setFillVertically(boolean fillVertically) {
        this.fillVertically = fillVertically;
    }
}

