/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.datechooser;

import java.util.Date;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.nebula.widgets.datechooser.DateChooserCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class DateChooserComboCellEditor
extends CellEditor {
    protected DateChooserCombo combo;
    private static final int defaultStyle = 4;

    public DateChooserComboCellEditor(Composite parent) {
        this(parent, 4);
    }

    public DateChooserComboCellEditor(Composite parent, int style) {
        super(parent, style);
        this.setValueValid(true);
    }

    protected Control createControl(Composite parent) {
        this.combo = new DateChooserCombo(parent, this.getStyle());
        this.combo.setFont(parent.getFont());
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 31: {
                        if (event.detail != 2 && event.detail != 4) break;
                        event.doit = false;
                        break;
                    }
                    case 16: {
                        DateChooserComboCellEditor.this.focusLost();
                    }
                }
            }
        };
        this.combo.addListener(31, listener);
        this.combo.addListener(16, listener);
        return this.combo;
    }

    protected Object doGetValue() {
        return this.combo.getValue();
    }

    protected void doSetFocus() {
        this.combo.setFocus();
    }

    protected void doSetValue(Object value) {
        if (this.combo == null || this.combo.isDisposed()) {
            SWT.error((int)24);
        }
        if (value instanceof Date) {
            this.combo.setValue((Date)value);
        }
    }

    public DateChooserCombo getCombo() {
        return this.combo;
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = new CellEditor.LayoutData();
        if (this.combo == null || this.combo.isDisposed()) {
            layoutData.minimumWidth = 60;
        }
        return layoutData;
    }
}

