/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.figures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.xygraph.Messages;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProviderListener;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IMetaData;
import org.eclipse.nebula.visualization.xygraph.dataprovider.ISample;
import org.eclipse.nebula.visualization.xygraph.dataprovider.Sample;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IAxisListener;
import org.eclipse.nebula.visualization.xygraph.figures.ITraceListener;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Legend;
import org.eclipse.nebula.visualization.xygraph.figures.NoRepeatsPointsList;
import org.eclipse.nebula.visualization.xygraph.linearscale.AbstractScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.nebula.visualization.xygraph.styleprovider.IPointStyleProvider;
import org.eclipse.nebula.visualization.xygraph.util.Preferences;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class Trace
extends Figure
implements IDataProviderListener,
IAxisListener {
    private static final int MARKER_SIZE = 6;
    private final boolean use_advanced_graphics = Preferences.useAdvancedGraphics();
    private final List<ITraceListener> listeners = new ArrayList<ITraceListener>();
    private String name;
    private IDataProvider traceDataProvider;
    private Axis xAxis;
    private Axis yAxis;
    private Color traceColor;
    private TraceType traceType = TraceType.SOLID_LINE;
    private BaseLine baseLine = BaseLine.ZERO;
    private PointStyle pointStyle = PointStyle.NONE;
    private int lineWidth = 1;
    private int pointSize = 4;
    private int areaAlpha = 100;
    private boolean antiAliasing = true;
    private boolean errorBarEnabled = false;
    private ErrorBarType yErrorBarType = ErrorBarType.BOTH;
    private ErrorBarType xErrorBarType = ErrorBarType.BOTH;
    private int errorBarCapWidth = 4;
    private boolean errorBarColorSetFlag = false;
    private Color errorBarColor;
    private boolean drawYErrorInArea = false;
    private IXYGraph xyGraph;
    private List<ISample> hotSampleist;
    private IPointStyleProvider fPointStyleProvider;

    public void addListener(ITraceListener listener) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public boolean removeListener(ITraceListener listener) {
        return this.listeners.remove(listener);
    }

    public void setPointStyleProvider(IPointStyleProvider pointStyleProvider) {
        this.fPointStyleProvider = pointStyleProvider;
    }

    public IPointStyleProvider getPointStyleProvider() {
        return this.fPointStyleProvider;
    }

    public Trace(String name) {
        this.setName(name);
    }

    public Trace(String name, Axis xAxis, Axis yAxis, IDataProvider dataProvider) {
        this.setName(name);
        this.internalInit(xAxis, yAxis, dataProvider);
    }

    public void init(Axis xAxis, Axis yAxis, IDataProvider dataProvider) {
        this.internalInit(xAxis, yAxis, dataProvider);
    }

    private void internalInit(Axis xAxis, Axis yAxis, IDataProvider dataProvider) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        xAxis.addTrace(this);
        yAxis.addTrace(this);
        xAxis.addListener(this);
        yAxis.addListener(this);
        this.setDataProvider(dataProvider);
        this.hotSampleist = new ArrayList<ISample>();
    }

    private void drawErrorBar(Graphics graphics, Point dpPos, ISample dp) {
        Point ep;
        graphics.pushState();
        graphics.setForegroundColor(this.errorBarColor);
        graphics.setLineStyle(1);
        graphics.setLineWidth(1);
        switch (this.yErrorBarType) {
            case MINUS: 
            case BOTH: {
                ep = new Point(this.xAxis.getValuePosition(dp.getXValue(), false), this.yAxis.getValuePosition(dp.getYValue() - dp.getYMinusError(), false));
                graphics.drawLine(dpPos, ep);
                graphics.drawLine(ep.x - this.errorBarCapWidth / 2, ep.y, ep.x + this.errorBarCapWidth / 2, ep.y);
                if (this.yErrorBarType != ErrorBarType.BOTH) break;
            }
            case PLUS: {
                ep = new Point(this.xAxis.getValuePosition(dp.getXValue(), false), this.yAxis.getValuePosition(dp.getYValue() + dp.getYPlusError(), false));
                graphics.drawLine(dpPos, ep);
                graphics.drawLine(ep.x - this.errorBarCapWidth / 2, ep.y, ep.x + this.errorBarCapWidth / 2, ep.y);
                break;
            }
        }
        switch (this.xErrorBarType) {
            case MINUS: 
            case BOTH: {
                ep = new Point(this.xAxis.getValuePosition(dp.getXValue() - dp.getXMinusError(), false), this.yAxis.getValuePosition(dp.getYValue(), false));
                graphics.drawLine(dpPos, ep);
                graphics.drawLine(ep.x, ep.y - this.errorBarCapWidth / 2, ep.x, ep.y + this.errorBarCapWidth / 2);
                if (this.xErrorBarType != ErrorBarType.BOTH) break;
            }
            case PLUS: {
                ep = new Point(this.xAxis.getValuePosition(dp.getXValue() + dp.getXPlusError(), false), this.yAxis.getValuePosition(dp.getYValue(), false));
                graphics.drawLine(dpPos, ep);
                graphics.drawLine(ep.x, ep.y - this.errorBarCapWidth / 2, ep.x, ep.y + this.errorBarCapWidth / 2);
                break;
            }
        }
        graphics.popState();
    }

    private void drawYErrorArea(Graphics graphics, ISample predp, ISample dp, Point predpPos, Point dpPos) {
        if (predp.getYPlusError() == 0.0 && predp.getYMinusError() == 0.0 && dp.getYPlusError() == 0.0 && dp.getYMinusError() == 0.0) {
            return;
        }
        graphics.pushState();
        Color lighter = null;
        if (this.use_advanced_graphics) {
            graphics.setBackgroundColor(this.errorBarColor);
            graphics.setAlpha(this.areaAlpha);
        } else {
            float[] hsb = this.errorBarColor.getRGB().getHSB();
            lighter = new Color((Device)Display.getCurrent(), new RGB(hsb[0], hsb[1] * (float)this.areaAlpha / 255.0f, 1.0f));
            graphics.setBackgroundColor(lighter);
        }
        int predp_xpos = this.xAxis.getValuePosition(predp.getXValue(), false);
        int dp_xpos = this.xAxis.getValuePosition(dp.getXValue(), false);
        switch (this.yErrorBarType) {
            case PLUS: 
            case BOTH: {
                Point preEp = new Point(predp_xpos, this.yAxis.getValuePosition(predp.getYValue() + predp.getYPlusError(), false));
                Point ep = new Point(dp_xpos, this.yAxis.getValuePosition(dp.getYValue() + dp.getYPlusError(), false));
                graphics.fillPolygon(new int[]{predpPos.x, predpPos.y, preEp.x, preEp.y, ep.x, ep.y, dpPos.x, dpPos.y});
                if (this.yErrorBarType != ErrorBarType.BOTH) break;
            }
            case MINUS: {
                Point preEp = new Point(predp_xpos, this.yAxis.getValuePosition(predp.getYValue() - predp.getYMinusError(), false));
                Point ep = new Point(dp_xpos, this.yAxis.getValuePosition(dp.getYValue() - dp.getYMinusError(), false));
                graphics.fillPolygon(new int[]{predpPos.x, predpPos.y, preEp.x, preEp.y, ep.x, ep.y, dpPos.x, dpPos.y});
                break;
            }
        }
        graphics.popState();
        if (lighter != null) {
            lighter.dispose();
        }
    }

    public void drawPoint(Graphics graphics, Point pos) {
        this.drawPoint(graphics, pos, null);
    }

    private void drawPoint(Graphics graphics, Point pos, ISample sample) {
        Color renderColor = this.traceColor;
        PointStyle renderPointStyle = this.pointStyle;
        int renderPointSize = this.pointSize;
        try {
            if (this.fPointStyleProvider != null && sample != null) {
                renderColor = this.fPointStyleProvider.getPointColor(sample, this);
                renderPointStyle = this.fPointStyleProvider.getPointStyle(sample, this);
                renderPointSize = this.fPointStyleProvider.getPointSize(sample, this);
            }
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
            renderColor = this.traceColor;
            renderPointStyle = this.pointStyle;
            renderPointSize = this.pointSize;
        }
        if (renderPointStyle == PointStyle.NONE) {
            return;
        }
        graphics.pushState();
        graphics.setBackgroundColor(renderColor);
        graphics.setForegroundColor(renderColor);
        graphics.setLineWidth(1);
        graphics.setLineStyle(1);
        int halfSize = renderPointSize / 2;
        switch (renderPointStyle) {
            case POINT: {
                graphics.fillOval(new Rectangle(pos.x - halfSize, pos.y - halfSize, renderPointSize, renderPointSize));
                break;
            }
            case CIRCLE: {
                graphics.drawOval(new Rectangle(pos.x - halfSize, pos.y - halfSize, renderPointSize, renderPointSize));
                break;
            }
            case FILLED_CIRCLE: {
                graphics.fillOval(new Rectangle(pos.x - halfSize, pos.y - halfSize, renderPointSize, renderPointSize));
                break;
            }
            case TRIANGLE: {
                graphics.drawPolygon(new int[]{pos.x - halfSize, pos.y + halfSize, pos.x, pos.y - halfSize, pos.x + halfSize, pos.y + halfSize});
                break;
            }
            case FILLED_TRIANGLE: {
                graphics.fillPolygon(new int[]{pos.x - halfSize, pos.y + halfSize, pos.x, pos.y - halfSize, pos.x + halfSize, pos.y + halfSize});
                break;
            }
            case SQUARE: {
                graphics.drawRectangle(new Rectangle(pos.x - halfSize, pos.y - halfSize, renderPointSize, renderPointSize));
                break;
            }
            case FILLED_SQUARE: {
                graphics.fillRectangle(new Rectangle(pos.x - halfSize, pos.y - halfSize, renderPointSize, renderPointSize));
                break;
            }
            case BAR: {
                graphics.drawLine(pos.x, pos.y - halfSize, pos.x, pos.y + halfSize);
                break;
            }
            case CROSS: {
                graphics.drawLine(pos.x, pos.y - halfSize, pos.x, pos.y + halfSize);
                graphics.drawLine(pos.x - halfSize, pos.y, pos.x + halfSize, pos.y);
                break;
            }
            case XCROSS: {
                graphics.drawLine(pos.x - halfSize, pos.y - halfSize, pos.x + halfSize, pos.y + halfSize);
                graphics.drawLine(pos.x + halfSize, pos.y - halfSize, pos.x - halfSize, pos.y + halfSize);
                break;
            }
            case DIAMOND: {
                graphics.drawPolyline(new int[]{pos.x, pos.y - halfSize, pos.x - halfSize, pos.y, pos.x, pos.y + halfSize, pos.x + halfSize, pos.y, pos.x, pos.y - halfSize});
                break;
            }
            case FILLED_DIAMOND: {
                graphics.fillPolygon(new int[]{pos.x, pos.y - halfSize, pos.x - halfSize, pos.y, pos.x, pos.y + halfSize, pos.x + halfSize, pos.y});
                break;
            }
        }
        graphics.popState();
    }

    public void drawLine(Graphics graphics, Point p1, Point p2) {
        graphics.pushState();
        graphics.setLineWidth(this.lineWidth);
        switch (this.traceType) {
            case SOLID_LINE: {
                graphics.setLineStyle(1);
                graphics.drawLine(p1, p2);
                break;
            }
            case BAR: {
                if (this.use_advanced_graphics) {
                    graphics.setAlpha(this.areaAlpha);
                }
                graphics.setLineStyle(1);
                graphics.drawLine(p1, p2);
                break;
            }
            case DASH_LINE: {
                graphics.setLineStyle(2);
                graphics.drawLine(p1, p2);
                break;
            }
            case DASHDOT_LINE: {
                graphics.setLineStyle(4);
                graphics.drawLine(p1, p2);
                break;
            }
            case DASHDOTDOT_LINE: {
                graphics.setLineStyle(5);
                graphics.drawLine(p1, p2);
                break;
            }
            case DOT_LINE: {
                graphics.setLineStyle(3);
                graphics.drawLine(p1, p2);
                break;
            }
            case AREA: 
            case LINE_AREA: {
                if (this.traceType == TraceType.LINE_AREA) {
                    graphics.setLineStyle(1);
                    graphics.drawLine(p1, p2);
                }
                int basey = switch (this.baseLine) {
                    case BaseLine.NEGATIVE_INFINITY -> this.yAxis.getValuePosition(this.yAxis.getRange().getLower(), false);
                    case BaseLine.POSITIVE_INFINITY -> this.yAxis.getValuePosition(this.yAxis.getRange().getUpper(), false);
                    default -> this.yAxis.getValuePosition(0.0, false);
                };
                if (this.use_advanced_graphics) {
                    graphics.setAlpha(this.areaAlpha);
                }
                graphics.setBackgroundColor(this.traceColor);
                graphics.fillPolygon(new int[]{p1.x, p1.y, p1.x, basey, p2.x, basey, p2.x, p2.y});
                break;
            }
            case STEP_HORIZONTALLY: {
                graphics.setLineStyle(1);
                graphics.drawLine(p1.x, p1.y, p2.x, p1.y);
                graphics.drawLine(p2.x, p1.y, p2.x, p2.y);
                break;
            }
            case STEP_VERTICALLY: {
                graphics.setLineStyle(1);
                graphics.drawLine(p1.x, p1.y, p1.x, p2.y);
                graphics.drawLine(p1.x, p2.y, p2.x, p2.y);
                break;
            }
        }
        graphics.popState();
    }

    private void drawPolyline(Graphics graphics, PointList pl) {
        graphics.pushState();
        graphics.setLineWidth(this.lineWidth);
        switch (this.traceType) {
            case SOLID_LINE: 
            case STEP_VERTICALLY: 
            case STEP_HORIZONTALLY: {
                graphics.setLineStyle(1);
                graphics.drawPolyline(pl);
                break;
            }
            case DASH_LINE: {
                graphics.setLineStyle(2);
                graphics.drawPolyline(pl);
                break;
            }
            case DASHDOT_LINE: {
                graphics.setLineStyle(4);
                graphics.drawPolyline(pl);
                break;
            }
            case DASHDOTDOT_LINE: {
                graphics.setLineStyle(5);
                graphics.drawPolyline(pl);
                break;
            }
            case DOT_LINE: {
                graphics.setLineStyle(3);
                graphics.drawPolyline(pl);
                break;
            }
        }
        graphics.popState();
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        graphics.pushState();
        try {
            this.paintInternalFigure(graphics);
        }
        finally {
            graphics.popState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void paintInternalFigure(Graphics graphics) {
        block75: {
            if (this.use_advanced_graphics) {
                graphics.setAntialias(this.antiAliasing != false ? 1 : 0);
            }
            graphics.setForegroundColor(this.traceColor);
            graphics.setLineWidth(this.lineWidth);
            predp = null;
            predpInRange = false;
            dpPos = null;
            this.hotSampleist.clear();
            if (this.traceDataProvider == null) {
                throw new RuntimeException("No DataProvider defined for trace: " + this.name);
            }
            var5_5 = this.traceDataProvider;
            synchronized (var5_5) {
                if (this.traceDataProvider.getSize() <= 0) break block75;
                if (this.traceDataProvider.isChronological()) {
                    indexRange = this.getIndexRangeOnXAxis();
                    if (indexRange == null) {
                        startIndex = 0;
                        endIndex = -1;
                    } else {
                        startIndex = (int)indexRange.getLower();
                        endIndex = (int)indexRange.getUpper();
                    }
                } else {
                    startIndex = 0;
                    endIndex = this.traceDataProvider.getSize() - 1;
                }
                hsPoint = new HashSet<Point>();
                plPolyline = new NoRepeatsPointsList();
                bottomPoints = new HashMap<Integer, Integer>();
                topPoints = new HashMap<Integer, Integer>();
                maxInRegion = null;
                minInRegion = null;
                lastInRegion = null;
                i = startIndex;
                while (i <= endIndex) {
                    block76: {
                        block80: {
                            block78: {
                                block79: {
                                    block77: {
                                        dp = this.traceDataProvider.getSample(i);
                                        if (dp == null) break block76;
                                        dpInXRange = this.xAxis.getRange().inRange(dp.getXValue());
                                        valueIsNaN = Double.isNaN(dp.getYValue());
                                        if (dpInXRange && valueIsNaN) {
                                            markPos = new Point(this.xAxis.getValuePosition(dp.getXValue(), false), this.yAxis.getValuePosition(this.xAxis.getTickLabelSide() == AbstractScale.LabelSide.Primary ? this.yAxis.getRange().getLower() : this.yAxis.getRange().getUpper(), false));
                                            graphics.setBackgroundColor(this.traceColor);
                                            graphics.fillRectangle(markPos.x - 3, markPos.y - 3, 6, 6);
                                            nanSample = new Sample(dp.getXValue(), this.xAxis.getTickLabelSide() == AbstractScale.LabelSide.Primary ? this.yAxis.getRange().getLower() : this.yAxis.getRange().getUpper(), dp.getYPlusError(), dp.getYMinusError(), NaN, dp.getXMinusError(), dp.getInfo());
                                            if (dp instanceof IMetaData) {
                                                nanSample.setData(((IMetaData)dp).getData());
                                            }
                                            this.hotSampleist.add(nanSample);
                                        }
                                        v0 = dpInRange = dpInXRange != false && this.yAxis.getRange().inRange(dp.getYValue()) != false;
                                        if (dpInRange) {
                                            dpPos = new Point(this.xAxis.getValuePosition(dp.getXValue(), false), this.yAxis.getValuePosition(dp.getYValue(), false));
                                            this.hotSampleist.add(dp);
                                            if (!hsPoint.contains(dpPos)) {
                                                this.drawPoint(graphics, dpPos, dp);
                                                hsPoint.add(dpPos);
                                            }
                                            if (this.errorBarEnabled && !this.drawYErrorInArea) {
                                                this.drawErrorBar(graphics, dpPos, dp);
                                            }
                                        }
                                        if (this.traceType == TraceType.POINT && !this.drawYErrorInArea) break block76;
                                        if (this.traceType == TraceType.BAR) {
                                            switch (Trace.$SWITCH_TABLE$org$eclipse$nebula$visualization$xygraph$figures$Trace$BaseLine()[this.baseLine.ordinal()]) {
                                                case 1: {
                                                    predp = new Sample(dp.getXValue(), this.yAxis.getRange().getLower());
                                                    break;
                                                }
                                                case 3: {
                                                    predp = new Sample(dp.getXValue(), this.yAxis.getRange().getUpper());
                                                    break;
                                                }
                                                default: {
                                                    predp = new Sample(dp.getXValue(), 0.0);
                                                }
                                            }
                                            v1 = predpInRange = this.xAxis.getRange().inRange(predp.getXValue()) != false && this.yAxis.getRange().inRange(predp.getYValue()) != false;
                                        }
                                        if (predp != null) break block77;
                                        predp = dp;
                                        predpInRange = dpInRange;
                                        break block76;
                                    }
                                    origin_dp = dp;
                                    origin_dpInRange = dpInRange;
                                    if (valueIsNaN && !Double.isNaN(predp.getYValue()) && (this.traceType == TraceType.STEP_HORIZONTALLY || this.traceType == TraceType.STEP_VERTICALLY)) {
                                        dp = new Sample(dp.getXValue(), predp.getYValue());
                                        dpInRange = this.yAxis.getRange().inRange(dp.getYValue());
                                    }
                                    if (this.traceType == TraceType.AREA || this.traceType == TraceType.LINE_AREA) ** GOTO lbl-1000
                                    if (predpInRange || dpInRange) break block78;
                                    dpTuple = this.getIntersection(predp, dp);
                                    if (dpTuple[0] != null && dpTuple[1] != null) break block79;
                                    predp = origin_dp;
                                    predpInRange = origin_dpInRange;
                                    break block76;
                                }
                                predp = dpTuple[0];
                                dp = dpTuple[1];
                                ** GOTO lbl-1000
                            }
                            if (predpInRange && dpInRange) ** GOTO lbl-1000
                            if (predpInRange) break block80;
                            if ((predp = this.getIntersection(predp, dp)[0]) != null) ** GOTO lbl-1000
                            predp = origin_dp;
                            predpInRange = origin_dpInRange;
                            break block76;
                        }
                        if ((dp = this.getIntersection(predp, dp)[0]) == null) {
                            predp = origin_dp;
                            predpInRange = origin_dpInRange;
                        } else lbl-1000:
                        // 5 sources

                        {
                            predpPos = new Point(this.xAxis.getValuePosition(predp.getXValue(), false), this.yAxis.getValuePosition(predp.getYValue(), false));
                            dpPos = new Point(this.xAxis.getValuePosition(dp.getXValue(), false), this.yAxis.getValuePosition(dp.getYValue(), false));
                            if (!dpPos.equals((Object)predpPos)) {
                                if (this.errorBarEnabled && this.drawYErrorInArea && this.traceType != TraceType.BAR) {
                                    this.drawYErrorArea(graphics, predp, dp, predpPos, dpPos);
                                }
                                switch (Trace.$SWITCH_TABLE$org$eclipse$nebula$visualization$xygraph$figures$Trace$TraceType()[this.traceType.ordinal()]) {
                                    case 1: 
                                    case 2: 
                                    case 7: 
                                    case 8: 
                                    case 9: 
                                    case 10: 
                                    case 11: {
                                        if (plPolyline.size() == 0) {
                                            plPolyline.addPoint(predpPos);
                                        }
                                        if (this.traceDataProvider.isChronological()) {
                                            if (!predpPos.equals((Object)plPolyline.getLastPoint()) && predpPos.x != plPolyline.getLastPoint().x) {
                                                if (lastInRegion != null) {
                                                    if (minInRegion != null) {
                                                        plPolyline.addPoint(minInRegion);
                                                    }
                                                    if (maxInRegion != null) {
                                                        plPolyline.addPoint(maxInRegion);
                                                    }
                                                    plPolyline.addPoint(lastInRegion);
                                                    minInRegion = null;
                                                    maxInRegion = null;
                                                    lastInRegion = null;
                                                }
                                                this.drawPolyline(graphics, plPolyline);
                                                plPolyline.removeAllPoints();
                                                plPolyline.addPoint(predpPos);
                                                switch (Trace.$SWITCH_TABLE$org$eclipse$nebula$visualization$xygraph$figures$Trace$TraceType()[this.traceType.ordinal()]) {
                                                    case 8: {
                                                        plPolyline.addPoint(dpPos.x, predpPos.y);
                                                        break;
                                                    }
                                                    case 7: {
                                                        plPolyline.addPoint(predpPos.x, dpPos.y);
                                                        break;
                                                    }
                                                }
                                                plPolyline.addPoint(dpPos);
                                                break;
                                            }
                                            if (predpPos.x != dpPos.x) {
                                                if (lastInRegion == null) {
                                                    switch (Trace.$SWITCH_TABLE$org$eclipse$nebula$visualization$xygraph$figures$Trace$TraceType()[this.traceType.ordinal()]) {
                                                        case 8: {
                                                            plPolyline.addPoint(dpPos.x, predpPos.y);
                                                            break;
                                                        }
                                                        case 7: {
                                                            plPolyline.addPoint(predpPos.x, dpPos.y);
                                                            break;
                                                        }
                                                    }
                                                    plPolyline.addPoint(dpPos);
                                                } else {
                                                    if (minInRegion != null) {
                                                        plPolyline.addPoint(minInRegion);
                                                    }
                                                    if (maxInRegion != null) {
                                                        plPolyline.addPoint(maxInRegion);
                                                    }
                                                    plPolyline.addPoint(lastInRegion);
                                                    switch (Trace.$SWITCH_TABLE$org$eclipse$nebula$visualization$xygraph$figures$Trace$TraceType()[this.traceType.ordinal()]) {
                                                        case 8: {
                                                            plPolyline.addPoint(dpPos.x, lastInRegion.y);
                                                            break;
                                                        }
                                                        case 7: {
                                                            plPolyline.addPoint(lastInRegion.x, dpPos.y);
                                                            break;
                                                        }
                                                    }
                                                    plPolyline.addPoint(dpPos);
                                                }
                                                minInRegion = null;
                                                maxInRegion = null;
                                                lastInRegion = null;
                                                break;
                                            }
                                            if (lastInRegion == null) {
                                                lastInRegion = dpPos;
                                                break;
                                            }
                                            if (minInRegion == null) {
                                                minInRegion = lastInRegion;
                                                lastInRegion = dpPos;
                                                break;
                                            }
                                            if (maxInRegion == null) {
                                                if (minInRegion.y > lastInRegion.y) {
                                                    maxInRegion = minInRegion;
                                                    minInRegion = lastInRegion;
                                                } else {
                                                    maxInRegion = lastInRegion;
                                                }
                                                lastInRegion = dpPos;
                                                break;
                                            }
                                            if (lastInRegion.y > maxInRegion.y) {
                                                maxInRegion = lastInRegion;
                                            } else if (lastInRegion.y < minInRegion.y) {
                                                minInRegion = lastInRegion;
                                            }
                                            lastInRegion = dpPos;
                                            break;
                                        }
                                        if (!predpPos.equals((Object)plPolyline.getLastPoint())) {
                                            this.drawPolyline(graphics, plPolyline);
                                            plPolyline.removeAllPoints();
                                            plPolyline.addPoint(predpPos);
                                        }
                                        switch (Trace.$SWITCH_TABLE$org$eclipse$nebula$visualization$xygraph$figures$Trace$TraceType()[this.traceType.ordinal()]) {
                                            case 8: {
                                                plPolyline.addPoint(dpPos.x, predpPos.y);
                                                break;
                                            }
                                            case 7: {
                                                plPolyline.addPoint(predpPos.x, dpPos.y);
                                                break;
                                            }
                                        }
                                        plPolyline.addPoint(dpPos);
                                        break;
                                    }
                                    case 4: {
                                        if (!this.use_advanced_graphics && predpPos.x() == dpPos.x()) {
                                            posX = predpPos.x();
                                            if (dpPos.y() > predpPos.y()) {
                                                highY = dpPos.y();
                                                lowY = predpPos.y();
                                            } else {
                                                highY = predpPos.y();
                                                lowY = dpPos.y();
                                            }
                                            if (bottomPoints.containsKey(posX)) {
                                                if (lowY.compareTo((Integer)bottomPoints.get(posX)) < 0) {
                                                    bottomPoints.put(posX, lowY);
                                                }
                                                if (highY.compareTo((Integer)topPoints.get(posX)) <= 0) break;
                                                topPoints.put(posX, highY);
                                                break;
                                            }
                                            bottomPoints.put(posX, lowY);
                                            topPoints.put(posX, highY);
                                            break;
                                        }
                                        this.drawLine(graphics, predpPos, dpPos);
                                        break;
                                    }
                                    default: {
                                        this.drawLine(graphics, predpPos, dpPos);
                                    }
                                }
                            }
                            predp = origin_dp;
                            predpInRange = origin_dpInRange;
                        }
                    }
                    ++i;
                }
                switch (Trace.$SWITCH_TABLE$org$eclipse$nebula$visualization$xygraph$figures$Trace$TraceType()[this.traceType.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        this.drawPolyline(graphics, plPolyline);
                        break;
                    }
                    case 4: {
                        xSet = bottomPoints.keySet();
                        for (Integer posX : xSet) {
                            p1 = new Point(posX.intValue(), ((Integer)bottomPoints.get(posX)).intValue());
                            p2 = new Point(posX.intValue(), ((Integer)topPoints.get(posX)).intValue());
                            this.drawLine(graphics, p1, p2);
                        }
                        break;
                    }
                }
            }
        }
    }

    private ISample[] getIntersection(ISample dp1, ISample dp2) {
        if (this.traceType == TraceType.STEP_HORIZONTALLY) {
            ISample[] ix;
            ISample[] result = new Sample[2];
            int count = 0;
            Sample dp = new Sample(dp2.getXValue(), dp1.getYValue());
            ISample[] iy = this.getStraightLineIntersection(dp1, dp);
            if (iy[1] != null) {
                return iy;
            }
            if (iy[0] != null) {
                result[count++] = iy[0];
            }
            if ((ix = this.getStraightLineIntersection(dp, dp2))[1] != null) {
                return ix;
            }
            if (ix[0] != null) {
                result[count++] = ix[0];
            }
            return result;
        }
        if (this.traceType == TraceType.STEP_VERTICALLY) {
            ISample[] iy;
            ISample[] result = new Sample[2];
            int count = 0;
            Sample dp = new Sample(dp1.getXValue(), dp2.getYValue());
            ISample[] ix = this.getStraightLineIntersection(dp1, dp);
            if (ix[1] != null) {
                return ix;
            }
            if (ix[0] != null) {
                result[count++] = ix[0];
            }
            if ((iy = this.getStraightLineIntersection(dp, dp2))[1] != null) {
                return iy;
            }
            if (iy[0] != null) {
                result[count++] = iy[0];
            }
            return result;
        }
        return this.getStraightLineIntersection(dp1, dp2);
    }

    private ISample[] getStraightLineIntersection(ISample dp1, ISample dp2) {
        double y;
        double x;
        double x1 = dp1.getXValue();
        double y1 = dp1.getYValue();
        double x2 = dp2.getXValue();
        double y2 = dp2.getYValue();
        double dx = x2 - x1;
        double dy = y2 - y1;
        ISample[] dpTuple = new Sample[2];
        int count = 0;
        if (dy != 0.0) {
            double ymax;
            double ymin = this.yAxis.getRange().getLower();
            x = (ymin - y1) * dx / dy + x1;
            if (this.evalDP(x, y = ymin, dp1, dp2)) {
                dpTuple[count++] = new Sample(x, y);
            }
            if (this.evalDP(x = ((ymax = this.yAxis.getRange().getUpper()) - y1) * dx / dy + x1, y = ymax, dp1, dp2)) {
                dpTuple[count++] = new Sample(x, y);
            }
        }
        if (count == 2) {
            return dpTuple;
        }
        if (dx != 0.0) {
            double xmax;
            double xmin = this.xAxis.getRange().getLower();
            x = xmin;
            if (this.evalDP(x, y = (xmin - x1) * dy / dx + y1, dp1, dp2)) {
                Sample newSample = new Sample(x, y);
                boolean insert = true;
                int i = 0;
                while (i < count) {
                    if (((Object)newSample).equals(dpTuple[i])) {
                        insert = false;
                        break;
                    }
                    ++i;
                }
                if (insert) {
                    dpTuple[count++] = newSample;
                }
            }
            x = xmax = this.xAxis.getRange().getUpper();
            y = (xmax - x1) * dy / dx + y1;
            if (dx != 0.0 && this.evalDP(x, y, dp1, dp2)) {
                Sample newSample = new Sample(x, y);
                boolean insert = true;
                int i = 0;
                while (i < count) {
                    if (((Object)newSample).equals(dpTuple[i])) {
                        insert = false;
                        break;
                    }
                    ++i;
                }
                if (insert) {
                    dpTuple[count++] = newSample;
                }
            }
        }
        return dpTuple;
    }

    private boolean evalDP(double x, double y, ISample dp1, ISample dp2) {
        if (!this.xAxis.getRange().inRange(x) || !this.yAxis.getRange().inRange(y)) {
            return false;
        }
        if (!new Range(dp1.getXValue(), dp2.getXValue()).inRange(x) || !new Range(dp1.getYValue(), dp2.getYValue()).inRange(y)) {
            return false;
        }
        Sample dp = new Sample(x, y);
        return !((Object)dp).equals(dp1) && !((Object)dp).equals(dp2);
    }

    public void setXAxis(Axis axis) {
        if (Objects.equals(this.xAxis, axis)) {
            return;
        }
        if (this.xAxis != null) {
            this.xAxis.removeListener(this);
            this.xAxis.removeTrace(this);
        }
        this.xAxis = axis;
        this.xAxis.addTrace(this);
        this.xAxis.addListener(this);
        this.revalidate();
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public void setYAxis(Axis axis) {
        Axis old = this.yAxis;
        if (Objects.equals(old, axis)) {
            return;
        }
        this.xyGraph.getLegendMap().get(this.yAxis).removeTrace(this);
        if (this.xyGraph.getLegendMap().get(this.yAxis).getTraceList().size() <= 0) {
            this.xyGraph.remove((IFigure)this.xyGraph.getLegendMap().get(this.yAxis));
            this.xyGraph.getLegendMap().remove(this.yAxis);
        }
        if (this.xyGraph.getLegendMap().containsKey(axis)) {
            this.xyGraph.getLegendMap().get(axis).addTrace(this);
        } else {
            this.xyGraph.getLegendMap().put(axis, new Legend(this.xyGraph));
            this.xyGraph.getLegendMap().get(axis).addTrace(this);
            this.xyGraph.add((IFigure)this.xyGraph.getLegendMap().get(axis));
        }
        if (this.yAxis != null) {
            this.yAxis.removeListener(this);
            this.yAxis.removeTrace(this);
        }
        this.yAxis = axis;
        this.yAxis.addTrace(this);
        this.yAxis.addListener(this);
        this.fireYAxisChanged(old, this.yAxis);
        this.xyGraph.repaint();
    }

    private void fireYAxisChanged(Axis oldName, Axis newName) {
        for (ITraceListener listener : this.listeners) {
            listener.traceYAxisChanged(this, oldName, newName);
        }
    }

    public void setDataProvider(IDataProvider traceDataProvider) {
        traceDataProvider.addDataProviderListener(this);
        this.traceDataProvider = traceDataProvider;
    }

    public TraceType getTraceType() {
        return this.traceType;
    }

    public void setTraceColor(Color traceColor) {
        Color old = this.traceColor;
        if (Objects.equals(old, traceColor)) {
            return;
        }
        this.traceColor = traceColor;
        if (!this.errorBarColorSetFlag) {
            this.errorBarColor = traceColor;
        }
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
        this.fireTraceColorChanged(old, this.traceColor);
    }

    private void fireTraceColorChanged(Color old, Color newColor) {
        for (ITraceListener listener : this.listeners) {
            listener.traceColorChanged(this, old, newColor);
        }
    }

    public Color getTraceColor() {
        return this.traceColor;
    }

    public void setTraceType(TraceType traceType) {
        TraceType old = this.traceType;
        if (old == traceType) {
            return;
        }
        this.traceType = traceType;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
        this.fireTraceTypeChanged(old, this.traceType);
    }

    private void fireTraceTypeChanged(TraceType old, TraceType newTraceType) {
        for (ITraceListener listener : this.listeners) {
            listener.traceTypeChanged(this, old, newTraceType);
        }
    }

    public void setBaseLine(BaseLine baseLine) {
        BaseLine old = this.baseLine;
        if (old == baseLine) {
            return;
        }
        this.baseLine = baseLine;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public void setPointStyle(PointStyle pointStyle) {
        PointStyle old = this.pointStyle;
        if (old == pointStyle) {
            return;
        }
        this.pointStyle = pointStyle;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
        this.firePointStyleChanged(old, this.pointStyle);
    }

    private void firePointStyleChanged(PointStyle old, PointStyle newStyle) {
        for (ITraceListener listener : this.listeners) {
            listener.pointStyleChanged(this, old, newStyle);
        }
    }

    public void setLineWidth(int lineWidth) {
        int orig = this.lineWidth;
        if (orig == lineWidth) {
            return;
        }
        this.lineWidth = lineWidth;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
        for (ITraceListener listener : this.listeners) {
            listener.traceWidthChanged(this, orig, lineWidth);
        }
    }

    public void setPointSize(int pointSize) {
        int old = this.pointSize;
        if (old == pointSize) {
            return;
        }
        this.pointSize = pointSize;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public void setAreaAlpha(int areaAlpha) {
        int old = this.areaAlpha;
        if (old == areaAlpha) {
            return;
        }
        this.areaAlpha = areaAlpha;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public void setAntiAliasing(boolean antiAliasing) {
        boolean old = this.antiAliasing;
        if (old == antiAliasing) {
            return;
        }
        this.antiAliasing = antiAliasing;
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
    }

    public void setName(String name) {
        this.setName(name, true);
    }

    public void setName(String name, boolean fire) {
        String oldName = this.name;
        if (Objects.equals(oldName, name)) {
            return;
        }
        this.name = name;
        this.revalidate();
        if (this.xyGraph != null) {
            this.xyGraph.repaint();
        }
        if (fire) {
            this.fireTraceNameChanged(oldName, this.name);
        }
    }

    private void fireTraceNameChanged(String oldName, String newName) {
        for (ITraceListener listener : this.listeners) {
            listener.traceNameChanged(this, oldName, newName);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public int getAreaAlpha() {
        return this.areaAlpha;
    }

    public Axis getYAxis() {
        return this.yAxis;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void dataChanged(IDataProvider dataProvider) {
        boolean xRepainted = this.xAxis.performAutoScale(false);
        boolean yRepainted = this.yAxis.performAutoScale(false);
        if (!xRepainted && !yRepainted) {
            this.repaint();
        }
    }

    private Range getIndexRangeOnXAxis() {
        double max;
        Range axisRange = this.xAxis.getRange();
        if (this.traceDataProvider.getSize() <= 0) {
            return null;
        }
        double min = axisRange.getLower() > axisRange.getUpper() ? axisRange.getUpper() : axisRange.getLower();
        double d = max = axisRange.getUpper() > axisRange.getLower() ? axisRange.getUpper() : axisRange.getLower();
        if (min > this.traceDataProvider.getSample(this.traceDataProvider.getSize() - 1).getXValue() || max < this.traceDataProvider.getSample(0).getXValue()) {
            return null;
        }
        int lowIndex = 0;
        int highIndex = this.traceDataProvider.getSize() - 1;
        if (min > this.traceDataProvider.getSample(0).getXValue()) {
            lowIndex = this.nearBinarySearchX(min, true);
        }
        if (max < this.traceDataProvider.getSample(highIndex).getXValue()) {
            highIndex = this.nearBinarySearchX(max, false);
        }
        return new Range(lowIndex, highIndex);
    }

    private int nearBinarySearchX(double key, boolean left) {
        int low = 0;
        int high = this.traceDataProvider.getSize() - 1;
        while (low <= high) {
            int cmp;
            int mid = low + high >>> 1;
            double midVal = this.traceDataProvider.getSample(mid).getXValue();
            if (midVal < key) {
                cmp = -1;
            } else if (midVal > key) {
                cmp = 1;
            } else {
                long keyBits;
                long midBits = Double.doubleToLongBits(midVal);
                int n = midBits == (keyBits = Double.doubleToLongBits(key)) ? 0 : (cmp = midBits < keyBits ? -1 : 1);
            }
            if (cmp < 0) {
                if (mid < this.traceDataProvider.getSize() - 1 && key < this.traceDataProvider.getSample(mid + 1).getXValue()) {
                    if (left) {
                        return mid;
                    }
                    return mid + 1;
                }
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                if (mid > 0 && key > this.traceDataProvider.getSample(mid - 1).getXValue()) {
                    if (left) {
                        return mid - 1;
                    }
                    return mid;
                }
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public void axisRevalidated(Axis axis) {
        this.repaint();
    }

    @Override
    public void axisRangeChanged(Axis axis, Range old_range, Range new_range) {
    }

    public IDataProvider getDataProvider() {
        return this.traceDataProvider;
    }

    public void setErrorBarEnabled(boolean errorBarEnabled) {
        this.errorBarEnabled = errorBarEnabled;
    }

    public void setYErrorBarType(ErrorBarType errorBarType) {
        this.yErrorBarType = errorBarType;
    }

    public void setXErrorBarType(ErrorBarType errorBarType) {
        this.xErrorBarType = errorBarType;
    }

    public void setDrawYErrorInArea(boolean drawYErrorInArea) {
        this.drawYErrorInArea = drawYErrorInArea;
    }

    public void setErrorBarCapWidth(int errorBarCapWidth) {
        this.errorBarCapWidth = errorBarCapWidth;
    }

    public void setErrorBarColor(Color errorBarColor) {
        this.errorBarColor = errorBarColor;
        this.errorBarColorSetFlag = true;
    }

    public List<ISample> getHotSampleList() {
        return this.hotSampleist;
    }

    public BaseLine getBaseLine() {
        return this.baseLine;
    }

    public PointStyle getPointStyle() {
        return this.pointStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public boolean isAntiAliasing() {
        return this.antiAliasing;
    }

    public boolean isErrorBarEnabled() {
        return this.errorBarEnabled;
    }

    public ErrorBarType getYErrorBarType() {
        return this.yErrorBarType;
    }

    public ErrorBarType getXErrorBarType() {
        return this.xErrorBarType;
    }

    public int getErrorBarCapWidth() {
        return this.errorBarCapWidth;
    }

    public Color getErrorBarColor() {
        return this.errorBarColor;
    }

    public boolean isDrawYErrorInArea() {
        return this.drawYErrorInArea;
    }

    public void setXYGraph(IXYGraph xyGraph) {
        this.xyGraph = xyGraph;
    }

    public IXYGraph getXYGraph() {
        return this.xyGraph;
    }

    @Override
    public void axisForegroundColorChanged(Axis axis, Color oldColor, Color newColor) {
    }

    @Override
    public void axisTitleChanged(Axis axis, String oldTitle, String newTitle) {
    }

    @Override
    public void axisAutoScaleChanged(Axis axis, boolean oldAutoScale, boolean newAutoScale) {
    }

    @Override
    public void axisLogScaleChanged(Axis axis, boolean old, boolean logScale) {
    }

    public void dispose() {
        if (this.getParent() != null) {
            this.getParent().remove((IFigure)this);
        }
        this.removeAll();
        if (this.getHotSampleList() != null) {
            this.getHotSampleList().clear();
        }
        this.name = null;
        this.traceDataProvider = null;
        this.xAxis = null;
        this.yAxis = null;
        this.traceColor = null;
        this.traceType = null;
        this.baseLine = null;
        this.pointStyle = null;
        this.yErrorBarType = null;
        this.xErrorBarType = null;
        this.errorBarColor = null;
        this.xyGraph = null;
    }

    public static enum BaseLine {
        NEGATIVE_INFINITY,
        ZERO,
        POSITIVE_INFINITY;


        public static String[] stringValues() {
            String[] sv = new String[BaseLine.values().length];
            int i = 0;
            BaseLine[] baseLineArray = BaseLine.values();
            int n = baseLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                BaseLine p = baseLineArray[n2];
                sv[i++] = p.toString();
                ++n2;
            }
            return sv;
        }
    }

    public static enum ErrorBarType {
        NONE,
        PLUS,
        MINUS,
        BOTH;


        public static String[] stringValues() {
            String[] sv = new String[ErrorBarType.values().length];
            int i = 0;
            ErrorBarType[] errorBarTypeArray = ErrorBarType.values();
            int n = errorBarTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ErrorBarType p = errorBarTypeArray[n2];
                sv[i++] = p.toString();
                ++n2;
            }
            return sv;
        }
    }

    public static enum PointStyle {
        NONE(Messages.PointNone),
        POINT(Messages.PointPoint),
        CIRCLE(Messages.PointCircle),
        FILLED_CIRCLE(Messages.PointFilledCircle),
        TRIANGLE(Messages.PointTriangle),
        FILLED_TRIANGLE(Messages.PointFilledTriangle),
        SQUARE(Messages.PointSquare),
        FILLED_SQUARE(Messages.PointFilledSquare),
        DIAMOND(Messages.PointDiamond),
        FILLED_DIAMOND(Messages.PointFilledDiamond),
        XCROSS(Messages.PointCross),
        CROSS(Messages.ProintCross2),
        BAR(Messages.PointBar);

        private String description;

        private PointStyle(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] sv = new String[PointStyle.values().length];
            int i = 0;
            PointStyle[] pointStyleArray = PointStyle.values();
            int n = pointStyleArray.length;
            int n2 = 0;
            while (n2 < n) {
                PointStyle p = pointStyleArray[n2];
                sv[i++] = p.toString();
                ++n2;
            }
            return sv;
        }
    }

    public static enum TraceType {
        SOLID_LINE(Messages.TraceSolid),
        DASH_LINE(Messages.TraceDash),
        POINT(Messages.TracePoint),
        BAR(Messages.TraceBar),
        AREA(Messages.TraceArea),
        LINE_AREA(Messages.TraceLineArea),
        STEP_VERTICALLY(Messages.TraceStepVert),
        STEP_HORIZONTALLY(Messages.TraceStepHoriz),
        DASHDOT_LINE(Messages.TraceDashDot),
        DASHDOTDOT_LINE(Messages.TraceDashDotDot),
        DOT_LINE(Messages.TraceDot);

        private String description;

        private TraceType(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] sv = new String[TraceType.values().length];
            int i = 0;
            TraceType[] traceTypeArray = TraceType.values();
            int n = traceTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                TraceType p = traceTypeArray[n2];
                sv[i++] = p.toString();
                ++n2;
            }
            return sv;
        }
    }
}

