/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.block.function.primitive.LongShortToShortFunction;
import org.eclipse.collections.api.block.function.primitive.LongToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction0;
import org.eclipse.collections.api.block.function.primitive.ShortToShortFunction;
import org.eclipse.collections.api.block.predicate.primitive.LongShortPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongShortProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.primitive.LongShortMaps;
import org.eclipse.collections.api.factory.primitive.ShortLongMaps;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.iterator.MutableLongIterator;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.map.primitive.ImmutableLongShortMap;
import org.eclipse.collections.api.map.primitive.LongShortMap;
import org.eclipse.collections.api.map.primitive.MutableLongShortMap;
import org.eclipse.collections.api.map.primitive.MutableShortLongMap;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.api.tuple.primitive.LongShortPair;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyLongIterable;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableLongKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableShortValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.ImmutableLongMapKeySet;
import org.eclipse.collections.impl.map.mutable.primitive.MutableLongKeysMap;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedLongShortMap;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableLongShortMap;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

public class LongShortHashMap
extends AbstractMutableShortValuesMap
implements MutableLongShortMap,
Externalizable,
MutableLongKeysMap {
    private static final short EMPTY_VALUE = 0;
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_KEY = 0L;
    private static final long REMOVED_KEY = 1L;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 8;
    private static final int INITIAL_LINEAR_PROBE = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private long[] keys;
    private short[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private AbstractMutableShortValuesMap.SentinelValues sentinelValues;
    private boolean copyKeysOnWrite;

    public LongShortHashMap() {
        this.allocateTable(16);
    }

    public LongShortHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(initialCapacity << 1);
        this.allocateTable(capacity);
    }

    public LongShortHashMap(LongShortMap map) {
        if (map instanceof LongShortHashMap && ((LongShortHashMap)map).occupiedWithSentinels == 0) {
            LongShortHashMap hashMap = (LongShortHashMap)map;
            this.occupiedWithData = hashMap.occupiedWithData;
            if (hashMap.sentinelValues != null) {
                this.sentinelValues = hashMap.sentinelValues.copy();
            }
            this.keys = Arrays.copyOf(hashMap.keys, hashMap.keys.length);
            this.values = Arrays.copyOf(hashMap.values, hashMap.values.length);
        } else {
            int capacity = this.smallestPowerOfTwoGreaterThan(Math.max(map.size(), 8) << 1);
            this.allocateTable(capacity);
            this.putAll(map);
        }
    }

    public static LongShortHashMap newWithKeysValues(long key1, short value1) {
        return new LongShortHashMap(1).withKeyValue(key1, value1);
    }

    public static LongShortHashMap newWithKeysValues(long key1, short value1, long key2, short value2) {
        return new LongShortHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static LongShortHashMap newWithKeysValues(long key1, short value1, long key2, short value2, long key3, short value3) {
        return new LongShortHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static LongShortHashMap newWithKeysValues(long key1, short value1, long key2, short value2, long key3, short value3, long key4, short value4) {
        return new LongShortHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    @Override
    protected int getOccupiedWithData() {
        return this.occupiedWithData;
    }

    @Override
    protected AbstractMutableShortValuesMap.SentinelValues getSentinelValues() {
        return this.sentinelValues;
    }

    @Override
    protected void setSentinelValuesNull() {
        this.sentinelValues = null;
    }

    @Override
    protected short getEmptyValue() {
        return 0;
    }

    @Override
    protected int getTableSize() {
        return this.values.length;
    }

    @Override
    protected short getValueAtIndex(int index) {
        return this.values[index];
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LongShortMap)) {
            return false;
        }
        LongShortMap other = (LongShortMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0L) || other.containsKey(1L)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0L) || this.sentinelValues.zeroValue != other.getOrThrow(0L))) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1L) || this.sentinelValues.oneValue != other.getOrThrow(1L))) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongShortHashMap.isNonSentinel(key) || other.containsKey(key) && this.values[i] == other.getOrThrow(key)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongShortHashMap.isNonSentinel(this.keys[i])) continue;
            result += (int)(this.keys[i] ^ this.keys[i] >>> 32) ^ this.values[i];
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(0L).append("=").append(this.sentinelValues.zeroValue);
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(1L).append("=").append(this.sentinelValues.oneValue);
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            long key = this.keys[i];
            if (!LongShortHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(key).append("=").append(this.values[i]);
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public MutableShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    public <V> V injectInto(V injectedValue, ObjectShortToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongShortHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    @Override
    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, (short)0);
    }

    public void put(long key, short value) {
        if (LongShortHashMap.isEmptyKey(key)) {
            this.putForEmptySentinel(value);
            return;
        }
        if (LongShortHashMap.isRemovedKey(key)) {
            this.putForRemovedSentinel(value);
            return;
        }
        int index = this.probe(key);
        long keyAtIndex = this.keys[index];
        if (keyAtIndex == key) {
            this.values[index] = value;
        } else {
            this.addKeyValueAtIndex(key, value, index);
        }
    }

    private void putForRemovedSentinel(short value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
        }
        this.addRemovedKeyValue(value);
    }

    private void putForEmptySentinel(short value) {
        if (this.sentinelValues == null) {
            this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
        }
        this.addEmptyKeyValue(value);
    }

    public void putAll(LongShortMap map) {
        map.forEachKeyValue(this::put);
    }

    public void updateValues(LongShortToShortFunction function) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongShortHashMap.isNonSentinel(this.keys[i])) continue;
            this.values[i] = function.valueOf(this.keys[i], this.values[i]);
        }
    }

    @Override
    public void removeKey(long key) {
        if (LongShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (LongShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.removeKeyAtIndex(index);
        }
    }

    public void remove(long key) {
        this.removeKey(key);
    }

    public short removeKeyIfAbsent(long key, short value) {
        if (LongShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            short oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (LongShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            short oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            short oldValue = this.values[index];
            this.removeKeyAtIndex(index);
            return oldValue;
        }
        return value;
    }

    public short getIfAbsentPut(long key, short value) {
        if (LongShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getAndPut(long key, short putValue, short defaultValue) {
        if (LongShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsZeroKey) {
                short existingValue = this.sentinelValues.zeroValue;
                this.sentinelValues.zeroValue = putValue;
                return existingValue;
            }
            this.addEmptyKeyValue(putValue);
            return defaultValue;
        }
        if (LongShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
            } else if (this.sentinelValues.containsOneKey) {
                short existingValue = this.sentinelValues.oneValue;
                this.sentinelValues.oneValue = putValue;
                return existingValue;
            }
            this.addRemovedKeyValue(putValue);
            return defaultValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            short existingValue = this.values[index];
            this.values[index] = putValue;
            return existingValue;
        }
        this.addKeyValueAtIndex(key, putValue, index);
        return defaultValue;
    }

    public short getIfAbsentPut(long key, ShortFunction0 function) {
        if (LongShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.value();
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> short getIfAbsentPutWith(long key, ShortFunction<? super P> function, P parameter) {
        if (LongShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.shortValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.shortValueOf(parameter);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.shortValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.shortValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short getIfAbsentPutWithKey(long key, LongToShortFunction function) {
        if (LongShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            short value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (LongShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                short value = function.valueOf(key);
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            short value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        short value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public short addToValue(long key, short toBeAdded) {
        if (LongShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = (short)(this.sentinelValues.zeroValue + toBeAdded);
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = (short)(this.sentinelValues.oneValue + toBeAdded);
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = (short)(this.values[n] + toBeAdded);
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return toBeAdded;
    }

    private void addKeyValueAtIndex(long key, short value, int index) {
        if (this.keys[index] == 1L) {
            --this.occupiedWithSentinels;
        }
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData + this.occupiedWithSentinels > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void removeKeyAtIndex(int index) {
        if (this.copyKeysOnWrite) {
            this.copyKeys();
        }
        this.keys[index] = 1L;
        this.values[index] = 0;
        --this.occupiedWithData;
        ++this.occupiedWithSentinels;
    }

    private void copyKeys() {
        long[] copy = new long[this.keys.length];
        System.arraycopy(this.keys, 0, copy, 0, this.keys.length);
        this.keys = copy;
        this.copyKeysOnWrite = false;
    }

    public short updateValue(long key, short initialValueIfAbsent, ShortToShortFunction function) {
        if (LongShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new AbstractMutableShortValuesMap.SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        short value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public LongShortHashMap withKeyValue(long key1, short value1) {
        this.put(key1, value1);
        return this;
    }

    public LongShortHashMap withKeysValues(long key1, short value1, long key2, short value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public LongShortHashMap withKeysValues(long key1, short value1, long key2, short value2, long key3, short value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public LongShortHashMap withKeysValues(long key1, short value1, long key2, short value2, long key3, short value3, long key4, short value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public LongShortHashMap withoutKey(long key) {
        this.removeKey(key);
        return this;
    }

    public LongShortHashMap withoutAllKeys(LongIterable keys) {
        keys.forEach(this::removeKey);
        return this;
    }

    public MutableLongShortMap asUnmodifiable() {
        return new UnmodifiableLongShortMap(this);
    }

    public MutableLongShortMap asSynchronized() {
        return new SynchronizedLongShortMap(this);
    }

    public ImmutableLongShortMap toImmutable() {
        return LongShortMaps.immutable.ofAll((LongShortMap)this);
    }

    public short get(long key) {
        return this.getIfAbsent(key, (short)0);
    }

    public short getIfAbsent(long key, short ifAbsent) {
        if (LongShortHashMap.isEmptyKey(key) || LongShortHashMap.isRemovedKey(key)) {
            return this.getForSentinel(key, ifAbsent);
        }
        if (this.occupiedWithSentinels == 0) {
            return this.fastGetIfAbsent(key, ifAbsent);
        }
        return this.slowGetIfAbsent(key, ifAbsent);
    }

    private short getForSentinel(long key, short ifAbsent) {
        if (LongShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
            return ifAbsent;
        }
        return this.sentinelValues.oneValue;
    }

    private short slowGetIfAbsent(long key, short ifAbsent) {
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    private short fastGetIfAbsent(long key, short ifAbsent) {
        int index = this.mask((int)key);
        for (int i = 0; i < 4; ++i) {
            long keyAtIndex = this.keys[index];
            if (keyAtIndex == key) {
                return this.values[index];
            }
            if (keyAtIndex == 0L) {
                return ifAbsent;
            }
            index = index + 1 & this.keys.length - 1;
        }
        return this.slowGetIfAbsentTwo(key, ifAbsent);
    }

    private short slowGetIfAbsentTwo(long key, short ifAbsent) {
        int index = this.probeTwo(key, -1);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public short getOrThrow(long key) {
        if (LongShortHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (LongShortHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (LongShortHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    @Override
    public boolean containsKey(long key) {
        if (LongShortHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (LongShortHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    @Override
    public void forEachKey(LongProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0L);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1L);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i]);
        }
    }

    public void forEachKeyValue(LongShortProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongShortHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public boolean allSatisfyKeyValue(LongShortPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0L, this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1L, this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            return false;
        }
        return true;
    }

    public LazyLongIterable keysView() {
        return new KeysView();
    }

    public RichIterable<LongShortPair> keyValuesView() {
        return new KeyValuesView();
    }

    public MutableShortLongMap flipUniqueValues() {
        MutableShortLongMap result = ShortLongMaps.mutable.empty();
        this.forEachKeyValue((LongShortProcedure & Serializable)(key, value) -> {
            if (result.containsKey(value)) {
                throw new IllegalStateException("Duplicate value: " + value + " found at key: " + result.get(value) + " and key: " + key);
            }
            result.put(value, key);
        });
        return result;
    }

    public LongShortHashMap select(LongShortPredicate predicate) {
        LongShortHashMap result = new LongShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0L, this.sentinelValues.zeroValue)) {
                result.put(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1L, this.sentinelValues.oneValue)) {
                result.put(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongShortHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public LongShortHashMap reject(LongShortPredicate predicate) {
        LongShortHashMap result = new LongShortHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0L, this.sentinelValues.zeroValue)) {
                result.put(0L, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1L, this.sentinelValues.oneValue)) {
                result.put(1L, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongShortHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeLong(0L);
                out.writeShort(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeLong(1L);
                out.writeShort(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!LongShortHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeLong(this.keys[i]);
            out.writeShort(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readLong(), in.readShort());
        }
    }

    public boolean trimToSize() {
        int newCapacity = this.smallestPowerOfTwoGreaterThan(this.size());
        if (this.keys.length > newCapacity) {
            this.rehash(newCapacity);
            return true;
        }
        return false;
    }

    @Deprecated
    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehashAndGrow() {
        int max = this.maxOccupiedWithData();
        int newCapacity = Math.max(max, this.smallestPowerOfTwoGreaterThan(this.occupiedWithData + 1 << 1));
        if (this.occupiedWithSentinels > 0 && (max >> 1) + (max >> 2) < this.occupiedWithData) {
            newCapacity <<= 1;
        }
        this.rehash(newCapacity);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        long[] old = this.keys;
        short[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!LongShortHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(long element) {
        int index = this.mask((int)element);
        long keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0L) {
            return index;
        }
        int removedIndex = keyAtIndex == 1L ? index : -1;
        for (int i = 1; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(long element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 4; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            long keyAtIndex = this.keys[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(long element, int removedIndex) {
        int nextIndex = (int)SpreadFunctions.longSpreadOne(element);
        int spreadTwo = (int)Long.reverse(SpreadFunctions.longSpreadTwo(element)) | 1;
        long keyAtIndex;
        while ((keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)]) != element) {
            if (keyAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(long element) {
        long code = SpreadFunctions.longSpreadOne(element);
        return this.mask((int)code);
    }

    int spreadTwoAndMask(long element) {
        long code = SpreadFunctions.longSpreadTwo(element);
        return this.mask((int)code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    protected void allocateTable(int sizeToAllocate) {
        this.keys = new long[sizeToAllocate];
        this.values = new short[sizeToAllocate];
    }

    private static boolean isEmptyKey(long key) {
        return key == 0L;
    }

    private static boolean isRemovedKey(long key) {
        return key == 1L;
    }

    private static boolean isNonSentinel(long key) {
        return !LongShortHashMap.isEmptyKey(key) && !LongShortHashMap.isRemovedKey(key);
    }

    @Override
    protected boolean isNonSentinelAtIndex(int index) {
        return !LongShortHashMap.isEmptyKey(this.keys[index]) && !LongShortHashMap.isRemovedKey(this.keys[index]);
    }

    private int maxOccupiedWithData() {
        return this.keys.length >> 1;
    }

    public MutableLongSet keySet() {
        return new KeySet();
    }

    public MutableShortCollection values() {
        return new ValuesCollection();
    }

    private class KeyValuesView
    extends AbstractLazyIterable<LongShortPair> {
        private KeyValuesView() {
        }

        public void each(Procedure<? super LongShortPair> procedure) {
            if (LongShortHashMap.this.sentinelValues != null) {
                if (LongShortHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0L, LongShortHashMap.this.sentinelValues.zeroValue));
                }
                if (LongShortHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1L, LongShortHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < LongShortHashMap.this.keys.length; ++i) {
                if (!LongShortHashMap.isNonSentinel(LongShortHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(LongShortHashMap.this.keys[i], LongShortHashMap.this.values[i]));
            }
        }

        @Override
        public void forEachWithIndex(ObjectIntProcedure<? super LongShortPair> objectIntProcedure) {
            int index = 0;
            if (LongShortHashMap.this.sentinelValues != null) {
                if (LongShortHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0L, LongShortHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (LongShortHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1L, LongShortHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < LongShortHashMap.this.keys.length; ++i) {
                if (!LongShortHashMap.isNonSentinel(LongShortHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(LongShortHashMap.this.keys[i], LongShortHashMap.this.values[i]), index);
                ++index;
            }
        }

        @Override
        public <P> void forEachWith(Procedure2<? super LongShortPair, ? super P> procedure, P parameter) {
            if (LongShortHashMap.this.sentinelValues != null) {
                if (LongShortHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0L, LongShortHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (LongShortHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1L, LongShortHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < LongShortHashMap.this.keys.length; ++i) {
                if (!LongShortHashMap.isNonSentinel(LongShortHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(LongShortHashMap.this.keys[i], LongShortHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<LongShortPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        public class InternalKeyValuesIterator
        implements Iterator<LongShortPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public LongShortPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (LongShortHashMap.this.containsKey(0L)) {
                        return PrimitiveTuples.pair(0L, LongShortHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (LongShortHashMap.this.containsKey(1L)) {
                        return PrimitiveTuples.pair(1L, LongShortHashMap.this.sentinelValues.oneValue);
                    }
                }
                long[] keys = LongShortHashMap.this.keys;
                while (!LongShortHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                LongShortPair result = PrimitiveTuples.pair(keys[this.position], LongShortHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != LongShortHashMap.this.size();
            }
        }
    }

    private class ValuesCollection
    extends AbstractMutableShortValuesMap.AbstractShortValuesCollection {
        private ValuesCollection() {
        }

        public MutableShortIterator shortIterator() {
            return LongShortHashMap.this.shortIterator();
        }

        public boolean remove(short item) {
            int oldSize = LongShortHashMap.this.size();
            if (LongShortHashMap.this.sentinelValues != null && LongShortHashMap.this.sentinelValues.containsZeroKey && item == LongShortHashMap.this.sentinelValues.zeroValue) {
                LongShortHashMap.this.removeKey(0L);
            }
            if (LongShortHashMap.this.sentinelValues != null && LongShortHashMap.this.sentinelValues.containsOneKey && item == LongShortHashMap.this.sentinelValues.oneValue) {
                LongShortHashMap.this.removeKey(1L);
            }
            for (int i = 0; i < LongShortHashMap.this.keys.length; ++i) {
                if (!LongShortHashMap.isNonSentinel(LongShortHashMap.this.keys[i]) || item != LongShortHashMap.this.values[i]) continue;
                LongShortHashMap.this.removeKey(LongShortHashMap.this.keys[i]);
            }
            return oldSize != LongShortHashMap.this.size();
        }

        public boolean retainAll(ShortIterable source) {
            int oldSize = LongShortHashMap.this.size();
            Object sourceSet = source instanceof ShortSet ? (ShortSet)source : source.toSet();
            LongShortHashMap retained = LongShortHashMap.this.select((arg_0, arg_1) -> ValuesCollection.lambda$retainAll$1ec83b70$1((ShortSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                LongShortHashMap.this.keys = retained.keys;
                LongShortHashMap.this.values = retained.values;
                LongShortHashMap.this.sentinelValues = retained.sentinelValues;
                LongShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                LongShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public MutableShortCollection newEmpty() {
            return new ShortHashBag();
        }

        private static /* synthetic */ boolean lambda$retainAll$1ec83b70$1(ShortSet sourceSet, long key, short value) {
            return sourceSet.contains(value);
        }
    }

    private class KeySet
    extends AbstractMutableLongKeySet {
        private KeySet() {
        }

        @Override
        protected MutableLongKeysMap getOuter() {
            return LongShortHashMap.this;
        }

        @Override
        protected AbstractMutableShortValuesMap.SentinelValues getSentinelValues() {
            return LongShortHashMap.this.sentinelValues;
        }

        @Override
        protected long getKeyAtIndex(int index) {
            return LongShortHashMap.this.keys[index];
        }

        @Override
        protected int getTableSize() {
            return LongShortHashMap.this.keys.length;
        }

        public MutableLongIterator longIterator() {
            return new KeySetIterator();
        }

        public boolean retainAll(LongIterable source) {
            int oldSize = LongShortHashMap.this.size();
            Object sourceSet = source instanceof LongSet ? (LongSet)source : source.toSet();
            LongShortHashMap retained = LongShortHashMap.this.select((arg_0, arg_1) -> KeySet.lambda$retainAll$f9e8d6bc$1((LongSet)sourceSet, arg_0, arg_1));
            if (retained.size() != oldSize) {
                LongShortHashMap.this.keys = retained.keys;
                LongShortHashMap.this.values = retained.values;
                LongShortHashMap.this.sentinelValues = retained.sentinelValues;
                LongShortHashMap.this.occupiedWithData = retained.occupiedWithData;
                LongShortHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(long ... source) {
            return this.retainAll(LongHashSet.newSetWith(source));
        }

        public LongSet freeze() {
            LongShortHashMap.this.copyKeysOnWrite = true;
            boolean containsZeroKey = false;
            boolean containsOneKey = false;
            if (LongShortHashMap.this.sentinelValues != null) {
                containsZeroKey = LongShortHashMap.this.sentinelValues.containsZeroKey;
                containsOneKey = LongShortHashMap.this.sentinelValues.containsOneKey;
            }
            return new ImmutableLongMapKeySet(LongShortHashMap.this.keys, LongShortHashMap.this.occupiedWithData, containsZeroKey, containsOneKey);
        }

        public MutableLongSet newEmpty() {
            return new LongHashSet();
        }

        private static /* synthetic */ boolean lambda$retainAll$f9e8d6bc$1(LongSet sourceSet, long key, short value) {
            return sourceSet.contains(key);
        }
    }

    private class KeySetIterator
    implements MutableLongIterator {
        private int count;
        private int position;
        private long lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < LongShortHashMap.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LongShortHashMap.this.containsKey(0L)) {
                    this.lastKey = 0L;
                    return this.lastKey;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LongShortHashMap.this.containsKey(1L)) {
                    this.lastKey = 1L;
                    return this.lastKey;
                }
            }
            long[] keys = LongShortHashMap.this.keys;
            while (!LongShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            ++this.position;
            return this.lastKey;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            LongShortHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }

    private class KeysView
    extends AbstractLazyLongIterable {
        private KeysView() {
        }

        public LongIterator longIterator() {
            return new UnmodifiableLongIterator((LongIterator)new KeySetIterator());
        }

        public void each(LongProcedure procedure) {
            LongShortHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalShortIterator
    implements MutableShortIterator {
        private int count;
        private int position;
        private long lastKey;
        private boolean handledZero;
        private boolean handledOne;
        private boolean canRemove;

        private InternalShortIterator() {
        }

        public boolean hasNext() {
            return this.count < LongShortHashMap.this.size();
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            this.canRemove = true;
            if (!this.handledZero) {
                this.handledZero = true;
                if (LongShortHashMap.this.containsKey(0L)) {
                    this.lastKey = 0L;
                    return LongShortHashMap.this.get(0L);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (LongShortHashMap.this.containsKey(1L)) {
                    this.lastKey = 1L;
                    return LongShortHashMap.this.get(1L);
                }
            }
            long[] keys = LongShortHashMap.this.keys;
            while (!LongShortHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            this.lastKey = keys[this.position];
            short result = LongShortHashMap.this.values[this.position];
            ++this.position;
            return result;
        }

        public void remove() {
            if (!this.canRemove) {
                throw new IllegalStateException();
            }
            LongShortHashMap.this.removeKey(this.lastKey);
            --this.count;
            this.canRemove = false;
        }
    }
}

