/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.operations;

import com.google.gerrit.common.data.ApprovalType;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.PatchSetPublishDetail;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.PatchSetApproval;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PatchSetPublishDetailX;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.PermissionLabel;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbstractRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.core.operations.PublishRequest;
import org.eclipse.mylyn.internal.gerrit.ui.operations.GerritOperationDialog;
import org.eclipse.mylyn.internal.gerrit.ui.operations.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RichTextEditor;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PublishDialog
extends GerritOperationDialog {
    private static final String KEY_ID = "ApprovalCategoryValue.Id";
    private final GerritChange gerritChange;
    private final PatchSetPublishDetail publishDetail;
    private RichTextEditor messageEditor;
    private Composite approvalComposite;
    private final List<Button> approvalButtons;
    private final String editorCommentText;
    private final IReviewItemSet set;

    public PublishDialog(Shell parentShell, ITask task, GerritChange gerritChange, PatchSetPublishDetail publishDetail, IReviewItemSet set, String editorCommentText) {
        super(parentShell, task);
        this.gerritChange = gerritChange;
        this.publishDetail = publishDetail;
        this.set = set;
        this.editorCommentText = editorCommentText;
        this.approvalButtons = new ArrayList<Button>();
        this.setNeedsConfig(true);
    }

    public GerritOperation<Object> createOperation() {
        int patchSetId = this.publishDetail.getPatchSetInfo().getKey().get();
        PublishRequest request = new PublishRequest(this.task.getTaskId(), patchSetId, this.getApprovals());
        request.setMessage(this.messageEditor.getText());
        return this.getOperationFactory().createOperation(this.task, (AbstractRequest)request);
    }

    private Set<ApprovalCategoryValue.Id> getApprovals() {
        HashSet<ApprovalCategoryValue.Id> approvals = new HashSet<ApprovalCategoryValue.Id>();
        for (Button button : this.approvalButtons) {
            if (!button.getSelection()) continue;
            approvals.add((ApprovalCategoryValue.Id)button.getData(KEY_ID));
        }
        return approvals;
    }

    protected Control createPageControls(Composite parent) {
        String changeId = this.publishDetail.getChange().getKey().abbreviate();
        this.setTitle(Messages.PublishDialog_Publish_Comments);
        this.setMessage(NLS.bind((String)Messages.PublishDialog_Change_X_dash_Y, (Object)changeId, (Object)this.publishDetail.getPatchSetInfo().getSubject()));
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.approvalComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.approvalComposite);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.approvalComposite.setLayout((Layout)layout);
        this.messageEditor = this.createRichTextEditor(composite, "");
        GridDataFactory.fillDefaults().grab(true, true).hint(600, 200).applyTo(this.messageEditor.getControl());
        this.messageEditor.setText(this.editorCommentText);
        this.messageEditor.getViewer().setSelectedRange(this.editorCommentText.length(), 0);
        this.messageEditor.getControl().setFocus();
        int drafts = 0;
        for (IComment comment : this.set.getAllComments()) {
            drafts += comment.isDraft() ? 1 : 0;
        }
        if (drafts > 0) {
            Label statusLabel = new Label(composite, 0);
            statusLabel.setText(drafts > 1 ? NLS.bind((String)Messages.PublishDialog_Publishes_X_drafts, (Object)drafts) : Messages.PublishDialog_Publishes_1_draft);
        }
        return composite;
    }

    @Override
    protected void doRefresh(GerritConfig config) {
        Control[] children;
        Control[] controlArray = children = this.approvalComposite.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.approvalButtons.clear();
        if (config == null) {
            return;
        }
        Set approvalTypes = this.getApprovalTypes(config);
        if (approvalTypes == null) {
            approvalTypes = this.gerritChange.getChangeDetail().getApprovalTypes();
        }
        for (ApprovalType approvalType : approvalTypes) {
            PatchSetApproval approval;
            Set<ApprovalCategoryValue.Id> allowed = this.getAllowed(this.publishDetail, approvalType);
            if (allowed == null || allowed.size() <= 0) continue;
            Group group = new Group(this.approvalComposite, 0);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            group.setText(approvalType.getCategory().getName());
            group.setLayout((Layout)new RowLayout(512));
            short givenValue = 0;
            if (this.publishDetail.getGiven() != null && (approval = (PatchSetApproval)this.publishDetail.getGiven().get(approvalType.getCategory().getId())) != null) {
                givenValue = approval.getValue();
            }
            ArrayList<ApprovalCategoryValue.Id> allowedList = new ArrayList<ApprovalCategoryValue.Id>(allowed);
            Collections.sort(allowedList, (o1, o2) -> o2.get() - o1.get());
            for (ApprovalCategoryValue.Id valueId : allowedList) {
                ApprovalCategoryValue approvalValue = approvalType.getValue(valueId.get());
                Button button = new Button((Composite)group, 16);
                button.setText(approvalValue.format());
                if (approvalValue.getValue() == givenValue) {
                    button.setSelection(true);
                }
                button.setData(KEY_ID, (Object)valueId);
                this.approvalButtons.add(button);
            }
        }
    }

    private Collection<ApprovalType> getApprovalTypes(GerritConfig config) {
        if (config.getApprovalTypes() != null && config.getApprovalTypes().getApprovalTypes() != null) {
            return config.getApprovalTypes().getApprovalTypes();
        }
        return null;
    }

    private Set<ApprovalCategoryValue.Id> getAllowed(PatchSetPublishDetail publishDetail, ApprovalType approvalType) {
        List labels;
        if (publishDetail.getAllowed() != null) {
            return publishDetail.getAllowed(approvalType.getCategory().getId());
        }
        if (publishDetail instanceof PatchSetPublishDetailX && (labels = ((PatchSetPublishDetailX)publishDetail).getLabels()) != null) {
            HashSet<ApprovalCategoryValue.Id> result = new HashSet<ApprovalCategoryValue.Id>();
            for (PermissionLabel label : labels) {
                if (!label.matches(approvalType.getCategory())) continue;
                for (ApprovalCategoryValue value : approvalType.getValues()) {
                    if (!label.matches(value)) continue;
                    result.add(value.getId());
                }
            }
            return result;
        }
        return null;
    }
}

