/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard.core;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.gerrit.dashboard.Messages;
import org.eclipse.mylyn.internal.gerrit.core.GerritQueryResultSchema;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class GerritTask
extends AbstractTask {
    public static final String TASK_ID = "dashboard.mylyn.task.id";
    public static final String SHORT_CHANGE_ID = "task.common.key";
    public static final String CHANGE_ID = GerritQueryResultSchema.getDefault().CHANGE_ID.getKey();
    public static final String SUBJECT = "task.common.summary";
    public static final String STATUS = GerritTaskSchema.getDefault().STATUS.getKey();
    public static final String OWNER = GerritTaskSchema.getDefault().OWNER.getKey();
    public static final String PROJECT = "task.common.product";
    public static final String BRANCH = GerritTaskSchema.getDefault().BRANCH.getKey();
    public static final String TOPIC = GerritTaskSchema.getDefault().TOPIC.getKey();
    public static final String DATE_CREATION = "task.common.date.created";
    public static final String DATE_MODIFICATION = "task.common.date.modified";
    public static final String DATE_COMPLETION = "task.common.date.completed";
    public static final String IS_STARRED = GerritTaskSchema.getDefault().IS_STARRED.getKey();
    public static final String REVIEW_STATE = GerritTaskSchema.getDefault().REVIEW_STATE.getKey();
    public static final String VERIFY_STATE = GerritTaskSchema.getDefault().VERIFY_STATE.getKey();
    private static SimpleDateFormat FORMAT_HOUR = new SimpleDateFormat("h:mm a");
    private static SimpleDateFormat FORMAT_MONTH = new SimpleDateFormat("MMM d");
    private static SimpleDateFormat FORMAT_FULL = new SimpleDateFormat("MMM d, yyyy");
    private final String fConnectorKind;

    public GerritTask(TaskData taskData) {
        super(taskData.getRepositoryUrl(), taskData.getTaskId(), taskData.getRoot().getAttribute(SUBJECT).getValue() + " [" + taskData.getRoot().getAttribute(SHORT_CHANGE_ID).getValue() + "]");
        this.fConnectorKind = taskData.getConnectorKind();
        TaskAttribute root = taskData.getRoot();
        Map attributes = root.getAttributes();
        this.setAttribute(TASK_ID, taskData.getTaskId());
        this.setAttribute(SHORT_CHANGE_ID, this.getValue((TaskAttribute)attributes.get(SHORT_CHANGE_ID)));
        this.setAttribute(CHANGE_ID, this.getValue((TaskAttribute)attributes.get(CHANGE_ID)));
        this.setAttribute(SUBJECT, this.getValue((TaskAttribute)attributes.get(SUBJECT)));
        this.setAttribute(STATUS, this.getValue((TaskAttribute)attributes.get(STATUS)));
        this.setAttribute(OWNER, taskData.getAttributeMapper().getValueLabel((TaskAttribute)attributes.get(OWNER)));
        this.setAttribute(PROJECT, this.getValue((TaskAttribute)attributes.get(PROJECT)));
        this.setAttribute(BRANCH, this.getValue((TaskAttribute)attributes.get(BRANCH)));
        this.setAttribute(TOPIC, this.getValue((TaskAttribute)attributes.get(TOPIC)));
        this.setAttribute(DATE_CREATION, this.getValue((TaskAttribute)attributes.get(DATE_CREATION)));
        this.setAttribute(DATE_MODIFICATION, this.getValue((TaskAttribute)attributes.get(DATE_MODIFICATION)));
        this.setAttribute(DATE_COMPLETION, this.getValue((TaskAttribute)attributes.get(DATE_COMPLETION)));
        this.setAttribute(IS_STARRED, this.getValue((TaskAttribute)attributes.get(IS_STARRED)));
        this.setAttribute(REVIEW_STATE, this.getValue((TaskAttribute)attributes.get(REVIEW_STATE)));
        this.setAttribute(VERIFY_STATE, this.getValue((TaskAttribute)attributes.get(VERIFY_STATE)));
    }

    private String getValue(TaskAttribute taskAttribute) {
        List values;
        if (taskAttribute != null && (values = taskAttribute.getValues()) != null && values.size() > 0) {
            return (String)values.get(0);
        }
        return null;
    }

    public String getAttributeAsDate(String key) {
        if (!(key.equals(DATE_CREATION) || key.equals(DATE_MODIFICATION) || key.equals(DATE_COMPLETION))) {
            return "";
        }
        String rawDate = this.getAttribute(key);
        if (rawDate == null) {
            return "";
        }
        Date date = new Date(Long.parseLong(rawDate));
        if (this.isToday(date)) {
            return FORMAT_HOUR.format(date);
        }
        if (this.isThisYear(date)) {
            return FORMAT_MONTH.format(date);
        }
        return FORMAT_FULL.format(date);
    }

    private boolean isToday(Date date) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date);
        boolean sameDay = cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
        return sameDay;
    }

    private boolean isThisYear(Date date) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date);
        return cal1.get(1) == cal2.get(1);
    }

    public boolean isLocal() {
        return false;
    }

    public String getConnectorKind() {
        return this.fConnectorKind;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Messages.GerritTask_taskID).append(this.getAttribute(TASK_ID)).append('\n');
        buffer.append(Messages.GerritTask_shortID).append(this.getAttribute(SHORT_CHANGE_ID)).append('\n');
        buffer.append(Messages.GerritTask_changeID).append(this.getAttribute(CHANGE_ID)).append('\n');
        buffer.append(Messages.GerritTask_subject).append(this.getAttribute(SUBJECT)).append('\n');
        buffer.append(Messages.GerritTask_status).append(this.getAttribute(STATUS)).append('\n');
        buffer.append(Messages.GerritTask_owner).append(this.getAttribute(OWNER)).append('\n');
        buffer.append(Messages.GerritTask_project).append(this.getAttribute(PROJECT)).append('\n');
        buffer.append(Messages.GerritTask_branch).append(this.getAttribute(BRANCH)).append('\n');
        buffer.append(Messages.GerritTask_topic).append(this.getAttribute(TOPIC)).append('\n');
        buffer.append(Messages.GerritTask_updated).append(this.getAttributeAsDate(DATE_MODIFICATION)).append('\n');
        buffer.append(Messages.GerritTask_star).append(this.getAttribute(IS_STARRED)).append(", CRVW = ").append(this.getAttribute(REVIEW_STATE)).append(", VRIF = ").append(this.getAttribute(VERIFY_STATE)).append("\n");
        return buffer.toString();
    }
}

