/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.mylyn.wikitext.commonmark.internal.ContentLineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LinesIterable;
import org.eclipse.mylyn.wikitext.commonmark.internal.PredicateLineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.TransformLineSequence;
import org.eclipse.mylyn.wikitext.util.Preconditions;
import org.eclipse.mylyn.wikitext.util.WikiToStringStyle;

public abstract class LineSequence
implements Iterable<Line> {
    public static LineSequence create(String content) {
        return new ContentLineSequence(content);
    }

    public abstract Line getCurrentLine();

    public abstract Line getNextLine();

    public abstract void advance();

    public void advance(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (String[])new String[0]);
        int x = 0;
        while (x < count) {
            this.advance();
            ++x;
        }
    }

    @Override
    public Iterator<Line> iterator() {
        Predicate<Line> predicate = x -> true;
        return this.iterator(predicate);
    }

    private Iterator<Line> iterator(Predicate<Line> predicate) {
        return new LinesIterable(this, predicate).iterator();
    }

    public LineSequence with(Predicate<Line> predicate) {
        return new PredicateLineSequence(this, predicate);
    }

    public LineSequence transform(Function<Line, Line> transform) {
        return new TransformLineSequence(this, transform);
    }

    public abstract LineSequence lookAhead();

    public String toString() {
        return new ToStringBuilder((Object)this, (ToStringStyle)WikiToStringStyle.WIKI_TO_STRING_STYLE).append("currentLine", (Object)this.getCurrentLine()).append("nextLine", (Object)this.getNextLine()).toString();
    }

    static abstract class ForwardLineSequence
    extends LineSequence {
        ForwardLineSequence() {
        }

        abstract Line getNextLine(int var1);
    }
}

