/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.operations;

import com.google.gerrit.common.data.ChangeDetail;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbstractRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.Messages;

public class CherryPickRequest
extends AbstractRequest<ChangeDetail> {
    private final int patchSetId;
    private final String reviewId;
    private String destination;

    public CherryPickRequest(String reviewId, int patchSetId, String destination) {
        Assert.isNotNull((Object)reviewId);
        Assert.isLegal((boolean)StringUtils.isNotEmpty((CharSequence)destination));
        this.reviewId = reviewId;
        this.patchSetId = patchSetId;
        this.destination = destination;
    }

    public int getPatchSetId() {
        return this.patchSetId;
    }

    public String getReviewId() {
        return this.reviewId;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    @Override
    ChangeDetail execute(GerritClient client, IProgressMonitor monitor) throws GerritException {
        return client.cherryPick(this.getReviewId(), this.getPatchSetId(), this.getMessage(), this.getDestination(), monitor);
    }

    @Override
    public String getOperationName() {
        return Messages.GerritOperation_Cherry_Picking;
    }
}

