/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.blocks;

import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlock;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;

public class HtmlBlock
extends SourceBlock {
    private static final String BLOCK_TAG_NAMES = "address|article|aside|base|basefont|blockquote|body|button|canvas|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|embed|fieldset|figcaption|figure|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hgroup|hr|html|iframe|legend|li|link|main|map|menu|menuitem|meta|nav|noframes|object|ol|optgroup|option|output|p|param|progress|section|source|summary|table|tbody|td|textarea|tfoot|th|thead|title|tr|track|ul|video";
    private final Pattern startPattern = Pattern.compile("\\s{0,3}((</?(?:address|article|aside|base|basefont|blockquote|body|button|canvas|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|embed|fieldset|figcaption|figure|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hgroup|hr|html|iframe|legend|li|link|main|map|menu|menuitem|meta|nav|noframes|object|ol|optgroup|option|output|p|param|progress|section|source|summary|table|tbody|td|textarea|tfoot|th|thead|title|tr|track|ul|video)(\\s|/>|>)?)).*", 10);

    @Override
    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        while (line != null && !line.isEmpty()) {
            builder.charactersUnescaped(line.getText());
            builder.charactersUnescaped("\n");
            lineSequence.advance();
            line = lineSequence.getCurrentLine();
        }
    }

    @Override
    public boolean canStart(LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        if (line != null) {
            return this.startPattern.matcher(line.getText()).matches();
        }
        return false;
    }
}

