/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal;

import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;

class PredicateLineSequence
extends LineSequence {
    private final LineSequence delegate;
    private final Predicate<Line> predicate;

    public PredicateLineSequence(LineSequence delegate, Predicate<Line> predicate) {
        this.delegate = Objects.requireNonNull(delegate);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public Line getCurrentLine() {
        return this.filter(this.delegate.getCurrentLine());
    }

    @Override
    public Line getNextLine() {
        return this.filter(this.delegate.getNextLine());
    }

    @Override
    public void advance() {
        if (this.getCurrentLine() != null) {
            this.delegate.advance();
        }
    }

    @Override
    public LineSequence lookAhead() {
        return new PredicateLineSequence(this.delegate.lookAhead(), this.predicate);
    }

    private Line filter(Line line) {
        if (line != null && this.predicate.test(line)) {
            return line;
        }
        return null;
    }
}

