/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.testing;

import com.google.inject.Inject;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextEditorInfo;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.testing.AbstractWorkbenchTest;
import org.eclipse.xtext.ui.testing.util.IResourcesSetupUtil;

public abstract class AbstractEditorTest
extends AbstractWorkbenchTest {
    static final long STEP_DELAY = 0L;
    @Inject
    protected XtextEditorInfo editorInfo;

    protected String getEditorId() {
        return this.editorInfo.getEditorId();
    }

    protected XtextEditor openEditor(IFile file) throws Exception {
        IEditorPart editor = AbstractEditorTest.getActivePage().openEditor((IEditorInput)new FileEditorInput(file), this.getEditorId());
        return this.getXtextEditor(editor);
    }

    protected XtextEditor openEditorForExternalFile(File file) throws Exception {
        IFileStore store = EFS.getLocalFileSystem().getStore(file.toURI());
        IEditorPart editor = AbstractEditorTest.getActivePage().openEditor((IEditorInput)new FileStoreEditorInput(store), this.getEditorId());
        return this.getXtextEditor(editor);
    }

    private XtextEditor getXtextEditor(IEditorPart openEditor) throws NoSuchFieldException, IllegalAccessException {
        XtextEditor xtextEditor = EditorUtils.getXtextEditor((IEditorPart)openEditor);
        if (xtextEditor != null) {
            ISourceViewer sourceViewer = xtextEditor.getInternalSourceViewer();
            ((ProjectionViewer)sourceViewer).doOperation(20);
            return xtextEditor;
        }
        if (openEditor instanceof ErrorEditorPart) {
            Field field = openEditor.getClass().getDeclaredField("error");
            field.setAccessible(true);
            throw new IllegalStateException("Couldn't open the editor.", ((Status)field.get(openEditor)).getException());
        }
        AbstractEditorTest.fail((String)("Opened Editor with id:" + this.getEditorId() + ", is not an XtextEditor"));
        return null;
    }

    protected IFile dslFile(String projectName, String fileName, String fileExtension, CharSequence content) {
        try {
            IFile file = IResourcesSetupUtil.createFile(projectName, fileName, fileExtension, content.toString());
            IProject project = file.getProject();
            if (!project.hasNature("org.eclipse.xtext.ui.shared.xtextNature")) {
                IResourcesSetupUtil.addNature(project, "org.eclipse.xtext.ui.shared.xtextNature");
            }
            return file;
        }
        catch (InterruptedException | InvocationTargetException | CoreException e) {
            throw new RuntimeException(e);
        }
    }
}

