/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.jvmmodel.findrefs;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.SearchResultUpdater;
import org.eclipse.jdt.ui.search.QuerySpecification;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.xtext.xbase.ui.internal.XbaseActivator;
import org.eclipse.xtext.xbase.ui.jvmmodel.findrefs.CompositeSearchResult;

public class CompositeSearchQuery
extends JavaSearchQuery {
    private List<ISearchQuery> children = Lists.newArrayList();
    private CompositeSearchResult searchResult;
    private String label;

    public CompositeSearchQuery(QuerySpecification data) {
        super(data);
    }

    public void addChild(ISearchQuery child) {
        this.children.add(child);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.children.size());
        MultiStatus multiStatus = new MultiStatus(this.getPluginId(), 0, "Composite search state", null);
        for (ISearchQuery child : this.children) {
            IStatus status = child.run((IProgressMonitor)progress.newChild(1));
            multiStatus.add(status);
            if (!progress.isCanceled()) continue;
            return Status.CANCEL_STATUS;
        }
        return multiStatus;
    }

    protected String getPluginId() {
        return XbaseActivator.getInstance().getBundle().getSymbolicName();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean canRerun() {
        for (ISearchQuery child : this.children) {
            if (child.canRerun()) continue;
            return false;
        }
        return true;
    }

    public boolean canRunInBackground() {
        for (ISearchQuery child : this.children) {
            if (child.canRunInBackground()) continue;
            return false;
        }
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.searchResult = new CompositeSearchResult(this);
            new SearchResultUpdater((JavaSearchResult)this.searchResult);
        }
        return this.searchResult;
    }

    public List<ISearchQuery> getChildren() {
        return this.children;
    }
}

