/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IBatchLinkableResource;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.impl.AbstractResourceDescription;

public class DirtyStateResourceDescription
extends AbstractResourceDescription {
    private URI uri;
    private List<IEObjectDescription> types;

    public DirtyStateResourceDescription(Resource resource, List<IEObjectDescription> types) {
        this.uri = resource.getURI();
        this.types = types;
    }

    public Iterable<QualifiedName> getImportedNames() {
        return Collections.emptyList();
    }

    public Iterable<IReferenceDescription> getReferenceDescriptions() {
        return Collections.emptyList();
    }

    public URI getURI() {
        return this.uri;
    }

    protected List<IEObjectDescription> computeExportedObjects() {
        return this.types;
    }

    public static class Manager
    implements IResourceDescription.Manager {
        private static Logger LOG = Logger.getLogger(Manager.class);
        public static final String TEXT_HASH = Manager.class.getCanonicalName() + "_textHash";
        private IResourceDescription.Manager delegate;

        @Inject
        public Manager(IResourceDescription.Manager delegate) {
            this.delegate = delegate;
        }

        public IResourceDescription getResourceDescription(Resource resource) {
            return this.createResourceDescription(resource);
        }

        protected IResourceDescription createResourceDescription(Resource resource) {
            if (resource instanceof IBatchLinkableResource) {
                return new DirtyStateResourceDescription(resource, this.computeTypes(resource));
            }
            return this.delegate.getResourceDescription(resource);
        }

        protected List<IEObjectDescription> computeTypes(Resource resource) {
            IResourceDescription delegateDescription = this.delegate.getResourceDescription(resource);
            ArrayList result = Lists.newArrayList();
            String hash = this.getTextHash(resource);
            ImmutableMap userData = ImmutableMap.of((Object)TEXT_HASH, (Object)hash);
            for (IEObjectDescription eObjectDescription : delegateDescription.getExportedObjects()) {
                result.add(new EObjectDescription(eObjectDescription.getQualifiedName(), eObjectDescription.getEObjectOrProxy(), (Map)userData));
            }
            return result;
        }

        public IResourceDescription.Delta createDelta(IResourceDescription oldDescription, IResourceDescription newDescription) {
            return this.delegate.createDelta(oldDescription, newDescription);
        }

        public boolean isAffected(IResourceDescription.Delta delta, IResourceDescription candidate) throws IllegalArgumentException {
            return this.delegate.isAffected(delta, candidate);
        }

        public boolean isAffected(Collection<IResourceDescription.Delta> deltas, IResourceDescription candidate, IResourceDescriptions context) throws IllegalArgumentException {
            return this.delegate.isAffected(deltas, candidate, context);
        }

        protected String getTextHash(Resource resource) {
            try {
                MessageDigest digest = this.createDigest();
                if (digest != null) {
                    byte[] bytes = digest.digest(this.getText(resource).getBytes("UTF-8"));
                    return new BigInteger(bytes).toString(16);
                }
                return null;
            }
            catch (Exception exc) {
                LOG.error((Object)"Error creating resource text digest.", (Throwable)exc);
                return "";
            }
        }

        protected String getText(Resource resource) {
            String text = "";
            IParseResult parseResult = ((XtextResource)resource).getParseResult();
            if (parseResult != null) {
                text = parseResult.getRootNode().getText();
            }
            return text;
        }

        protected MessageDigest createDigest() throws NoSuchAlgorithmException {
            return MessageDigest.getInstance("MD5");
        }
    }
}

