/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.operations;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.CompositeEMFOperation;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.qvt.declarative.editor.ui.IUndoContextAffecter;
import org.eclipse.qvt.declarative.editor.ui.IUndoableOperationHelper;
import org.eclipse.qvt.declarative.editor.ui.commands.PageChangeCommand;
import org.eclipse.qvt.declarative.editor.ui.commands.PageSaveCommand;

public class AbstractUndoableOperationHelper
implements IUndoableOperationHelper {
    public Command getCommand(IUndoableOperation operation) {
        if (operation instanceof EMFCommandOperation) {
            return ((EMFCommandOperation)operation).getCommand();
        }
        return null;
    }

    public boolean isDirty(IUndoableOperation operation) {
        if (operation instanceof EMFCommandOperation) {
            Command command = ((EMFCommandOperation)operation).getCommand();
            return !(command instanceof AbstractCommand.NonDirtying);
        }
        if (operation instanceof CompositeEMFOperation) {
            for (Object childOperation : (CompositeEMFOperation)operation) {
                if (!(childOperation instanceof AbstractEMFOperation) || !this.isDirty((IUndoableOperation)((AbstractEMFOperation)childOperation))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isPageChange(IUndoableOperation operation) {
        Command command = this.getCommand(operation);
        return command instanceof PageChangeCommand;
    }

    public boolean isPageSave(IUndoableOperation operation) {
        Command command = this.getCommand(operation);
        return command instanceof PageSaveCommand;
    }

    public void setAffectedContexts(IUndoableOperation operation) {
        if (operation instanceof AbstractEMFOperation) {
            this.setAffectedContexts(operation, (AbstractEMFOperation)operation);
        }
    }

    private void setAffectedContexts(IUndoableOperation operation, AbstractEMFOperation emfOperation) {
        if (emfOperation instanceof EMFCommandOperation) {
            Command command = ((EMFCommandOperation)emfOperation).getCommand();
            if (command instanceof IUndoContextAffecter) {
                ((IUndoContextAffecter)command).setAffectedContext(operation);
            }
        } else if (emfOperation instanceof CompositeEMFOperation) {
            for (Object childOperation : (CompositeEMFOperation)emfOperation) {
                if (!(childOperation instanceof AbstractEMFOperation)) continue;
                this.setAffectedContexts(operation, (AbstractEMFOperation)childOperation);
            }
        }
    }
}

