/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.AbstractProblemHandler;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.qvt.declarative.editor.ui.builder.MarkerProblemHandler;
import org.eclipse.qvt.declarative.editor.ui.builder.ProblemLimit;

public class CommonProblemHandler
extends AbstractProblemHandler {
    protected final IMessageHandler handler;
    private ProblemLimit problemLimit = null;

    public CommonProblemHandler(AbstractParser parser, IMessageHandler handler) {
        super(parser);
        this.handler = handler;
        handler.clearMessages();
    }

    public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
        Integer severity;
        int startLine = this.getParser().getTokenAtCharacter(startOffset).getLine();
        int startCol = this.getParser().getTokenAtCharacter(startOffset).getColumn();
        int endLine = this.getParser().getTokenAtCharacter(endOffset).getLine();
        int endCol = this.getParser().getTokenAtCharacter(startOffset).getColumn();
        String adjustedMessage = problemMessage;
        if (this.problemLimit != null && (adjustedMessage = this.problemLimit.check((severity = MarkerProblemHandler.severityMap.get(problemSeverity)) != null ? severity : 2, adjustedMessage)) == null) {
            return;
        }
        this.handler.handleSimpleMessage(problemMessage, startOffset, endOffset, startCol, endCol, startLine, endLine);
        if (adjustedMessage != problemMessage) {
            throw new ProblemLimit.LimitExceededException(adjustedMessage);
        }
    }

    public void setProblemLimit(ProblemLimit problemLimit) {
        this.problemLimit = problemLimit;
    }
}

