/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lpg.lpgjavaruntime.IToken;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.expressions.StringLiteralExp;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.qvt.declarative.ecore.utils.EcoreUtils;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonNodeLocator;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonNonProposal;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonParseController;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonProposal;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonProposal;
import org.eclipse.qvt.declarative.parser.environment.IHasName;
import org.eclipse.qvt.declarative.parser.qvt.cst.IdentifierCS;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonContentProposals {
    protected final CommonParseController commonParseController;
    protected final int offset;
    protected final Map<Object, ICommonProposal> map;
    protected CommonParseController.ParsedResult parsedResult;
    protected CSTNode cstRoot;
    protected IToken tokenAtOffset;
    protected String prefixAtOffset;

    public CommonContentProposals(CommonParseController commonParseController, int offset) {
        this.commonParseController = commonParseController;
        this.offset = offset;
        this.map = new HashMap<Object, ICommonProposal>();
    }

    protected void addIdentifierProposalCandidate(List<EStructuralFeature> usages, EObject candidate) {
        if (this.checkName(usages, candidate) && this.checkType(usages, candidate) && !this.map.containsKey(candidate)) {
            ILabelProvider labelProvider = this.commonParseController.getLabelProvider();
            String newText = EcoreUtils.formatName((Object)candidate);
            String displayText = String.valueOf(newText) + " - " + EcoreUtils.formatQualifiedName((Object)candidate.eContainer(), (String)"::");
            Image image = labelProvider.getImage((Object)candidate);
            this.map.put(candidate, new CommonProposal(displayText, this.tokenAtOffset.getStartOffset(), newText, this.tokenAtOffset.toString(), this.offset, image));
        }
    }

    protected void addIdentifierProposals(CSTNode cstNode) {
        Object astNode = cstNode.getAst();
        if (astNode == null && cstNode instanceof IdentifierCS && (astNode = ((CSTNode)cstNode.eContainer()).getAst()) != null) {
            System.out.println("Missing astNode deduced for " + astNode.getClass().getSimpleName());
        }
        if (astNode == null) {
            this.map.put(null, new CommonNonProposal("Internal error: no AST node to select completion proposal for " + cstNode.getClass().getSimpleName(), "", this.offset));
            return;
        }
        System.out.println("Proposal for '" + this.prefixAtOffset + "' " + cstNode.getClass().getSimpleName() + " " + (astNode != null ? astNode.getClass().getSimpleName() : "???"));
        if (astNode instanceof EObject) {
            List<EStructuralFeature> usages = this.computeUsage((EObject)astNode);
            for (Resource resource : this.getResources(usages, (EObject)astNode)) {
                TreeIterator i = resource.getAllContents();
                while (i.hasNext()) {
                    this.addIdentifierProposalCandidate(usages, (EObject)i.next());
                }
            }
        }
        if (this.map.isEmpty()) {
            this.map.put(null, new CommonNonProposal("no completion exists for '" + this.prefixAtOffset + "' " + cstNode.getClass().getSimpleName() + " " + (astNode != null ? astNode.getClass().getSimpleName() : "???"), "", this.offset));
        }
    }

    protected void addKeywordProposals() {
        Image image = null;
        for (String keyword : this.commonParseController.getKeywords()) {
            if (!keyword.startsWith(this.prefixAtOffset)) continue;
            this.map.put(keyword, new CommonProposal(keyword, this.tokenAtOffset.getStartOffset(), keyword, this.tokenAtOffset.toString(), this.offset, image));
        }
    }

    protected void addStringProposals() {
        Collection resources = this.parsedResult.getFileEnvironment().getResourcesVisibleAt(null);
        for (Resource resource : resources) {
            TreeIterator i = resource.getAllContents();
            while (i.hasNext()) {
                this.addStringProposalCandidate((EObject)i.next());
            }
        }
    }

    protected void addStringProposalCandidate(EObject candidate) {
        String string;
        if (candidate instanceof StringLiteralExp && !this.map.containsKey(string = ((StringLiteralExp)candidate).getStringSymbol()) && string.startsWith(this.prefixAtOffset.length() > 0 ? this.prefixAtOffset.substring(1) : "")) {
            String newText = "'" + string + "'";
            String displayText = string;
            Image image = null;
            this.map.put(string, new CommonProposal(displayText, this.tokenAtOffset.getStartOffset(), newText, this.tokenAtOffset.toString(), this.offset, image));
        }
    }

    protected boolean checkName(List<EStructuralFeature> usages, EObject eObject) {
        String name = this.getName(eObject);
        if (name == null) {
            return false;
        }
        return name.startsWith(this.prefixAtOffset);
    }

    protected boolean checkType(List<EStructuralFeature> usages, EObject eObject) {
        if (usages.isEmpty()) {
            return false;
        }
        for (EStructuralFeature requiredUsage : usages) {
            boolean okType;
            EClassifier requiredType = requiredUsage.getEType();
            EClass requiredClass = requiredType instanceof EClass ? (EClass)requiredType : null;
            EClass eClass = eObject.eClass();
            boolean bl = okType = requiredType == eClass || requiredClass != null && requiredClass.isSuperTypeOf(eClass);
            if (okType) continue;
            return false;
        }
        return true;
    }

    public void computeProposals() {
        this.parsedResult = this.commonParseController.getCurrentAst();
        if (this.parsedResult == null) {
            System.out.println("No Parsed Result");
            this.map.put(null, new CommonNonProposal("no info available due to Internal error", "", this.offset));
            return;
        }
        this.cstRoot = this.parsedResult.getCST();
        if (this.cstRoot == null) {
            System.out.println("No CST");
            this.map.put(null, new CommonNonProposal("no info available due to Syntax error(s)", "", this.offset));
            return;
        }
        this.tokenAtOffset = this.getToken();
        this.prefixAtOffset = this.getPrefix();
        CommonParseController.TokenKind tokenKind = this.commonParseController.getTokenKind(this.tokenAtOffset.getKind());
        switch (tokenKind) {
            case IDENTIFIER: {
                CommonNodeLocator locator = this.commonParseController.getCreationFactory().createNodeLocator(this.parsedResult.getFileEnvironment());
                CSTNode node = (CSTNode)locator.findNode(this.cstRoot, this.tokenAtOffset.getStartOffset(), this.tokenAtOffset.getEndOffset());
                if (node == null) {
                    System.out.println("No CST node");
                    this.map.put(null, new CommonNonProposal("no info available due to Syntax error(s)", "", this.offset));
                    break;
                }
                this.addIdentifierProposals(node);
                break;
            }
            case KEYWORD: {
                CommonNodeLocator locator = this.commonParseController.getCreationFactory().createNodeLocator(this.parsedResult.getFileEnvironment());
                CSTNode node = (CSTNode)locator.findNode(this.cstRoot, this.tokenAtOffset.getStartOffset(), this.tokenAtOffset.getEndOffset());
                if (node instanceof IdentifierCS || node instanceof SimpleNameCS) {
                    this.addIdentifierProposals(node);
                } else {
                    this.addKeywordProposals();
                }
                if (!this.map.isEmpty()) break;
                this.map.put(null, new CommonNonProposal("no completion exists for keyword: " + this.prefixAtOffset, "", this.offset));
                break;
            }
            case STRING: {
                this.addStringProposals();
                if (!this.map.isEmpty()) break;
                this.map.put(null, new CommonNonProposal("no completion exists for string: " + this.prefixAtOffset, "", this.offset));
                break;
            }
            default: {
                this.map.put(null, new CommonNonProposal("no completion exists for " + (Object)((Object)tokenKind) + ": " + this.prefixAtOffset, "", this.offset));
            }
        }
    }

    protected List<EStructuralFeature> computeUsage(EObject astNode) {
        Resource resource;
        ArrayList<EStructuralFeature> usages = new ArrayList<EStructuralFeature>();
        Object rootAst = this.cstRoot.getAst();
        Resource resource2 = resource = rootAst instanceof Resource ? (Resource)rootAst : null;
        if (resource == null) {
            resource = astNode.eResource();
        }
        Collection settings = EcoreUtil.UsageCrossReferencer.find((EObject)astNode, (Resource)resource);
        for (EStructuralFeature.Setting setting : settings) {
            EStructuralFeature structuralFeature = setting.getEStructuralFeature();
            if (usages.contains(structuralFeature)) continue;
            usages.add(structuralFeature);
        }
        EStructuralFeature containingFeature = astNode.eContainingFeature();
        if (containingFeature == null && astNode instanceof EPackage) {
            containingFeature = EcorePackage.Literals.EPACKAGE__ESUBPACKAGES;
        }
        if (containingFeature != null && !usages.contains(containingFeature)) {
            usages.add(containingFeature);
        }
        return usages;
    }

    protected String getName(EObject eObject) {
        if (eObject instanceof ENamedElement) {
            return ((ENamedElement)eObject).getName();
        }
        if (eObject instanceof IHasName) {
            return ((IHasName)eObject).getName();
        }
        return null;
    }

    protected String getPrefix() {
        if (this.commonParseController.isCompleteable(this.tokenAtOffset.getKind()) && this.tokenAtOffset.getStartOffset() <= this.offset && this.offset <= this.tokenAtOffset.getEndOffset() + 1) {
            return this.tokenAtOffset.toString().substring(0, this.offset - this.tokenAtOffset.getStartOffset());
        }
        return "";
    }

    protected Collection<Resource> getResources(List<EStructuralFeature> usages, EObject astNode) {
        return this.parsedResult.getFileEnvironment().getResourcesVisibleAt(astNode);
    }

    protected IToken getToken() {
        AbstractParser stream = this.commonParseController.getParser();
        int index = stream.getTokenIndexAtCharacter(this.offset);
        int token_index = index < 0 ? -(index - 1) : index;
        int previous_index = stream.getPrevious(token_index);
        int previousIndexKind = stream.getKind(previous_index);
        boolean isIdentifier = this.commonParseController.isIdentifier(previousIndexKind);
        boolean isKeyword = this.commonParseController.isKeyword(previousIndexKind);
        boolean atEnd = this.offset == stream.getEndOffset(previous_index) + 1;
        return stream.getIToken((isIdentifier || isKeyword) && atEnd ? previous_index : token_index);
    }

    public ICompletionProposal[] sortProposals() {
        ArrayList<ICommonProposal> list = new ArrayList<ICommonProposal>(this.map.values());
        Collections.sort(list);
        return list.toArray(new ICommonProposal[list.size()]);
    }
}

