/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.tools.tge.editor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.am3.core.AM3CorePlugin;
import org.eclipse.am3.core.AM3Handler;
import org.eclipse.am3.tools.tge.TextualGenericEditorPlugin;
import org.eclipse.am3.tools.tge.editor.SourceViewerConfig;
import org.eclipse.am3.tools.tge.outline.TextualGenericEditorContentOutlinePage;
import org.eclipse.am3.tools.tge.properties.TGEPropertySourceProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMEnumLiteral;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;
import org.eclipse.m2m.atl.ocl.core.OclHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class TextualGenericEditor
extends TextEditor {
    private ESCL editorSelectionChangedListener;
    private TextualGenericEditorContentOutlinePage outlinePage;
    private SourceViewerConfig sourceViewerConfiguration;
    private String fileExtension = "";
    private PropertySheetPage propertySheetPage = null;
    private AM3Handler handler;
    private Map models = new HashMap();
    private String relativeModelEditorUri;
    private ASMModelElement editorArtifact;
    private static OclHelper findEditor = new OclHelper("AM3!Editor.allInstances()->select(e | e.extension = fileExtension)->first()", Arrays.asList("fileExtension"));
    public static OclHelper getMetamodel = new OclHelper("model.relationEnds->collect(e | e.relation)->select(e | e.oclIsKindOf(AM3!ConformedToMetamodel))->first().relationEnds->collect(e | e.artifact)->select(e | e.oclIsKindOf(AM3!Metamodel))->first()", Arrays.asList("model"));
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public TextualGenericEditor() {
        this.sourceViewerConfiguration = new SourceViewerConfig(this);
        this.setSourceViewerConfiguration(this.sourceViewerConfiguration);
    }

    public void initHandler(String filename) {
        int dot = filename.lastIndexOf(".");
        this.fileExtension = filename.substring(dot + 1);
        this.models.put("AM3", AM3CorePlugin.getDefault().getHandler().getAsmModelAM3());
        this.models.put("mgm", AM3CorePlugin.getDefault().getHandler().getAsmModelMegamodel());
        String errorMsg = null;
        try {
            ASMOclAny cls = findEditor.eval(Arrays.asList(new ASMString(this.fileExtension)), this.models);
            if (cls instanceof ASMModelElement) {
                this.editorArtifact = (ASMModelElement)cls;
                this.relativeModelEditorUri = ((ASMString)this.editorArtifact.get(null, "uri")).getSymbol();
                String modelEditorUri = TextualGenericEditor.getArtifactUri(this.editorArtifact);
                cls = getMetamodel.eval(Arrays.asList(this.editorArtifact), this.models);
                if (cls instanceof ASMModelElement) {
                    String uriMetamodel = TextualGenericEditor.getArtifactUri((ASMModelElement)cls);
                    this.handler = new AM3Handler(uriMetamodel, modelEditorUri);
                } else {
                    errorMsg = "Cannot find Editor metamodel in megamodel.";
                }
            } else {
                errorMsg = "Cannot find Editor model for extention \"" + this.fileExtension + "\". Please register appropriate megamodel.";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (errorMsg != null) {
            Status error = new Status(4, TextualGenericEditorPlugin.getDefault().getBundle().getSymbolicName(), 1, errorMsg, null);
            ErrorDialog.openError((Shell)this.getEditorSite().getWorkbenchWindow().getShell(), (String)"Editor creation error", null, (IStatus)error);
            TextualGenericEditorPlugin.getDefault().getLog().log((IStatus)error);
            throw new RuntimeException(errorMsg);
        }
    }

    public void createPartControl(Composite parent) {
        String currentEditorName = this.getEditorInput().getName();
        this.initHandler(currentEditorName);
        super.createPartControl(parent);
        this.editorSelectionChangedListener = new ESCL();
        IPostSelectionProvider editorSelectionProvider = (IPostSelectionProvider)this.getSelectionProvider();
        editorSelectionProvider.addPostSelectionChangedListener((ISelectionChangedListener)this.editorSelectionChangedListener);
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            if (this.outlinePage == null && this.getEditorInput() != null) {
                this.outlinePage = new TextualGenericEditorContentOutlinePage(this, this.getEditorInput(), this.getDocumentProvider());
            }
            return this.outlinePage;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            if (this.propertySheetPage == null) {
                this.propertySheetPage = new PropertySheetPage();
                this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new TGEPropertySourceProvider());
            }
            return this.propertySheetPage;
        }
        return super.getAdapter(required);
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }

    protected void doSetSelection(ISelection selection) {
        super.doSetSelection(selection);
        this.synchronizeOutlinePageSelection();
    }

    private void synchronizeOutlinePageSelection() {
        if (this.outlinePage != null) {
            this.outlinePage.updateSelection();
        }
    }

    public String cursorPosition() {
        return this.getCursorPosition();
    }

    public String getDocumentProviderContent() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput()).get();
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public SourceViewerConfig getSourceViewerConfig() {
        return this.sourceViewerConfiguration;
    }

    public AM3Handler getHandler() {
        return this.handler;
    }

    public Map getModels() {
        return this.models;
    }

    public static String getArtifactUri(ASMModelElement artifact) {
        String artifactUri;
        String relativeUriArtifact = ((ASMString)artifact.get(null, "uri")).getSymbol();
        if (((ASMEnumLiteral)artifact.get(null, "locationType")).getName().equals("workspace")) {
            IWorkspace wks = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot wksroot = wks.getRoot();
            IFile currentModel = wksroot.getFile((IPath)new Path(relativeUriArtifact));
            artifactUri = currentModel.getLocation().toOSString();
        } else {
            artifactUri = String.valueOf(TextualGenericEditorPlugin.getPluginRep()) + relativeUriArtifact;
        }
        return artifactUri;
    }

    public String getRelativeModelEditorUri() {
        return this.relativeModelEditorUri;
    }

    public ASMModelElement getEditorArtifact() {
        return this.editorArtifact;
    }

    private class ESCL
    implements ISelectionChangedListener {
        private ESCL() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TextualGenericEditor.this.synchronizeOutlinePageSelection();
        }
    }
}

