/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.am3.core.AM3CorePlugin;
import org.eclipse.am3.core.AM3Handler;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.atl.engine.AtlEMFModelHandler;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class AM3CoreTools {
    private static AM3Handler handler = AM3CorePlugin.getDefault().getHandler();

    public static AM3Handler getHandler() {
        return handler;
    }

    public static EObject getMegamodel() {
        return (EObject)handler.getElementsByType("Megamodel").iterator().next();
    }

    public static EObject getArtifactByUri(String uri) {
        EObject[] elts = handler.getElementsBySupertype("Artifact").toArray(new EObject[0]);
        int i = 0;
        while (i < elts.length) {
            EObject elt = elts[i];
            if (handler.get(elt, "uri").equals(uri)) {
                return elt;
            }
            ++i;
        }
        return null;
    }

    public static EObject getRelation(EObject artifact, String relationType) {
        EList relationEnds = (EList)handler.get(artifact, "relationEnds");
        Iterator it = relationEnds.iterator();
        while (it.hasNext()) {
            EObject currentRE = (EObject)it.next();
            EObject relation = (EObject)handler.get(currentRE, "relation");
            if (!relation.eClass().getName().equals(relationType)) continue;
            return relation;
        }
        return null;
    }

    public static EObject getOppositeArtifact(EObject relation, EObject artifact) {
        EList relationEnds = (EList)handler.get(relation, "relationEnds");
        Iterator it = relationEnds.iterator();
        while (it.hasNext()) {
            EObject relationEnd = (EObject)it.next();
            EObject artifactRE = (EObject)handler.get(relationEnd, "artifact");
            if (artifactRE.equals(artifact)) continue;
            return artifactRE;
        }
        return null;
    }

    public static EList getAttributes(EObject currentEObject) {
        return currentEObject.eClass().getEAllAttributes();
    }

    public static String[] getSubTypeListOf(String eClassName, Resource resource) {
        ArrayList<String> result = new ArrayList<String>();
        if (resource != null) {
            Iterator eClassesIterator = AM3CoreTools.getAllEClass(resource).iterator();
            while (eClassesIterator.hasNext()) {
                EClass eClass = (EClass)eClassesIterator.next();
                EList superTypes = eClass.getEAllSuperTypes();
                int i = 0;
                while (i < superTypes.size()) {
                    EClass superType = (EClass)superTypes.get(i);
                    if (AM3CoreTools.isSuperTypeOf(superType, eClassName, resource) && !result.contains(eClass.getName())) {
                        result.add(eClass.getName());
                    }
                    ++i;
                }
            }
        }
        return result.toArray(new String[0]);
    }

    private static boolean isSuperTypeOf(EClass someClass, String superType, Resource resource) {
        EClass superTypeEClass = AM3CoreTools.getEClassByName(resource, superType);
        if (superTypeEClass == null) {
            return false;
        }
        superTypeEClass.getEAllSuperTypes();
        return superTypeEClass.isSuperTypeOf(someClass);
    }

    private static EClass getEClassByName(Resource modelResource, String name) {
        if (modelResource != null) {
            TreeIterator i = modelResource.getAllContents();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof EClass) || !name.equals(((EClass)obj).getName())) continue;
                return (EClass)obj;
            }
        }
        return null;
    }

    private static List getAllEClass(Resource modelResource) {
        ArrayList<EClass> eClasses = new ArrayList<EClass>();
        TreeIterator i = modelResource.getAllContents();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof EClass)) continue;
            eClasses.add((EClass)obj);
        }
        return eClasses;
    }

    public static ASMModel loadMetamodel(AtlModelHandler amh, String modelName, String modelUri) throws FileNotFoundException {
        ASMModel model;
        if (modelUri.startsWith("uri:")) {
            model = ((AtlEMFModelHandler)amh).loadModel(modelName, amh.getMof(), modelUri);
        } else {
            File languageMetamodel = new File(String.valueOf(AM3CorePlugin.getPluginRep()) + modelUri);
            model = amh.loadModel(modelName, amh.getMof(), (InputStream)new FileInputStream(languageMetamodel));
        }
        return model;
    }

    public static String getPluginPath(String idPlugin) {
        try {
            URL urlPlatform = Platform.getBundle((String)idPlugin).getEntry("/");
            URL localFileInPluginURL = FileLocator.toFileURL((URL)urlPlatform);
            String path = localFileInPluginURL.getPath().toString();
            return path;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

