/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.tools.tge.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.am3.tools.tge.editor.CompletionProcessor;
import org.eclipse.am3.tools.tge.editor.RuleScanner;
import org.eclipse.am3.tools.tge.editor.TextualGenericEditor;
import org.eclipse.am3.tools.tge.outline.DocumentOffsetCount;
import org.eclipse.am3.tools.tge.outline.Position;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.DefaultAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class SourceViewerConfig
extends SourceViewerConfiguration {
    private RuleScanner scanner;
    private TextualGenericEditor tge;
    private static Color DEFAULT_TAG_COLOR = new Color((Device)Display.getCurrent(), new RGB(0, 0, 0));
    private List hyperlinks;

    public SourceViewerConfig(TextualGenericEditor tge) {
        this.tge = tge;
    }

    protected RuleScanner getTagScanner() {
        if (this.scanner == null) {
            this.scanner = new RuleScanner(this.tge);
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(DEFAULT_TAG_COLOR)));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new CompletionProcessor(), "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        return assistant;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new DefaultAnnotationHover();
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new ITextHover(){

            public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
                if (SourceViewerConfig.this.hyperlinks == null) {
                    return null;
                }
                int offset = hoverRegion.getOffset();
                Iterator i = SourceViewerConfig.this.hyperlinks.iterator();
                while (i.hasNext()) {
                    TGEHyperLink ihl = (TGEHyperLink)i.next();
                    int hOffset = ihl.getHyperlinkRegion().getOffset();
                    int hLength = ihl.getHyperlinkRegion().getLength();
                    if (offset < hOffset || offset >= hOffset + hLength) continue;
                    try {
                        IDocument doc = textViewer.getDocument();
                        int initialOffset = ihl.getTargetOffset();
                        int finalOffset = doc.getLineOffset(doc.getLineOfOffset(initialOffset));
                        return doc.get(finalOffset, ihl.getTargetLength() + initialOffset - finalOffset);
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                return null;
            }

            public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
                if (SourceViewerConfig.this.hyperlinks == null) {
                    return null;
                }
                Iterator i = SourceViewerConfig.this.hyperlinks.iterator();
                while (i.hasNext()) {
                    IHyperlink ihl = (IHyperlink)i.next();
                    int hOffset = ihl.getHyperlinkRegion().getOffset();
                    int hLength = ihl.getHyperlinkRegion().getLength();
                    if (offset < hOffset || offset >= hOffset + hLength) continue;
                    return ihl.getHyperlinkRegion();
                }
                return null;
            }
        };
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        return new IHyperlinkDetector[]{new IHyperlinkDetector(){

            public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
                if (SourceViewerConfig.this.hyperlinks == null) {
                    return null;
                }
                int offset = region.getOffset();
                ArrayList<IHyperlink> ret = new ArrayList<IHyperlink>();
                Iterator i = SourceViewerConfig.this.hyperlinks.iterator();
                while (i.hasNext()) {
                    IHyperlink ihl = (IHyperlink)i.next();
                    int hOffset = ihl.getHyperlinkRegion().getOffset();
                    int hLength = ihl.getHyperlinkRegion().getLength();
                    if (offset < hOffset || offset >= hOffset + hLength) continue;
                    ret.add(ihl);
                }
                if (ret.isEmpty()) {
                    return null;
                }
                return ret.toArray(new IHyperlink[0]);
            }
        }};
    }

    public void setHyperlinks(Map hyperlinks, DocumentOffsetCount help, TextualGenericEditor editor) {
        ArrayList<TGEHyperLink> hls = new ArrayList<TGEHyperLink>();
        int k = 0;
        Iterator i = hyperlinks.keySet().iterator();
        while (i.hasNext()) {
            String source = (String)i.next();
            String target = (String)hyperlinks.get(source);
            Position[] sourcePos = help.getPositions(source);
            int sourceLength = sourcePos[1].getOffset() - sourcePos[0].getOffset();
            int sourceOffset = sourcePos[0].getOffset();
            Position[] targetPos = help.getPositions(target);
            int targetLength = targetPos[1].getOffset() - targetPos[0].getOffset();
            int targetOffset = targetPos[0].getOffset();
            hls.add(new TGEHyperLink(editor, targetLength, targetOffset, sourceLength, sourceOffset));
            ++k;
        }
        this.hyperlinks = hls;
    }

    public static class TGEHyperLink
    implements IHyperlink {
        private final int targetLength;
        private final int targetOffset;
        private final TextualGenericEditor editor;
        private IRegion hyperLinkRegion;

        public TGEHyperLink(TextualGenericEditor editor, int targetLength, int targetOffset, int sourceLength, int sourceOffset) {
            this.editor = editor;
            this.targetLength = targetLength;
            this.targetOffset = targetOffset;
            this.hyperLinkRegion = new IRegion(this, sourceLength, sourceOffset){
                final /* synthetic */ TGEHyperLink this$1;
                private final /* synthetic */ int val$sourceLength;
                private final /* synthetic */ int val$sourceOffset;
                {
                    this.this$1 = tGEHyperLink;
                    this.val$sourceLength = n;
                    this.val$sourceOffset = n2;
                }

                public int getLength() {
                    return this.val$sourceLength;
                }

                public int getOffset() {
                    return this.val$sourceOffset;
                }
            };
        }

        public IRegion getHyperlinkRegion() {
            return this.hyperLinkRegion;
        }

        public int getTargetLength() {
            return this.targetLength;
        }

        public int getTargetOffset() {
            return this.targetOffset;
        }

        public String getTypeLabel() {
            return null;
        }

        public String getHyperlinkText() {
            return null;
        }

        public void open() {
            this.editor.setHighlightRange(this.targetOffset, this.targetLength, true);
        }
    }
}

