/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.tools.tge.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.am3.tools.tge.editor.BlockColor;
import org.eclipse.am3.tools.tge.editor.Lexems;
import org.eclipse.am3.tools.tge.editor.TextualGenericEditor;
import org.eclipse.am3.tools.tge.editor.WordDetector;
import org.eclipse.am3.tools.tge.editor.WordsColor;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.NumberRule;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class RuleScanner
extends RuleBasedScanner {
    private HashMap tokenMap = new HashMap();
    private TextualGenericEditor tge;

    public RuleScanner(TextualGenericEditor tge) {
        this.tge = tge;
        this.initialize();
    }

    protected List createRules() {
        ArrayList<Object> rules = new ArrayList<Object>();
        Lexems lexem = new Lexems(this.tge);
        Iterator it = lexem.getBlock().iterator();
        while (it.hasNext()) {
            BlockColor trans = (BlockColor)it.next();
            if (trans.getEnd().equals("")) {
                rules.add(new EndOfLineRule(trans.getBegin(), (IToken)new Token((Object)new TextAttribute(trans.getColor(), null, trans.getStyle()))));
                continue;
            }
            rules.add(new MultiLineRule(trans.getBegin(), trans.getEnd(), (IToken)new Token((Object)new TextAttribute(trans.getColor(), null, trans.getStyle()))));
        }
        rules.add(new NumberRule((IToken)new Token((Object)new TextAttribute(new Color((Device)Display.getCurrent(), new RGB(255, 0, 0))))));
        WordRule wordRule = new WordRule((IWordDetector)new WordDetector(), (IToken)new Token((Object)new TextAttribute(new Color((Device)Display.getCurrent(), new RGB(0, 0, 0)))));
        Iterator it2 = lexem.getGroup().iterator();
        while (it2.hasNext()) {
            WordsColor trans = (WordsColor)it2.next();
            ArrayList<String> symbols = new ArrayList<String>();
            int j = 0;
            boolean symb = false;
            int i = 0;
            while (i < trans.getWords().length) {
                if ('A' <= trans.getWords()[i].charAt(0) && trans.getWords()[i].charAt(0) <= 'Z' || 'a' <= trans.getWords()[i].charAt(0) && 'z' >= trans.getWords()[i].charAt(0)) {
                    wordRule.addWord(trans.getWords()[i], (IToken)new Token((Object)new TextAttribute(trans.getColor(), null, trans.getStyle())));
                    symb = false;
                } else {
                    symb = true;
                    symbols.add(trans.getWords()[i]);
                    ++j;
                }
                ++i;
            }
            if (symb) {
                rules.add(new SymbolRule(symbols, new Token((Object)new TextAttribute(trans.getColor(), null, trans.getStyle()))));
            }
            symb = false;
        }
        rules.add(wordRule);
        return rules;
    }

    public Token getToken(String col) {
        return (Token)this.tokenMap.get(col);
    }

    public final void initialize() {
        List rules = this.createRules();
        if (rules != null) {
            IRule[] result = new IRule[rules.size()];
            rules.toArray(result);
            this.setRules(result);
        }
    }

    private class SymbolRule
    implements IRule {
        private final IToken token;
        private final ArrayList list;

        public SymbolRule(ArrayList list, Token token) {
            this.list = list;
            this.token = token;
        }

        public IToken evaluate(ICharacterScanner scanner) {
            int character = scanner.read();
            if (this.isInList((char)character)) {
                while (this.isInList((char)(character = scanner.read()))) {
                }
                scanner.unread();
                return this.token;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }

        public boolean isInList(char character) {
            int i = 0;
            while (i < this.list.size()) {
                if (this.list.get(i).equals(Character.toString(character))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

