/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.part;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NewDiagramHandlerBase
extends AbstractHandler {
    private final TransactionalEditingDomain myEditingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();

    protected abstract Wizard getNewDiagramWizard(Package var1);

    protected abstract Wizard getNewSemiSyncDiagramWizard(Package var1, List<Element> var2);

    protected abstract void runWizard(Wizard var1, Shell var2);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        List<Element> selectedElements = this.getSelectedElements(this.getStructuredSelection(event));
        Package diagramRoot = this.getDiagramRoot(selectedElements);
        Wizard wizard = null;
        wizard = selectedElements.size() == 1 && diagramRoot.equals(selectedElements.get(0)) ? this.getNewDiagramWizard(diagramRoot) : this.getNewSemiSyncDiagramWizard(diagramRoot, selectedElements);
        if (wizard == null) {
            return null;
        }
        wizard.setWindowTitle("Initialize new diagram file");
        this.runWizard(wizard, part.getSite().getShell());
        return null;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return this.myEditingDomain;
    }

    private IStructuredSelection getStructuredSelection(ExecutionEvent event) throws ExecutionException {
        IEditorPart diagramEditor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        assert (diagramEditor instanceof DiagramEditor);
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    private List<Element> getSelectedElements(IStructuredSelection ss) throws ExecutionException {
        ArrayList<Element> selectedElements = new ArrayList<Element>();
        Object[] objectArray = ss.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object next = objectArray[n2];
            Element pe = this.getValidElement(next);
            if (pe != null) {
                selectedElements.add(pe);
            }
            ++n2;
        }
        return selectedElements;
    }

    protected Element getValidElement(Object object) {
        if (object instanceof IGraphicalEditPart) {
            object = ((IGraphicalEditPart)object).resolveSemanticElement();
        }
        if (object instanceof Element) {
            return (Element)object;
        }
        return null;
    }

    private Package getDiagramRoot(List<Element> selected) {
        if (selected == null || selected.size() == 0) {
            return null;
        }
        for (Element next : selected) {
            Package pakkage = next.getNearestPackage();
            if (pakkage == null) continue;
            return pakkage;
        }
        return null;
    }

    protected URI getDiagramFileURI(Package diagramRoot) {
        return diagramRoot.eResource().getURI();
    }
}

