/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.async;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.uml2.diagram.common.genapi.IDiagramUpdater;
import org.eclipse.uml2.diagram.common.genapi.IVisualIDRegistry;

public class SyncModelContext {
    private static final String SYNC_RESOURCE_TEMP_URI = "uri://temp/" + SyncModelContext.class.getName() + "/temp";
    private final PreferencesHint myPreferencesHint;
    private final IDiagramUpdater myUpdater;
    private final IVisualIDRegistry myRegistry;
    private final TransactionalEditingDomain myDomain;
    private final boolean myIsDiagramInitialization;
    private Resource mySyncModelResource;

    public SyncModelContext(IDiagramUpdater updater, IVisualIDRegistry registry, PreferencesHint preferencesHint, TransactionalEditingDomain domain) {
        this(updater, registry, preferencesHint, domain, false);
    }

    public SyncModelContext(IDiagramUpdater updater, IVisualIDRegistry registry, PreferencesHint preferencesHint, TransactionalEditingDomain domain, boolean isDiagramInit) {
        this.myUpdater = updater;
        this.myRegistry = registry;
        this.myPreferencesHint = preferencesHint;
        this.myDomain = domain;
        this.myIsDiagramInitialization = isDiagramInit;
    }

    public PreferencesHint getPreferencesHint() {
        return this.myPreferencesHint;
    }

    public IDiagramUpdater getUpdater() {
        return this.myUpdater;
    }

    public IVisualIDRegistry getRegistry() {
        return this.myRegistry;
    }

    public boolean isDiagramInitialization() {
        return this.myIsDiagramInitialization;
    }

    public TransactionalEditingDomain getDomain() {
        return this.myDomain;
    }

    public Resource getSyncModelResource() {
        if (this.mySyncModelResource == null) {
            URI syncModelURI = URI.createURI((String)SYNC_RESOURCE_TEMP_URI);
            this.mySyncModelResource = this.getResourceSet().createResource(syncModelURI);
            if (this.mySyncModelResource == null) {
                throw new IllegalStateException("Can't create sync model resource: " + syncModelURI);
            }
        }
        return this.mySyncModelResource;
    }

    public void dispose() {
        if (this.mySyncModelResource != null) {
            this.mySyncModelResource.unload();
            this.getResourceSet().getResources().remove((Object)this.mySyncModelResource);
            this.mySyncModelResource = null;
        }
    }

    public void runCommand(AbstractTransactionalCommand command) {
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public void runCommand(final Runnable command) {
        this.runCommand(new AbstractTransactionalCommand(this.myDomain, "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                command.run();
                return CommandResult.newOKCommandResult();
            }
        });
    }

    private ResourceSet getResourceSet() {
        return this.myDomain.getResourceSet();
    }
}

