/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.expressions.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumLiteralExpOperations {
    protected EnumLiteralExpOperations() {
    }

    public static <C, EL> boolean checkEnumType(EnumLiteralExp<C, EL> enumLiteralExp, DiagnosticChain diagnostics, Map<Object, Object> context) {
        UMLReflection uml;
        EL l = enumLiteralExp.getReferredEnumLiteral();
        Object type = enumLiteralExp.getType();
        boolean result = true;
        String message = null;
        Environment env = OCLUtil.getValidationEnvironment(enumLiteralExp, context);
        if (!(env == null || type == null || (uml = env.getUMLReflection()).isEnumeration(type) && TypeUtil.exactTypeMatch(env, uml.getEnumeration(l), type))) {
            result = false;
            message = OCLMessages.bind(OCLMessages.IllegalEnumLiteral_ERROR_, enumLiteralExp.toString());
        }
        if (!result && diagnostics != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.ocl.expressions", 9, message, new Object[]{enumLiteralExp}));
        }
        return result;
    }
}

