/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.resourceloading.internal.ui.editor;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.IPageUtils;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.services.resourceloading.internal.ui.editor.UnloadResourcesEditorModel;
import org.eclipse.papyrus.infra.tools.util.PlatformHelper;

class LoadDiagramCommand
implements Runnable {
    private final IPageManager pageManager;
    private final ISashWindowsContainer sashContainer;
    private final URI uri;

    public LoadDiagramCommand(Resource resource) {
        this(resource, LoadDiagramCommand.getService(resource, IPageManager.class), LoadDiagramCommand.getService(resource, ISashWindowsContainer.class));
    }

    private static <S> S getService(Resource resource, Class<S> serviceAPI) {
        Object result = null;
        try {
            result = ServiceUtilsForResource.getInstance().getService(serviceAPI, (Object)resource);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return (S)result;
    }

    public LoadDiagramCommand(Resource resource, IPageManager pageManager, ISashWindowsContainer sashContainer) {
        this.pageManager = pageManager;
        this.sashContainer = sashContainer;
        this.uri = resource.getURI();
    }

    @Override
    public void run() {
        List<?> pagesToReload = this.getPagesToReload();
        if (!pagesToReload.isEmpty()) {
            pagesToReload.forEach(arg_0 -> ((IPageManager)this.pageManager).reloadPage(arg_0));
        }
    }

    public boolean canExecute() {
        List<?> pages = this.getPagesToReload();
        return !pages.isEmpty() && pages.stream().allMatch(this::needsReload);
    }

    private List<?> getPagesToReload() {
        List result;
        if (this.pageManager == null) {
            result = Collections.EMPTY_LIST;
        } else {
            result = this.pageManager.getAssociatedPages((Object)this.uri.trimFragment().trimFileExtension());
            result.removeIf(Objects::isNull);
        }
        return result;
    }

    private boolean needsReload(Object pageIdentifier) {
        boolean result = false;
        if (this.sashContainer != null) {
            IPage page = IPageUtils.lookupModelPage((ISashWindowsContainer)this.sashContainer, (Object)pageIdentifier);
            result = page != null && this.isUnloadedResourcePage(page);
        }
        return result;
    }

    private boolean isUnloadedResourcePage(IPage page) {
        IPageModel model = (IPageModel)PlatformHelper.getAdapter((Object)page, IPageModel.class);
        return model != null && model instanceof UnloadResourcesEditorModel;
    }
}

