/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.gef.GraphicalEditPart;

public final class EditPartUtilities {
    private EditPartUtilities() {
    }

    public static LinkedHashSet getAllChildren(GraphicalEditPart parentEditPart) {
        LinkedHashSet transitiveChildren = new LinkedHashSet();
        List children = parentEditPart.getChildren();
        transitiveChildren.addAll(children);
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            GraphicalEditPart child = (GraphicalEditPart)iterator.next();
            transitiveChildren.addAll(EditPartUtilities.getAllChildren(child));
        }
        return transitiveChildren;
    }

    public static HashSet getAllNestedConnectionEditParts(GraphicalEditPart graphicalEditPart) {
        HashSet transitiveConnections = new HashSet();
        LinkedHashSet transitiveChildren = EditPartUtilities.getAllChildren(graphicalEditPart);
        Iterator iterator = transitiveChildren.iterator();
        while (iterator.hasNext()) {
            GraphicalEditPart child = (GraphicalEditPart)iterator.next();
            transitiveConnections.addAll(child.getSourceConnections());
            transitiveConnections.addAll(child.getTargetConnections());
        }
        return transitiveConnections;
    }

    public static HashSet getNestedConnectionEditParts(GraphicalEditPart graphicalEditPart) {
        HashSet edges = new HashSet();
        List children = graphicalEditPart.getChildren();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            if (!(child instanceof GraphicalEditPart)) continue;
            GraphicalEditPart childEditPart = (GraphicalEditPart)child;
            edges.addAll(childEditPart.getSourceConnections());
            edges.addAll(childEditPart.getTargetConnections());
        }
        return edges;
    }
}

