/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.resourceloading;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.controlmode.mm.history.ControledResource;

public class ControledResourceAdapter
implements Adapter.Internal {
    private Map<String, List<ControledResource>> resources = new HashMap<String, List<ControledResource>>();
    private ModelSet modelSet = null;

    public ControledResourceAdapter(ModelSet modelSet) {
        this.modelSet = modelSet;
        this.manageAllControledResources();
        modelSet.eAdapters().add((Object)this);
    }

    protected void put(ControledResource controled) {
        List<ControledResource> list = this.resources.get(controled.getResourceURL());
        if (list == null) {
            list = new LinkedList<ControledResource>();
            this.resources.put(controled.getResourceURL(), list);
            this.addAdapter((Notifier)controled);
        }
        list.add(controled);
    }

    public void manageAllControledResources() {
        for (Resource r : this.modelSet.getResources()) {
            this.addResource(r);
        }
    }

    protected void addResource(Resource r) {
        if ("di".equals(r.getURI().fileExtension())) {
            for (EObject e : r.getContents()) {
                ControledResource root;
                if (!(e instanceof ControledResource) || (root = (ControledResource)e) == null) continue;
                this.put(root);
                TreeIterator i = root.eAllContents();
                while (i.hasNext()) {
                    EObject eobject = (EObject)i.next();
                    if (!(eobject instanceof ControledResource)) continue;
                    this.put((ControledResource)eobject);
                }
            }
            if (!r.eAdapters().contains((Object)this)) {
                r.eAdapters().add((Object)this);
            }
        }
    }

    public List<ControledResource> getControledResource(String locationURL) {
        List<ControledResource> list = this.resources.get(locationURL);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public void notifyChanged(Notification notification) {
        block16: {
            Notifier aNotifier;
            block15: {
                aNotifier = (Notifier)notification.getNotifier();
                if (!(aNotifier instanceof EObject)) break block15;
                switch (notification.getEventType()) {
                    case 3: {
                        this.addControledResource(notification.getNewValue());
                        break;
                    }
                    case 5: {
                        List list = (List)notification.getNewValue();
                        for (Object o : list) {
                            this.addControledResource(o);
                        }
                        break block16;
                    }
                    case 4: {
                        this.removeControledResource(notification.getOldValue());
                        break;
                    }
                    case 6: {
                        List list2 = (List)notification.getOldValue();
                        for (Object o : list2) {
                            this.removeControledResource(o);
                        }
                        break block16;
                    }
                }
                break block16;
            }
            if (aNotifier instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: {
                        this.addResource((Resource)aNotifier);
                    }
                }
            } else if (aNotifier instanceof ModelSet && notification.getNewValue() instanceof Resource) {
                Resource r = (Resource)notification.getNewValue();
                if (!r.eAdapters().contains((Object)this)) {
                    r.eAdapters().add((Object)this);
                }
                this.setTarget((Resource)notification.getNewValue());
            }
        }
    }

    protected void addControledResource(Object o) {
        if (o instanceof ControledResource) {
            ControledResource o2 = (ControledResource)o;
            this.put(o2);
        }
    }

    protected void removeControledResource(Object o) {
        ControledResource res;
        List<ControledResource> list;
        if (o instanceof ControledResource && (list = this.resources.get((res = (ControledResource)o).getResourceURL())) != null) {
            list.remove(res);
            if (list.isEmpty()) {
                this.resources.remove(res.getResourceURL());
            }
        }
    }

    public Notifier getTarget() {
        return this.modelSet;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    protected void setTarget(EObject target) {
        Iterator i = ((InternalEList)target.eContents()).basicIterator();
        while (i.hasNext()) {
            Notifier notifier = (Notifier)i.next();
            this.addAdapter(notifier);
        }
    }

    protected void addAdapter(Notifier notifier) {
        EList eAdapters = notifier.eAdapters();
        if (!eAdapters.contains(this)) {
            eAdapters.add(this);
        }
    }

    public void setTarget(Notifier target) {
        if (target instanceof EObject) {
            this.setTarget((EObject)target);
        } else if (target instanceof Resource) {
            this.setTarget((Resource)target);
        } else if (target instanceof ResourceSet) {
            this.setTarget((ResourceSet)target);
        }
    }

    protected void setTarget(Resource target) {
        EList contents = target.getContents();
        int i = 0;
        int size = contents.size();
        while (i < size) {
            Notifier notifier = (Notifier)contents.get(i);
            this.addAdapter(notifier);
            ++i;
        }
    }

    protected void setTarget(ResourceSet target) {
        EList resources = target.getResources();
        int i = 0;
        while (i < resources.size()) {
            Notifier notifier = (Notifier)resources.get(i);
            this.addAdapter(notifier);
            ++i;
        }
    }

    public void unsetTarget(Notifier target) {
        if (target instanceof EObject) {
            this.unsetTarget((EObject)target);
        } else if (target instanceof Resource) {
            this.unsetTarget((Resource)target);
        } else if (target instanceof ResourceSet) {
            this.unsetTarget((ResourceSet)target);
        }
    }

    protected void unsetTarget(EObject target) {
        Iterator i = ((InternalEList)target.eContents()).basicIterator();
        while (i.hasNext()) {
            InternalEObject internalEObject = (InternalEObject)i.next();
            Resource.Internal eDirectResource = internalEObject.eDirectResource();
            if (eDirectResource != null && eDirectResource.eAdapters().contains((Object)this)) continue;
            this.removeAdapter((Notifier)internalEObject);
        }
    }

    protected void unsetTarget(Resource target) {
        EList contents = target.getContents();
        int i = 0;
        int size = contents.size();
        while (i < size) {
            Notifier notifier = (Notifier)contents.get(i);
            this.removeAdapter(notifier);
            ++i;
        }
    }

    protected void removeAdapter(Notifier notifier) {
        notifier.eAdapters().remove((Object)this);
    }

    protected void unsetTarget(ResourceSet target) {
        EList resources = target.getResources();
        int i = 0;
        while (i < resources.size()) {
            Notifier notifier = (Notifier)resources.get(i);
            this.removeAdapter(notifier);
            ++i;
        }
    }
}

