/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.ui.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ThreadLocalExecutor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ThreadLocalExecutorUI
extends ThreadLocalExecutor
implements IPartListener {
    private @Nullable IWorkbenchPart activePart = null;
    protected final @NonNull Map<@NonNull IWorkbenchPart, @NonNull EnvironmentFactoryInternal> part2environmentFactory = new HashMap<IWorkbenchPart, EnvironmentFactoryInternal>();

    public static void initPart(@Nullable IWorkbenchPart initActivePart, @Nullable EnvironmentFactoryInternal initEnvironmentfactory) {
        assert (initActivePart != null || initEnvironmentfactory != null);
        ThreadLocalExecutor threadLocalExecutor = ThreadLocalExecutorUI.get();
        if (threadLocalExecutor instanceof ThreadLocalExecutorUI) {
            ((ThreadLocalExecutorUI)threadLocalExecutor).localInitPart(initActivePart, initEnvironmentfactory);
        }
    }

    public static void closeEditors() {
        ThreadLocalExecutor threadLocalExecutor = ThreadLocalExecutorUI.get();
        ((ThreadLocalExecutorUI)threadLocalExecutor).localCloseEditors();
    }

    protected @NonNull ThreadLocalExecutor createInstance() {
        IPartService partService;
        if (Display.getCurrent() == null) {
            return super.createInstance();
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (partService = activeWorkbenchWindow.getPartService()) != null) {
            partService.addPartListener((IPartListener)this);
        }
        return this;
    }

    protected @NonNull String getThreadName() {
        return "[" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)this.activePart) + "]";
    }

    private void localCloseEditors() {
        for (IWorkbenchPart part : new ArrayList<IWorkbenchPart>(this.part2environmentFactory.keySet())) {
            if (!(part instanceof IEditorPart)) continue;
            IEditorPart editorPart = (IEditorPart)part;
            editorPart.getSite().getPage().closeEditor(editorPart, false);
        }
    }

    protected void localInitPart(@Nullable IWorkbenchPart initActivePart, @Nullable EnvironmentFactoryInternal initEnvironmentfactory) {
        if (initEnvironmentfactory != ThreadLocalExecutorUI.basicGetEnvironmentFactory()) {
            this.setEnvironmentFactory(null);
        }
        if (initActivePart == null) {
            initActivePart = this.activePart;
            assert (initActivePart != null);
        }
        if (initEnvironmentfactory != null) {
            EnvironmentFactoryInternal oldEnvironmentFactory = this.part2environmentFactory.put(initActivePart, initEnvironmentfactory);
            assert (oldEnvironmentFactory == null);
            if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
                THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " Init [" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)initActivePart) + "] " + this.toString());
            }
        }
    }

    protected void localAttachEnvironmentFactory(@NonNull EnvironmentFactoryInternal newEnvironmentFactory) {
        super.localAttachEnvironmentFactory(newEnvironmentFactory);
        if (Display.getCurrent() != null) {
            ((Object)((Object)this)).getClass();
        }
    }

    protected void localDetachEnvironmentFactory(@NonNull EnvironmentFactory environmentFactory) {
        super.localDetachEnvironmentFactory(environmentFactory);
        if (Display.getCurrent() != null) {
            ((Object)((Object)this)).getClass();
        }
    }

    protected synchronized void localReset() {
        IWorkbenchPart activePart2 = this.activePart;
        if (activePart2 != null) {
            this.part2environmentFactory.remove(activePart2);
        }
        super.localReset();
    }

    public void partActivated(IWorkbenchPart newActivePart) {
        assert (newActivePart != null);
        EnvironmentFactoryInternal environmentFactory = this.part2environmentFactory.get(newActivePart);
        this.setEnvironmentFactory(environmentFactory);
        EnvironmentFactory partEnvironmentFactory = (EnvironmentFactory)newActivePart.getAdapter(EnvironmentFactory.class);
        if (partEnvironmentFactory == null && environmentFactory != null) {
            environmentFactory.detach((Object)this);
        }
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " partActivated [" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)newActivePart) + "] " + this.toString());
        }
        this.activePart = newActivePart;
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " partBroughtToTop [" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)part) + "] " + this.toString());
        }
    }

    public void partClosed(IWorkbenchPart oldOpenPart) {
        assert (oldOpenPart != null);
        assert (oldOpenPart != this.activePart);
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " partClosed [" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)oldOpenPart) + "] " + this.toString());
        }
        EnvironmentFactoryInternal oldEnvironmentFactory = this.part2environmentFactory.remove(oldOpenPart);
    }

    public void partDeactivated(IWorkbenchPart oldActivePart) {
        EnvironmentFactoryInternal environmentFactory;
        assert (oldActivePart != null);
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " partDeactivated [" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)oldActivePart) + "] " + this.toString());
        }
        if ((environmentFactory = this.localBasicGetEnvironmentFactory()) != null) {
            EnvironmentFactory partEnvironmentFactory = (EnvironmentFactory)oldActivePart.getAdapter(EnvironmentFactory.class);
            this.part2environmentFactory.put(oldActivePart, environmentFactory);
            if (partEnvironmentFactory == null) {
                environmentFactory.attach((Object)this);
            }
        } else {
            this.part2environmentFactory.remove(oldActivePart);
        }
        this.activePart = null;
        this.setEnvironmentFactory(null);
    }

    public void partOpened(IWorkbenchPart newOpenPart) {
        if (THREAD_LOCAL_ENVIRONMENT_FACTORY.isActive()) {
            THREAD_LOCAL_ENVIRONMENT_FACTORY.println(String.valueOf(this.getThreadName()) + " partOpened [" + Thread.currentThread().getName() + ":" + NameUtil.debugSimpleName((Object)newOpenPart) + "] " + this.toString());
        }
    }
}

