/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchDelegate;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.core.model.IWatchpoint;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DefaultLabelProvider
implements ILabelProvider {
    private Map<ImageDescriptor, Image> fImages = new HashMap<ImageDescriptor, Image>();

    public Image getImage(Object element) {
        String key = this.getImageKey(element);
        if (key == null && element instanceof ILaunch) {
            return null;
        }
        if (key == null && element instanceof IAdaptable) {
            ImageDescriptor descriptor;
            IWorkbenchAdapter de = (IWorkbenchAdapter)((IAdaptable)element).getAdapter(IWorkbenchAdapter.class);
            if (de != null && (descriptor = de.getImageDescriptor(element)) != null) {
                return this.getImage(descriptor);
            }
            return null;
        }
        if (element instanceof LaunchShortcutExtension) {
            return this.getImage(((LaunchShortcutExtension)element).getImageDescriptor());
        }
        return DebugPluginImages.getImage(key);
    }

    private Image getImage(ImageDescriptor descriptor) {
        Image image = this.fImages.get(descriptor);
        if (image != null) {
            return image;
        }
        image = descriptor.createImage();
        if (image != null) {
            this.fImages.put(descriptor, image);
        }
        return image;
    }

    public String getImageKey(Object element) {
        if (element instanceof IDebugElement) {
            if (element instanceof IRegister) {
                return "IMG_OBJS_REGISTER";
            }
            if (element instanceof IRegisterGroup) {
                return "IMG_OBJS_REGISTER_GROUP";
            }
            if (element instanceof IVariable || element instanceof IValue) {
                if (element instanceof IndexedVariablePartition) {
                    return "IMG_OBJS_ARRAY_PARTITION";
                }
                return "IMG_OBJS_VARIABLE";
            }
            if (element instanceof IStackFrame) {
                if (((IStackFrame)element).getThread().isSuspended()) {
                    return "IMG_OBJS_STACKFRAME";
                }
                return "IMG_OBJS_STACKFRAME_RUNNING";
            }
            if (element instanceof IThread) {
                IThread thread = (IThread)element;
                if (thread.isSuspended()) {
                    return "IMG_OBJS_THREAD_SUSPENDED";
                }
                if (thread.isTerminated()) {
                    return "IMG_OBJS_THREAD_TERMINATED";
                }
                return "IMG_OBJS_THREAD_RUNNING";
            }
            if (element instanceof IDebugTarget) {
                IDebugTarget target = (IDebugTarget)element;
                if (target.isTerminated() || target.isDisconnected()) {
                    return "IMG_OBJS_DEBUG_TARGET_TERMINATED";
                }
                if (target.isSuspended()) {
                    return "IMG_OBJS_DEBUG_TARGET_SUSPENDED";
                }
                return "IMG_OBJS_DEBUG_TARGET";
            }
            if (element instanceof IExpression) {
                return "IMG_OBJS_EXPRESSION";
            }
        } else {
            if (element instanceof IMarker) {
                return this.getMarkerImageKey((IMarker)element);
            }
            if (element instanceof IBreakpoint) {
                return this.getBreakpointImageKey((IBreakpoint)element);
            }
            if (element instanceof IProcess) {
                if (((IProcess)element).isTerminated()) {
                    return "IMG_OBJS_OS_PROCESS_TERMINATED";
                }
                return "IMG_OBJS_OS_PROCESS";
            }
            if (element instanceof ILaunch) {
                ILaunch launch = (ILaunch)element;
                ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                if (configuration != null) {
                    try {
                        return configuration.getType().getIdentifier();
                    }
                    catch (CoreException e) {
                        DebugUIPlugin.log(e);
                        return null;
                    }
                }
                if (launch.getLaunchMode().equals("debug")) {
                    return "IMG_OBJS_LAUNCH_DEBUG";
                }
                if (launch.isTerminated()) {
                    return "IMG_OBJS_LAUNCH_RUN_TERMINATED";
                }
                return "IMG_OBJS_LAUNCH_RUN";
            }
            if (element instanceof ILaunchConfigurationType) {
                return ((ILaunchConfigurationType)element).getIdentifier();
            }
            if (element instanceof ILaunchConfiguration) {
                try {
                    return ((ILaunchConfiguration)element).getType().getIdentifier();
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                    return null;
                }
            }
        }
        return null;
    }

    public String getText(Object element) {
        StringBuilder label = new StringBuilder();
        try {
            if (element instanceof IDebugElement) {
                if (element instanceof IStackFrame) {
                    label.append(((IStackFrame)element).getName());
                } else if (element instanceof IndexedVariablePartition) {
                    label.append(((IndexedVariablePartition)((Object)element)).getName());
                } else if (element instanceof IVariable) {
                    label.append(this.getVariableText((IVariable)element));
                } else if (element instanceof IThread) {
                    label.append(((IThread)element).getName());
                } else if (element instanceof IDebugTarget) {
                    label.append(((IDebugTarget)element).getName());
                } else if (element instanceof IExpression) {
                    label.append(this.getExpressionText((IExpression)element));
                } else if (element instanceof IRegisterGroup) {
                    label.append(this.getRegisterGroupText((IRegisterGroup)element));
                } else if (element instanceof IValue) {
                    label.append(((IValue)element).getValueString());
                }
            } else if (element instanceof IMarker) {
                label.append(this.getMarkerText((IMarker)element));
            } else if (element instanceof IBreakpoint) {
                label.append(this.getBreakpointText((IBreakpoint)element));
            } else if (element instanceof IProcess) {
                label.append(((IProcess)element).getLabel());
            } else if (element instanceof ILaunch) {
                label.append(this.getLaunchText((ILaunch)element));
            } else if (element instanceof ILaunchConfiguration) {
                label.append(((ILaunchConfiguration)element).getName());
            } else if (element instanceof ILaunchConfigurationType) {
                label.append(((ILaunchConfigurationType)element).getName());
            } else if (element instanceof ILaunchDelegate) {
                ILaunchDelegate delegate = (ILaunchDelegate)element;
                String name = delegate.getName();
                if (name == null) {
                    name = delegate.getContributorName();
                }
                label.append(name);
            } else if (element instanceof LaunchShortcutExtension) {
                label.append(((LaunchShortcutExtension)element).getLabel());
            } else if (element instanceof String) {
                label.append(element);
            } else {
                label.append(this.getAdapterLabel(element));
            }
            if (element instanceof ITerminate) {
                if (((ITerminate)element).isTerminated()) {
                    String terminatedMessage = null;
                    if (element instanceof IProcess) {
                        IProcess process = (IProcess)element;
                        int exit = process.getExitValue();
                        terminatedMessage = MessageFormat.format(DebugUIMessages.DefaultLabelProvider_16, Integer.toString(exit));
                    } else {
                        terminatedMessage = DebugUIMessages.DefaultLabelProvider_1;
                    }
                    label.insert(0, terminatedMessage);
                }
            } else if (element instanceof IDisconnect && ((IDisconnect)element).isDisconnected()) {
                label.insert(0, DebugUIMessages.DefaultLabelProvider__disconnected__1);
            }
        }
        catch (DebugException e) {
            DebugUIPlugin.log(e);
            label.append(DebugUIMessages.DefaultLabelProvider__unknown__1);
        }
        return label.toString();
    }

    private String getBreakpointText(IBreakpoint breakpoint) {
        IResource resource = breakpoint.getMarker().getResource();
        StringBuilder label = new StringBuilder();
        if (resource != null) {
            label.append(resource.getName());
        }
        if (breakpoint instanceof ILineBreakpoint) {
            try {
                int lineNumber = ((ILineBreakpoint)breakpoint).getLineNumber();
                label.append(MessageFormat.format(DebugUIMessages.DefaultLabelProvider_17, Integer.toString(lineNumber)));
            }
            catch (CoreException coreException) {}
        }
        return label.toString();
    }

    public String getAdapterLabel(Object object) {
        IWorkbenchAdapter de;
        if (object instanceof IAdaptable && (de = (IWorkbenchAdapter)((IAdaptable)object).getAdapter(IWorkbenchAdapter.class)) != null) {
            return de.getLabel(object);
        }
        return DebugUIMessages.DefaultLabelProvider__unknown__1;
    }

    protected String getLaunchText(ILaunch launch) {
        if (launch.getLaunchConfiguration() == null || !launch.getLaunchConfiguration().exists() && !launch.getLaunchConfiguration().isWorkingCopy()) {
            return DebugUIMessages.DefaultLabelProvider__unknown__1;
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        StringBuilder buff = new StringBuilder(config.getName());
        buff.append(" [");
        try {
            buff.append(config.getType().getName());
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        buff.append("]");
        return buff.toString();
    }

    protected String getExpressionText(IExpression expression) {
        if (expression instanceof IWatchExpression) {
            return this.getWatchExpressionText((IWatchExpression)expression);
        }
        StringBuilder buffer = new StringBuilder(expression.getExpressionText());
        String valueString = null;
        IValue value = expression.getValue();
        if (value != null) {
            try {
                valueString = value.getValueString();
            }
            catch (DebugException de) {
                DebugUIPlugin.log(de);
            }
        }
        if (valueString != null && valueString.length() > 0) {
            buffer.append("= ");
            buffer.append(valueString);
        }
        return buffer.toString();
    }

    protected String getWatchExpressionText(IWatchExpression expression) {
        StringBuilder result = new StringBuilder();
        String snippet = expression.getExpressionText().trim();
        StringBuilder snippetBuffer = new StringBuilder();
        if (snippet.length() > 30) {
            snippetBuffer.append(snippet.substring(0, 15));
            snippetBuffer.append(DebugUIMessages.DefaultLabelProvider_0);
            snippetBuffer.append(snippet.substring(snippet.length() - 15));
        } else {
            snippetBuffer.append(snippet);
        }
        snippet = snippetBuffer.toString().replace("[\n\r\t]+", " ");
        result.append('\"');
        result.append(snippet);
        result.append('\"');
        if (expression.isPending()) {
            result.append(DebugUIMessages.DefaultLabelProvider_12);
        } else if (expression.hasErrors()) {
            result.append(DebugUIMessages.DefaultLabelProvider_13);
        } else {
            String valueString;
            IValue value = expression.getValue();
            if (value != null && (valueString = DebugUIPlugin.getModelPresentation().getText(value)).length() > 0) {
                result.append(" = ").append(valueString);
            }
        }
        if (!expression.isEnabled()) {
            result.append(DebugUIMessages.DefaultLabelProvider_15);
        }
        return result.toString();
    }

    protected String getVariableText(IVariable variable) {
        StringBuilder buffer = new StringBuilder();
        try {
            IValue value = variable.getValue();
            buffer.append(variable.getName());
            buffer.append(" = ");
            buffer.append(value.getValueString());
        }
        catch (DebugException de) {
            DebugUIPlugin.log(de);
        }
        return buffer.toString();
    }

    protected String getRegisterGroupText(IRegisterGroup registerGroup) {
        StringBuilder buffer = new StringBuilder();
        try {
            buffer.append(registerGroup.getName());
        }
        catch (DebugException de) {
            DebugUIPlugin.log(de);
        }
        return buffer.toString();
    }

    protected String getMarkerText(IMarker marker) {
        try {
            if (marker.exists() && marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER)) {
                return DebugUIMessages.DefaultLabelProvider_Breakpoint_1;
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        return "";
    }

    protected String getMarkerImageKey(IMarker marker) {
        try {
            IBreakpoint breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
            if (breakpoint != null && marker.exists()) {
                if (breakpoint.isEnabled()) {
                    return "IMG_OBJS_BREAKPOINT";
                }
                return "IMG_OBJS_BREAKPOINT_DISABLED";
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    protected String getBreakpointImageKey(IBreakpoint breakpoint) {
        if (breakpoint != null && breakpoint.getMarker().exists()) {
            boolean enabled;
            block11: {
                IWatchpoint watchpoint;
                block12: {
                    block13: {
                        try {
                            enabled = breakpoint.isEnabled();
                            if (!(breakpoint instanceof IWatchpoint)) break block11;
                            watchpoint = (IWatchpoint)breakpoint;
                            if (!watchpoint.isAccess()) break block12;
                            if (!watchpoint.isModification()) break block13;
                            if (enabled) {
                                return "IMG_OBJS_WATCHPOINT";
                            }
                            return "IMG_OBJS_WATCHPOINT_DISABLED";
                        }
                        catch (CoreException coreException) {}
                    }
                    if (enabled) {
                        return "IMG_OBJS_ACCESS_WATCHPOINT";
                    }
                    return "IMG_OBJS_ACCESS_WATCHPOINT_DISABLED";
                }
                if (watchpoint.isModification()) {
                    if (enabled) {
                        return "IMG_OBJS_MODIFICATION_WATCHPOINT";
                    }
                    return "IMG_OBJS_MODIFICATION_WATCHPOINT_DISABLED";
                }
                return "IMG_OBJS_WATCHPOINT_DISABLED";
            }
            if (enabled) {
                return "IMG_OBJS_BREAKPOINT";
            }
            return "IMG_OBJS_BREAKPOINT_DISABLED";
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        for (Image image : this.fImages.values()) {
            image.dispose();
        }
        this.fImages.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public static String escapeSpecialChars(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder escaped = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            switch (c) {
                case '\b': {
                    escaped.append("\\b");
                    break;
                }
                case '\f': {
                    escaped.append("\\f");
                    break;
                }
                case '\n': {
                    escaped.append("\\n");
                    break;
                }
                case '\r': {
                    escaped.append("\\r");
                    break;
                }
                case '\t': {
                    escaped.append("\\t");
                    break;
                }
                case '\\': {
                    escaped.append("\\\\");
                    break;
                }
                default: {
                    escaped.append(c);
                }
            }
            ++i;
        }
        return escaped.toString();
    }

    public static String encodeEsacpedChars(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder encoded = new StringBuilder();
        if (string.length() == 1) {
            return string;
        }
        int i = 0;
        while (i < string.length()) {
            int c = string.charAt(i);
            if (c == 92 && i + 1 < string.length()) {
                switch (string.charAt(i + 1)) {
                    case 'b': {
                        c = 8;
                        ++i;
                        break;
                    }
                    case 'f': {
                        c = 12;
                        ++i;
                        break;
                    }
                    case 'n': {
                        c = 10;
                        ++i;
                        break;
                    }
                    case 'r': {
                        c = 13;
                        ++i;
                        break;
                    }
                    case 't': {
                        c = 9;
                        ++i;
                        break;
                    }
                    case '\'': {
                        c = 39;
                        ++i;
                        break;
                    }
                    case '\\': {
                        c = 92;
                        ++i;
                        break;
                    }
                }
            }
            encoded.append((char)c);
            ++i;
        }
        return encoded.toString();
    }
}

