/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.agent.connector;

import com.sun.jna.LastErrorException;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.User32;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.Texts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LibraryHolder {
    private static final Logger LOG = LoggerFactory.getLogger(LibraryHolder.class);
    private static LibraryHolder INSTANCE;
    private static boolean libraryLoaded;
    User32 user = User32.INSTANCE;
    Kernel32 kernel = Kernel32.INSTANCE;

    static {
        libraryLoaded = false;
    }

    public static synchronized LibraryHolder getLibrary() {
        if (!libraryLoaded) {
            libraryLoaded = true;
            try {
                INSTANCE = new LibraryHolder();
            }
            catch (Exception | NoClassDefFoundError | UnsatisfiedLinkError e) {
                LOG.error(Texts.get().logErrorLoadLibrary, e);
            }
        }
        return INSTANCE;
    }

    private LibraryHolder() {
    }

    String systemError(String pattern) {
        String msg;
        int lastError = this.kernel.GetLastError();
        try {
            msg = Kernel32Util.formatMessageFromLastErrorCode((int)lastError);
        }
        catch (Exception e) {
            String err = e instanceof LastErrorException ? Integer.toString(((LastErrorException)((Object)e)).getErrorCode()) : Texts.get().errUnknown;
            msg = MessageFormat.format(Texts.get().errLastError, Integer.toString(lastError), err);
            LOG.error(msg, (Throwable)e);
        }
        return MessageFormat.format(pattern, Integer.toString(lastError), msg);
    }
}

