/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.properties.internal.quickfix;

import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.properties.contexts.Annotatable;
import org.eclipse.papyrus.infra.properties.contexts.DataContextRoot;
import org.eclipse.papyrus.infra.properties.contexts.util.ContextAnnotations;
import org.eclipse.papyrus.infra.tools.util.Iterators2;
import org.eclipse.papyrus.infra.ui.util.EditorHelper;
import org.eclipse.papyrus.toolsmiths.validation.properties.internal.messages.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class FindNewPackageLocation {
    Command fix(EditingDomain domain, DataContextRoot dataContext, IMarker marker) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        URI originalURI = this.getOriginalURI((Annotatable)dataContext);
        if (originalURI != null) {
            URI newURI;
            IFile newFile = this.browseForNewFile(marker, dataContext, originalURI);
            URI uRI = newURI = newFile != null ? URI.createPlatformResourceURI((String)newFile.getFullPath().toString(), (boolean)true) : null;
            if (newURI != null) {
                result = this.createReplaceURIsCommand(domain, dataContext.eResource(), originalURI, newURI);
            }
        }
        return result;
    }

    private URI getOriginalURI(Annotatable element) {
        URI result = ContextAnnotations.getSourceModelURI((Annotatable)element);
        if (result != null) {
            result = result.trimFragment();
        }
        return result;
    }

    private Command createReplaceURIsCommand(EditingDomain domain, Resource resource, URI oldURI, URI newURI) {
        return (Command)Iterators2.stream((TreeIterator)Iterators2.filter((TreeIterator)EcoreUtil.getAllProperContents((Resource)resource, (boolean)false), Annotatable.class)).filter(annotatable -> this.tracesTo((Annotatable)annotatable, oldURI)).map(annotatable -> this.updateSourceURI(domain, (Annotatable)annotatable, newURI)).collect(Collectors.reducing(Command::chain)).orElse(UnexecutableCommand.INSTANCE);
    }

    private boolean tracesTo(Annotatable annotatable, URI resourceURI) {
        URI oldURI = ContextAnnotations.getSourceModelURI((Annotatable)annotatable);
        return oldURI != null && oldURI.trimFragment().equals(resourceURI);
    }

    private Command updateSourceURI(EditingDomain domain, Annotatable annotatable, URI newResourceURI) {
        return annotatable.getAnnotation("http://www.eclipse.org/papyrus/properties/contexts").getDetails().stream().filter(entry -> "model".equals(entry.getKey())).findAny().map(entry -> SetCommand.create((EditingDomain)domain, (Object)entry, (Object)EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY__VALUE, (Object)newResourceURI.appendFragment(URI.createURI((String)((String)entry.getValue())).fragment()).toString())).orElse((Command)IdentityCommand.INSTANCE);
    }

    private IFile browseForNewFile(IMarker marker, DataContextRoot dataContext, URI originalURI) {
        IFile result = null;
        final IWorkspace workspace = marker.getResource().getWorkspace();
        final String fileExtension = originalURI.fileExtension();
        Shell parentShell = EditorHelper.getActiveShell();
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(parentShell, false, (IContainer)workspace.getRoot(), 1, dataContext){
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
                this.setInitialPattern("**");
                this.setTitle(Messages.FindNewPackageLocation_0);
                String dataContextLabel = dataContextRoot.getLabel();
                if (dataContextLabel == null || dataContextLabel.isBlank()) {
                    dataContextLabel = dataContextRoot.getName();
                }
                this.setMessage(NLS.bind((String)Messages.FindNewPackageLocation_1, (Object)dataContextLabel));
            }

            protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
                final FilteredResourcesSelectionDialog.ResourceFilter delegate = (FilteredResourcesSelectionDialog.ResourceFilter)super.createFilter();
                return new FilteredResourcesSelectionDialog.ResourceFilter(this, (IContainer)workspace.getRoot(), delegate.isShowDerived(), 1){

                    public boolean isConsistentItem(Object item) {
                        return delegate.isConsistentItem(item);
                    }

                    public boolean matchItem(Object item) {
                        return delegate.matchItem(item) && this.hasCorrectExtension(item);
                    }

                    public int getMatchRule() {
                        return delegate.getMatchRule();
                    }

                    public boolean isCamelCasePattern() {
                        return delegate.isCamelCasePattern();
                    }

                    public String getPattern() {
                        return delegate.getPattern();
                    }

                    public boolean matchesRawNamePattern(Object item) {
                        return delegate.matchesRawNamePattern(item);
                    }

                    public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
                        return delegate.isSubFilter(filter);
                    }

                    public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
                        return delegate.equalsFilter(filter);
                    }

                    boolean hasCorrectExtension(Object item) {
                        return item instanceof IFile && fileExtension.equals(((IFile)item).getFullPath().getFileExtension());
                    }
                };
            }
        };
        if (dialog.open() == 0) {
            result = (IFile)dialog.getFirstResult();
        }
        return result;
    }
}

