/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.sequence.services;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.CommonDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.ViewpointHelpers;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.SequenceDiagramOrderServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.utils.SequenceDiagramUMLHelper;
import org.eclipse.papyrus.uml.domain.services.UMLHelper;
import org.eclipse.sirius.diagram.sequence.description.ObservationPointMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLPackage;

public final class SequenceDiagramObservationServices {
    private static final UMLPackage UML = UMLPackage.eINSTANCE;
    private static final SequenceDiagramUMLHelper UML_HELPER = new SequenceDiagramUMLHelper();
    private static final SequenceDiagramOrderServices ORDER_SERVICES = new SequenceDiagramOrderServices();
    private static final CommonDiagramServices COMMONS = new CommonDiagramServices();

    private SequenceDiagramObservationServices() {
    }

    public static boolean canCreateTimeElement(DSemanticDecorator view) {
        boolean end = view.getTarget() instanceof EAnnotation;
        return end && ViewpointHelpers.isMapping(view, ObservationPointMapping.class, "SD_ImplicitTimeElement");
    }

    public static TimeObservation createTimeObservation(EAnnotation end, DSemanticDecorator parentView) {
        return SequenceDiagramObservationServices.createTimeElement(end, event -> {
            Namespace container = UMLHelper.getPackagedContainer((Element)event);
            TimeObservation result = (TimeObservation)COMMONS.createElement((Element)container, UML.getTimeObservation().getName(), "packagedElement", parentView);
            result.setEvent(event);
            return result;
        });
    }

    public static TimeConstraint createTimeConstraint(EAnnotation end, DSemanticDecorator parentView) {
        return SequenceDiagramObservationServices.createTimeElement(end, event -> {
            Interaction interaction = UML_HELPER.getOwningInteraction((Element)event);
            TimeConstraint result = (TimeConstraint)COMMONS.createElement((Element)interaction, UML.getTimeConstraint().getName(), UML.getNamespace_OwnedRule().getName(), parentView);
            result.getConstrainedElements().add(event);
            return result;
        });
    }

    private static <T extends PackageableElement> T createTimeElement(EAnnotation end, Function<NamedElement, T> factory) {
        NamedElement event = ORDER_SERVICES.getEndFragment(end);
        List<PackageableElement> existingElements = SequenceDiagramUMLHelper.getTimeElementsFromEvent(event);
        if (!existingElements.isEmpty()) {
            return null;
        }
        return (T)((PackageableElement)factory.apply(event));
    }

    public static PackageableElement getAssociatedTimeElement(EAnnotation end) {
        return SequenceDiagramUMLHelper.getTimeElementFromEnd(end).orElse(null);
    }

    public static EAnnotation getDurationElementSource(PackageableElement element) {
        return SequenceDiagramObservationServices.getEndFromEventPair(SequenceDiagramObservationServices.getDurationEnds(element), true);
    }

    public static EAnnotation getDurationElementTarget(PackageableElement element) {
        return SequenceDiagramObservationServices.getEndFromEventPair(SequenceDiagramObservationServices.getDurationEnds(element), false);
    }

    private static List<? extends NamedElement> getDurationEnds(PackageableElement element) {
        Object result = Collections.emptyList();
        if (element instanceof DurationConstraint) {
            DurationConstraint constraint = (DurationConstraint)element;
            result = constraint.getConstrainedElements().stream().filter(OccurrenceSpecification.class::isInstance).map(OccurrenceSpecification.class::cast).toList();
        } else if (element instanceof DurationObservation) {
            DurationObservation observation = (DurationObservation)element;
            result = observation.getEvents();
        }
        return result;
    }

    private static EAnnotation getEndFromEventPair(List<? extends NamedElement> values, boolean first) {
        if (values.size() < 2) {
            return null;
        }
        int index = 0;
        if (!first) {
            index = 1;
        }
        EAnnotation result = null;
        NamedElement namedElement = values.get(index);
        if (namedElement instanceof OccurrenceSpecification) {
            OccurrenceSpecification occurence = (OccurrenceSpecification)namedElement;
            result = ORDER_SERVICES.findOccurrenceEnd(occurence);
        }
        return result;
    }

    public static boolean canCreateDurationElement(EObject source, EObject target) {
        boolean result = true;
        if (source == target) {
            result = SequenceDiagramObservationServices.hasDuration(source);
        } else if (source instanceof Message) {
            Message message = (Message)source;
            result = SequenceDiagramObservationServices.containsDuration(message, target);
        } else if (target instanceof Message) {
            Message message = (Message)target;
            result = SequenceDiagramObservationServices.containsDuration(message, source);
        }
        return result && SequenceDiagramObservationServices.areFragmentSiblings(SequenceDiagramObservationServices.adaptToOccurrence(source), SequenceDiagramObservationServices.adaptToOccurrence(target));
    }

    private static OccurrenceSpecification adaptToOccurrence(EObject element) {
        EAnnotation end;
        NamedElement namedElement;
        OccurrenceSpecification result = null;
        if (element instanceof OccurrenceSpecification) {
            OccurrenceSpecification value;
            result = value = (OccurrenceSpecification)element;
        } else if (element instanceof ExecutionSpecification) {
            ExecutionSpecification exec = (ExecutionSpecification)element;
            result = exec.getStart();
        } else if (element instanceof Message) {
            Message message = (Message)element;
            result = (OccurrenceSpecification)message.getSendEvent();
        } else if (element instanceof EAnnotation && (namedElement = ORDER_SERVICES.getEndFragment(end = (EAnnotation)element)) instanceof OccurrenceSpecification) {
            OccurrenceSpecification value;
            result = value = (OccurrenceSpecification)namedElement;
        }
        return result;
    }

    private static boolean areFragmentSiblings(OccurrenceSpecification source, OccurrenceSpecification target) {
        return source != null && target != null && source.getEnclosingOperand() == target.getEnclosingOperand();
    }

    private static boolean containsDuration(Message message, EObject other) {
        EAnnotation pseudoEnd;
        NamedElement namedElement;
        if (other instanceof EAnnotation && (namedElement = ORDER_SERVICES.getEndFragment(pseudoEnd = (EAnnotation)other)) instanceof MessageEnd) {
            MessageEnd end = (MessageEnd)namedElement;
            return message != end.getMessage() || SequenceDiagramObservationServices.hasDuration((EObject)message);
        }
        return true;
    }

    private static boolean hasDuration(EObject element) {
        Message message;
        return element instanceof ExecutionSpecification || element instanceof Message && (message = (Message)element).getSendEvent() instanceof MessageOccurrenceSpecification && message.getReceiveEvent() instanceof MessageOccurrenceSpecification;
    }

    public static DurationConstraint createDurationConstraint(EObject source, EObject target, DSemanticDecorator parentView) {
        return SequenceDiagramObservationServices.createDuration(source, target, context -> {
            Interaction interaction = UML_HELPER.getOwningInteraction((Element)context);
            return (DurationConstraint)COMMONS.createElement((Element)interaction, UML.getDurationConstraint().getName(), UML.getNamespace_OwnedRule().getName(), parentView);
        });
    }

    public static DurationObservation createDurationObservation(EObject source, EObject target, DSemanticDecorator view) {
        return SequenceDiagramObservationServices.createDuration(source, target, context -> {
            Namespace container = UMLHelper.getPackagedContainer((Element)context);
            return (DurationObservation)COMMONS.createElement((Element)container, UML.getDurationObservation().getName(), "packagedElement", view);
        });
    }

    private static <T extends PackageableElement> T createDuration(EObject source, EObject target, Function<Element, T> factory) {
        DurationEventCandidate sourceSet = SequenceDiagramObservationServices.createDurationEventCandidate(source);
        DurationEventCandidate targetSet = SequenceDiagramObservationServices.createDurationEventCandidate(target);
        if (!sourceSet.isValid() || !targetSet.isValid()) {
            return null;
        }
        PackageableElement result = (PackageableElement)factory.apply((Element)sourceSet.getContext());
        if (!sourceSet.applySingleEvent(result, targetSet) && !sourceSet.applySharedEvent(result, targetSet)) {
            sourceSet.addInEvents(result);
            targetSet.addInEvents(result);
        }
        return (T)result;
    }

    private static DurationEventCandidate createDurationEventCandidate(EObject element) {
        EAnnotation end;
        NamedElement namedElement;
        DurationEventCandidate result = null;
        if (element instanceof Message) {
            Message message = (Message)element;
            result = new DurationEventCandidate(null, message, null);
        } else if (element instanceof ExecutionSpecification) {
            ExecutionSpecification execution = (ExecutionSpecification)element;
            result = new DurationEventCandidate(null, null, execution);
        } else if (element instanceof EAnnotation && (namedElement = ORDER_SERVICES.getEndFragment(end = (EAnnotation)element)) instanceof OccurrenceSpecification) {
            OccurrenceSpecification occurrence = (OccurrenceSpecification)namedElement;
            Message message = null;
            if (occurrence instanceof MessageOccurrenceSpecification) {
                MessageOccurrenceSpecification mos = (MessageOccurrenceSpecification)occurrence;
                message = mos.getMessage();
            }
            result = new DurationEventCandidate(occurrence, message, SequenceDiagramUMLHelper.getAssociatedExecution(occurrence));
        }
        return result;
    }

    private static boolean applySharedMessageEvent(PackageableElement value, Message message, ExecutionSpecification execution) {
        if (message == null || execution == null) {
            return false;
        }
        boolean result = false;
        if (message.getReceiveEvent() == execution.getStart()) {
            SequenceDiagramObservationServices.addEventEnd(value, (NamedElement)message, true);
            SequenceDiagramObservationServices.addEventEnd(value, (NamedElement)execution, false);
            result = true;
        } else if (message.getSendEvent() == execution.getFinish()) {
            SequenceDiagramObservationServices.addEventEnd(value, (NamedElement)execution, true);
            SequenceDiagramObservationServices.addEventEnd(value, (NamedElement)message, false);
            result = true;
        }
        return result;
    }

    private static void addEventEnd(PackageableElement parent, NamedElement event, boolean firstEvent) {
        OccurrenceSpecification end = firstEvent ? (OccurrenceSpecification)UML_HELPER.getSemanticStart((Element)event) : (OccurrenceSpecification)UML_HELPER.getSemanticFinish((Element)event);
        SequenceDiagramObservationServices.addEvent(parent, (NamedElement)end);
    }

    private static void addEvent(PackageableElement parent, NamedElement event) {
        if (parent instanceof DurationConstraint) {
            DurationConstraint constraint = (DurationConstraint)parent;
            constraint.getConstrainedElements().add((Object)event);
        } else if (parent instanceof DurationObservation) {
            DurationObservation observation = (DurationObservation)parent;
            observation.getEvents().add((Object)event);
        }
    }

    public static void replaceFragmentReferences(OccurrenceSpecification previous, OccurrenceSpecification next) {
        List<PackageableElement> temporals = SequenceDiagramUMLHelper.getTemporalElementsFromEvent((NamedElement)previous);
        temporals.forEach(element -> {
            if (element instanceof TimeObservation) {
                TimeObservation timeObs = (TimeObservation)element;
                timeObs.setEvent((NamedElement)next);
            } else {
                EList refs;
                if (element instanceof DurationObservation) {
                    DurationObservation durationObs = (DurationObservation)element;
                    refs = durationObs.getEvents();
                } else {
                    refs = ((Constraint)element).getConstrainedElements();
                }
                refs.set(refs.indexOf(previous), next);
            }
        });
        List.copyOf(previous.getToBefores()).forEach(ordering -> ordering.setAfter(next));
        List.copyOf(previous.getToAfters()).forEach(ordering -> ordering.setBefore(next));
    }

    private record DurationEventCandidate(OccurrenceSpecification event, Message message, ExecutionSpecification execution) {
        boolean isValid() {
            return this.message != null || this.execution != null;
        }

        NamedElement getContext() {
            if (this.message != null) {
                return this.message;
            }
            return this.execution;
        }

        void addInEvents(PackageableElement result) {
            Message element = this.message;
            if (this.execution != null) {
                element = this.execution;
            }
            boolean first = this.event == null || UML_HELPER.getSemanticStart((Element)element) == this.event;
            SequenceDiagramObservationServices.addEventEnd(result, (NamedElement)element, first);
        }

        boolean applySingleEvent(PackageableElement parent, DurationEventCandidate other) {
            Message value = null;
            if (this.message != null && this.message == other.message) {
                value = this.message;
            } else if (this.execution != null && this.execution == other.execution) {
                value = this.execution;
            }
            if (value == null) {
                return false;
            }
            SequenceDiagramObservationServices.addEvent(parent, (NamedElement)value);
            return true;
        }

        boolean applySharedEvent(PackageableElement value, DurationEventCandidate other) {
            return SequenceDiagramObservationServices.applySharedMessageEvent(value, this.message, other.execution) || SequenceDiagramObservationServices.applySharedMessageEvent(value, other.message, this.execution);
        }
    }
}

