/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.checkers;

import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.papyrus.infra.tools.util.ClasspathHelper;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class JavaClassDependencies {
    private final String hostBundle;
    private final BiFunction<? super EObject, ? super EAttribute, ?> classExtractor;

    public JavaClassDependencies(IProject project) {
        this(project, null);
    }

    public JavaClassDependencies(IProject project, BiFunction<? super EObject, ? super EAttribute, ?> classExtractor) {
        this.hostBundle = Optional.ofNullable(PluginRegistry.findModel((IProject)project)).map(IPluginModelBase::getBundleDescription).map(BundleDescription::getSymbolicName).orElse(project.getName());
        this.classExtractor = classExtractor != null ? classExtractor : this::getClass;
    }

    public URI getClassURI(EObject owner, EAttribute attribute, String className) {
        Optional<Object> bundleName;
        Object commandClass = this.classExtractor.apply((EObject)owner, (EAttribute)attribute);
        if (commandClass instanceof Class) {
            Bundle bundle = FrameworkUtil.getBundle((Class)((Class)commandClass));
            bundleName = Optional.ofNullable(bundle).map(Bundle::getSymbolicName);
        } else if (commandClass instanceof IType) {
            Optional<IPluginModelBase> plugin = Optional.empty();
            IType commandType = (IType)commandClass;
            if (commandType.isBinary()) {
                IPackageFragmentRoot jar = (IPackageFragmentRoot)commandType.getAncestor(3);
                if (jar != null) {
                    IPath jarPath = jar.getPath();
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(jarPath);
                    if (file != null && file.isAccessible()) {
                        plugin = Optional.ofNullable(PluginRegistry.findModel((IProject)file.getProject()));
                    } else {
                        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getExternalModels();
                        int n = iPluginModelBaseArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPluginModelBase next = iPluginModelBaseArray[n2];
                            Path path = new Path(next.getInstallLocation());
                            if (jarPath.equals((Object)path) || path.isPrefixOf(jarPath)) {
                                plugin = Optional.of(next);
                                break;
                            }
                            ++n2;
                        }
                    }
                }
            } else {
                plugin = Optional.of(((IType)commandClass).getJavaProject()).map(IJavaProject::getProject).map(PluginRegistry::findModel);
            }
            bundleName = plugin.map(IPluginModelBase::getBundleDescription).map(BundleDescription::getSymbolicName);
        } else {
            bundleName = Optional.empty();
        }
        return URI.createURI((String)String.format("bundleclass://%s/%s", bundleName.orElse(this.hostBundle), className));
    }

    private Object getClass(EObject owner, EAttribute attribute) {
        Object result = null;
        EDataType dataType = attribute.getEAttributeType();
        if (dataType.getInstanceClass() == Class.class || dataType.getInstanceClass() == URI.class) {
            result = owner.eGet((EStructuralFeature)attribute);
        } else if (dataType.getInstanceClass() == String.class) {
            String className = (String)owner.eGet((EStructuralFeature)attribute);
            URI context = EcoreUtil.getURI((EObject)owner);
            if (context != null) {
                context = context.trimFragment();
            }
            result = ClasspathHelper.INSTANCE.findClass(className, context, null);
        }
        return result;
    }
}

