/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.uml.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.sirius.properties.Category;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.viewpoint.description.Group;

public final class MultipleSelectionViewpointExplorer {
    private static final String MEMBER_END_UML_GROUP_NAME = "memberEnd_uml_group";
    private static final String METACLASS_UML_GROUP_NAME = "metaclass_uml_group";
    private static final String UML_DOMAIN_CLASS_PREFIX = "uml::";
    private static final String UML_GROUP_SUFFIX = "_uml_group";
    private static final String UML_PROPERTIES_ODESIGN_PATH = "/org.eclipse.papyrus.sirius.properties.uml/description/umlProperties.odesign";
    private static MultipleSelectionViewpointExplorer instance;
    private Group vsmContent;

    private MultipleSelectionViewpointExplorer() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, null);
        ResourceSet resourceSet = editingDomain.getResourceSet();
        URI uri = URI.createPlatformPluginURI((String)UML_PROPERTIES_ODESIGN_PATH, (boolean)true);
        Resource resource = resourceSet.getResource(uri, true);
        this.vsmContent = (Group)resource.getContents().get(0);
    }

    public static MultipleSelectionViewpointExplorer getInstance() {
        if (instance == null) {
            instance = new MultipleSelectionViewpointExplorer();
        }
        return instance;
    }

    public List<EStructuralFeature> keepDisplayableFeatures(Set<EClass> classifiers, List<EStructuralFeature> commonFeatures) {
        List<Object> featuresToKeep = new ArrayList<EStructuralFeature>();
        if (commonFeatures != null) {
            Set featureNames = commonFeatures.stream().map(feature -> feature.getName()).collect(Collectors.toSet());
            if (classifiers != null) {
                List<GroupDescription> groupsMatchingClassifiers = this.getGroupsMatchingClassifiers(classifiers);
                if (!groupsMatchingClassifiers.isEmpty()) {
                    for (GroupDescription group : groupsMatchingClassifiers) {
                        Set displayableFeatures = group.getControls().stream().map(control -> control.getName()).filter(name -> featureNames.contains(name)).collect(Collectors.toSet());
                        featureNames.retainAll(displayableFeatures);
                    }
                } else {
                    featureNames.clear();
                }
            }
            if (!featureNames.isEmpty()) {
                featuresToKeep = commonFeatures.stream().filter(feature -> featureNames.contains(feature.getName())).collect(Collectors.toList());
            }
        }
        return featuresToKeep;
    }

    private List<GroupDescription> getGroupsMatchingClassifiers(Set<EClass> classifiers) {
        ViewExtensionDescription siriusRulesProperties = (ViewExtensionDescription)this.vsmContent.getExtensions().get(0);
        Category defaultCategory = (Category)siriusRulesProperties.getCategories().get(0);
        EList allGroups = defaultCategory.getGroups();
        Set typeNames = classifiers.stream().map(eClass -> eClass.getName()).collect(Collectors.toSet());
        List<GroupDescription> matchingGroups = allGroups.stream().filter(group -> this.matchGroup(typeNames, (GroupDescription)group)).filter(group -> !this.isAnException((GroupDescription)group)).collect(Collectors.toList());
        return matchingGroups;
    }

    private boolean isAnException(GroupDescription group) {
        return METACLASS_UML_GROUP_NAME.equals(group.getName()) || MEMBER_END_UML_GROUP_NAME.equals(group.getName());
    }

    private boolean matchGroup(Set<String> typeNames, GroupDescription group) {
        String domainClass = group.getDomainClass().substring(UML_DOMAIN_CLASS_PREFIX.length());
        return typeNames.contains(domainClass) && group.getName().endsWith(UML_GROUP_SUFFIX);
    }
}

