/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Collaboration;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.DeploymentSpecification;
import org.eclipse.uml2.uml.Device;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.ExecutionEnvironment;
import org.eclipse.uml2.uml.Extend;
import org.eclipse.uml2.uml.FunctionBehavior;
import org.eclipse.uml2.uml.Include;
import org.eclipse.uml2.uml.InformationFlow;
import org.eclipse.uml2.uml.InformationItem;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Manifestation;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProtocolStateMachine;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class KeywordLabelProvider
implements Function<EObject, String> {
    @Override
    public String apply(EObject t) {
        List keywords;
        if (t != null && (keywords = (List)new KeywordProviderSwitch().doSwitch(t)) != null) {
            return keywords.stream().collect(Collectors.joining(", ", "\u00ab", "\u00bb"));
        }
        return null;
    }

    static class KeywordProviderSwitch
    extends UMLSwitch<List<String>> {
        KeywordProviderSwitch() {
        }

        public List<String> caseAbstraction(Abstraction object) {
            if (!(object instanceof Realization)) {
                return List.of("abstraction");
            }
            return (List)super.caseAbstraction(object);
        }

        public List<String> caseActivity(Activity activity) {
            ArrayList<String> keywords = new ArrayList<String>();
            keywords.add("activity");
            if (activity.isSingleExecution()) {
                keywords.add("singleExecution");
            }
            return keywords;
        }

        public List<String> caseArtifact(Artifact artifact) {
            return List.of("artifact");
        }

        public List<String> caseCollaboration(Collaboration object) {
            return List.of("collaboration");
        }

        public List<String> caseComponent(Component object) {
            return List.of("component");
        }

        public List<String> caseDataType(DataType dataType) {
            return List.of("dataType");
        }

        public List<String> caseDeployment(Deployment deployment) {
            return List.of("deploy");
        }

        public List<String> caseDeploymentSpecification(DeploymentSpecification deploymentSpecification) {
            return List.of("deployment spec");
        }

        public List<String> caseDevice(Device object) {
            return List.of("device");
        }

        public List<String> caseEnumeration(Enumeration enumeration) {
            return List.of("enumeration");
        }

        public List<String> caseExecutionEnvironment(ExecutionEnvironment executionEnvironment) {
            return List.of("executionEnvironment");
        }

        public List<String> caseExtend(Extend extend) {
            return List.of("extend");
        }

        public List<String> caseFunctionBehavior(FunctionBehavior functionBehavior) {
            return List.of("functionBehavior");
        }

        public List<String> caseInclude(Include object) {
            return List.of("include");
        }

        public List<String> caseInformationFlow(InformationFlow flow) {
            return List.of("flow");
        }

        public List<String> caseInformationItem(InformationItem object) {
            return List.of("information");
        }

        public List<String> caseInteraction(Interaction interaction) {
            return List.of("interaction");
        }

        public List<String> caseInterface(Interface object) {
            return List.of("interface");
        }

        public List<String> caseManifestation(Manifestation object) {
            return List.of("manifest");
        }

        public List<String> caseOpaqueBehavior(OpaqueBehavior opaqueBehavior) {
            return List.of("opaqueBehavior");
        }

        public List<String> casePackageImport(PackageImport object) {
            if (object.getVisibility() == VisibilityKind.PUBLIC_LITERAL) {
                return List.of("import");
            }
            return List.of("access");
        }

        public List<String> casePackageMerge(PackageMerge object) {
            return List.of("merge");
        }

        public List<String> casePrimitiveType(PrimitiveType object) {
            return List.of("primitive");
        }

        public List<String> caseProfile(Profile object) {
            return List.of("profile");
        }

        public List<String> caseProtocolStateMachine(ProtocolStateMachine protocolStateMachine) {
            return List.of("protocol");
        }

        public List<String> caseReception(Reception object) {
            return List.of("signal");
        }

        public List<String> caseSignal(Signal signal) {
            return List.of("signal");
        }

        public List<String> caseStateMachine(StateMachine stateMachine) {
            return List.of("stateMachine");
        }

        public List<String> caseStereotype(Stereotype stereotype) {
            return List.of("stereotype");
        }

        public List<String> caseSubstitution(Substitution object) {
            return List.of("substitute");
        }

        public List<String> caseUsage(Usage object) {
            return List.of("use");
        }
    }
}

