/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.drop.IExternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class CommunicationExternalSourceToRepresentationDropChecker
implements IExternalSourceToRepresentationDropChecker {
    @Override
    public CheckStatus canDragAndDrop(EObject elementToDrop, EObject newSemanticContainer) {
        return (CheckStatus)new CommunicationDropInsideRepresentationCheckerSwitch(newSemanticContainer).doSwitch(elementToDrop);
    }

    static class CommunicationDropInsideRepresentationCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private final EObject newSemanticContainer;

        CommunicationDropInsideRepresentationCheckerSwitch(EObject target) {
            this.newSemanticContainer = target;
        }

        public CheckStatus caseComment(Comment comment) {
            CheckStatus result = !(this.newSemanticContainer instanceof Interaction) ? CheckStatus.no("Comment can only be drag and drop on an Interaction.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseConstraint(Constraint constraint) {
            CheckStatus result = !(this.newSemanticContainer instanceof Interaction) ? CheckStatus.no("Constraint can only be drag and drop on an Interaction.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseDurationObservation(DurationObservation durationObservation) {
            CheckStatus result = !(this.newSemanticContainer instanceof Interaction) ? CheckStatus.no("DurationObservation can only be drag and drop on an Interaction.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseLifeline(Lifeline lifeline) {
            CheckStatus result = !(this.newSemanticContainer instanceof Interaction) ? CheckStatus.no("Lifeline can only be drag and drop on an Interaction.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseProperty(Property property) {
            CheckStatus result = !(this.newSemanticContainer instanceof Lifeline) ? CheckStatus.no("Property can only be drag and drop on an Lifeline.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseTimeObservation(TimeObservation timeObservation) {
            CheckStatus result = !(this.newSemanticContainer instanceof Interaction) ? CheckStatus.no("TimeObservation can only be drag and drop on an Interaction.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseType(Type type) {
            CheckStatus result = !(this.newSemanticContainer instanceof Interaction) && !(this.newSemanticContainer instanceof Lifeline) ? CheckStatus.no("Type can only be drag and drop on an Interaction or a Lifeline.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus defaultCase(EObject object) {
            return CheckStatus.no("DnD is not authorized.");
        }
    }
}

