/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.architecture.merger;

import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.util.Set;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDomain;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.ArchitectureExtensions;
import org.eclipse.papyrus.infra.core.internal.architecture.merger.MergePhase;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;

@Singleton
final class MergeState {
    private MergePhase phase = MergePhase.NOT_STARTED;
    private final Set<ArchitectureDomain> domains = CollectionLiterals.newLinkedHashSet();

    MergeState() {
    }

    public MergePhase phase() {
        return this.phase;
    }

    void advancePhase() {
        MergePhase _switchResult;
        block7: {
            block6: {
                _switchResult = null;
                MergePhase phase = this.phase;
                if (phase == null) break block6;
                switch (phase) {
                    case NOT_STARTED: {
                        _switchResult = MergePhase.INHERITANCE;
                        break block7;
                    }
                    case INHERITANCE: {
                        _switchResult = MergePhase.LEGACY;
                        break block7;
                    }
                    case LEGACY: {
                        _switchResult = MergePhase.EXTENSIONS;
                        break block7;
                    }
                    case EXTENSIONS: {
                        _switchResult = MergePhase.DONE;
                        break block7;
                    }
                    default: {
                        throw new IllegalStateException("Merge is done.");
                    }
                }
            }
            throw new IllegalStateException("Merge is done.");
        }
        this.phase = _switchResult;
        ArchitectureExtensions.logf("=== Merge phase: %s ===", new Object[]{this.phase});
    }

    public Set<? extends ArchitectureDomain> currentDomains() {
        return this.domains;
    }

    public <T> T withDomains(Iterable<? extends ArchitectureDomain> domains, Functions.Function0<T> block) {
        Object _xblockexpression = null;
        Set<ArchitectureDomain> oldDomains = Set.copyOf(this.domains);
        Object _xtrycatchfinallyexpression = null;
        try {
            Object _xblockexpression_1 = null;
            this.setDomains(domains);
            ArchitectureExtensions.logf("Merging elements in scope of %s.", domains);
            _xtrycatchfinallyexpression = _xblockexpression_1 = block.apply();
        }
        finally {
            this.setDomains(oldDomains);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return (T)_xblockexpression;
    }

    private boolean setDomains(Iterable<? extends ArchitectureDomain> domains) {
        boolean _xblockexpression = false;
        this.domains.clear();
        _xblockexpression = Iterables.addAll(this.domains, domains);
        return _xblockexpression;
    }
}

