/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef.fx.anchors.DynamicAnchor;
import org.eclipse.gef.fx.anchors.IAnchor;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.fx.nodes.IConnectionRouter;
import org.eclipse.gef.fx.nodes.OrthogonalRouter;
import org.eclipse.gef.fx.utils.NodeUtils;
import org.eclipse.gef.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef.geometry.euclidean.Vector;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.mvc.fx.operations.AbstractCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.BendContentOperation;
import org.eclipse.gef.mvc.fx.operations.BendVisualOperation;
import org.eclipse.gef.mvc.fx.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IBendableContentPart;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.parts.PartUtils;
import org.eclipse.gef.mvc.fx.policies.AbstractPolicy;
import org.eclipse.gef.mvc.fx.providers.IAnchorProvider;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class BendConnectionPolicy
extends AbstractPolicy {
    protected static final double DEFAULT_OVERLAY_THRESHOLD = 10.0;
    protected static final double DEFAULT_SEGMENT_OVERLAY_THRESHOLD = 6.0;
    private List<IBendableContentPart.BendPoint> initialBendPoints = new ArrayList<IBendableContentPart.BendPoint>();
    private boolean isNormalizationNeeded = false;
    private Point preMoveStartHint = null;
    private Point preMoveEndHint = null;
    private List<IBendableContentPart.BendPoint> preMoveBendPoints = new ArrayList<IBendableContentPart.BendPoint>();
    private List<Integer> selectedIndices = new ArrayList<Integer>();
    private List<Point> selectedIndicesInitialPositions = new ArrayList<Point>();

    protected boolean canConnect(int explicitAnchorIndex) {
        return explicitAnchorIndex == 0 || explicitAnchorIndex == this.getBendOperation().getFinalBendPoints().size() - 1;
    }

    @Override
    public ITransactionalOperation commit() {
        ITransactionalOperation commitOperation;
        if (this.isNormalizationNeeded) {
            this.normalize();
        }
        if ((commitOperation = super.commit()) != null && !commitOperation.isNoOp() && this.getHost() instanceof IBendableContentPart) {
            ForwardUndoCompositeOperation composite = new ForwardUndoCompositeOperation("Bend Content");
            composite.add(commitOperation);
            BendContentOperation resizeOperation = new BendContentOperation((IBendableContentPart<? extends Node>)this.getHost(), this.getInitialBendPoints(), this.getCurrentBendPoints());
            composite.add(resizeOperation);
            commitOperation = composite;
        }
        this.initialBendPoints = null;
        return commitOperation;
    }

    private Point computeEndHint() {
        if (this.getConnection().getEndAnchor() instanceof DynamicAnchor && this.getConnection().getPointsUnmodifiable().size() > 1) {
            Point endPoint = this.getConnection().getEndPoint();
            Point neighbor = this.getConnection().getPoint(this.getConnection().getPointsUnmodifiable().size() - 2);
            Point translated = endPoint.getTranslated(endPoint.getDifference(neighbor).getScaled(0.5));
            return translated;
        }
        return null;
    }

    private Point computeStartHint() {
        if (this.getConnection().getStartAnchor() instanceof DynamicAnchor && this.getConnection().getPointsUnmodifiable().size() > 1) {
            Point startPoint = this.getConnection().getStartPoint();
            Point neighbor = this.getConnection().getPoint(1);
            Point translated = startPoint.getTranslated(startPoint.getDifference(neighbor).getScaled(0.5));
            return translated;
        }
        return null;
    }

    public int createAfter(int explicitAnchorIndex, Point mouseInScene) {
        this.checkInitialized();
        this.isNormalizationNeeded = true;
        int insertionIndex = explicitAnchorIndex + 1;
        this.insertExplicitAnchor(insertionIndex, mouseInScene);
        return insertionIndex;
    }

    public int createBefore(int explicitAnchorIndex, Point mouseInScene) {
        this.checkInitialized();
        this.isNormalizationNeeded = true;
        int insertionIndex = explicitAnchorIndex;
        this.insertExplicitAnchor(insertionIndex, mouseInScene);
        return insertionIndex;
    }

    @Override
    protected ITransactionalOperation createOperation() {
        ForwardUndoCompositeOperation fwdOp = new ForwardUndoCompositeOperation("BendAndRoute");
        fwdOp.add(new BendVisualOperation((IBendableContentPart<? extends Node>)this.getHost()));
        return fwdOp;
    }

    private IBendableContentPart.BendPoint findOrCreateAnchor(int explicitAnchorIndex, Point positionInLocal, boolean canConnect) {
        IBendableContentPart.BendPoint anchor = null;
        if (canConnect) {
            Point selectedPointCurrentPositionInScene = FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2FX.toFXPoint((Point)positionInLocal)));
            List pickedNodes = NodeUtils.getNodesAt(this.getHost().getRoot().getVisual(), (double)selectedPointCurrentPositionInScene.x, (double)selectedPointCurrentPositionInScene.y);
            anchor = this.getCompatibleAnchor(explicitAnchorIndex, this.getParts(pickedNodes), selectedPointCurrentPositionInScene);
        }
        if (anchor == null) {
            anchor = new IBendableContentPart.BendPoint(positionInLocal);
        }
        return anchor;
    }

    protected BendVisualOperation getBendOperation() {
        return (BendVisualOperation)((AbstractCompositeOperation)super.getOperation()).getOperations().get(0);
    }

    private IBendableContentPart.BendPoint getCompatibleAnchor(int explicitAnchorIndex, List<IContentPart<? extends Node>> partsUnderMouse, Point positionInScene) {
        for (IContentPart<? extends Node> part : partsUnderMouse) {
            IAnchorProvider anchorProvider;
            if (part == this.getHost() || (anchorProvider = (IAnchorProvider)part.getAdapter(IAnchorProvider.class)) == null) continue;
            return new IBendableContentPart.BendPoint(part.getContent(), positionInScene);
        }
        return null;
    }

    protected Connection getConnection() {
        return (Connection)this.getHost().getVisual();
    }

    private int getConnectionIndex(Integer bendPointIndex) {
        Connection connection = (Connection)this.getHost().getVisual();
        IConnectionRouter router = connection.getRouter();
        ObservableList anchors = connection.getAnchorsUnmodifiable();
        int ci = 0;
        int bi = 0;
        while (ci < anchors.size()) {
            if (!router.wasInserted((IAnchor)anchors.get(ci))) {
                if (bi == bendPointIndex) {
                    return ci;
                }
                ++bi;
            }
            ++ci;
        }
        throw new IllegalStateException("Cannot find connection index for BendPoint index.");
    }

    protected List<IBendableContentPart.BendPoint> getCurrentBendPoints() {
        return this.getHost().getVisualBendPoints();
    }

    protected int getExplicitIndex(int startConnectionIndex, int step) {
        List<IBendableContentPart.BendPoint> bpoints = this.getHost().getVisualBendPoints();
        ObservableList anchors = this.getConnection().getAnchorsUnmodifiable();
        IConnectionRouter router = this.getConnection().getRouter();
        int atOrBeforeBi = -1;
        int ci = 0;
        int bi = -1;
        while (ci < anchors.size() && bi < bpoints.size()) {
            if (!router.wasInserted((IAnchor)anchors.get(ci))) {
                ++bi;
            }
            if (ci >= startConnectionIndex) {
                atOrBeforeBi = bi;
                break;
            }
            ++ci;
        }
        if (atOrBeforeBi == -1) {
            throw new IllegalStateException("Start of connection is implicit, i.e. inserted by the router.");
        }
        if (step < 0) {
            return atOrBeforeBi;
        }
        if (router.wasInserted((IAnchor)anchors.get(startConnectionIndex))) {
            return atOrBeforeBi + 1;
        }
        return atOrBeforeBi;
    }

    public int getExplicitIndexAtOrAfter(int connectionIndex) {
        return this.getExplicitIndex(connectionIndex, 1);
    }

    public int getExplicitIndexAtOrBefore(int connectionIndex) {
        return this.getExplicitIndex(connectionIndex, -1);
    }

    public IBendableContentPart<Connection> getHost() {
        return (IBendableContentPart)super.getHost();
    }

    protected List<IBendableContentPart.BendPoint> getInitialBendPoints() {
        return this.initialBendPoints;
    }

    protected double getOverlayThreshold() {
        if (this.getConnection().getRouter() instanceof OrthogonalRouter && this.selectedIndices.size() == 2) {
            return 6.0;
        }
        return 10.0;
    }

    private List<IContentPart<? extends Node>> getParts(List<Node> nodesUnderMouse) {
        ArrayList<IContentPart<? extends Node>> parts = new ArrayList<IContentPart<? extends Node>>();
        IViewer viewer = this.getHost().getRoot().getViewer();
        for (Node node : nodesUnderMouse) {
            IVisualPart<? extends Node> part = PartUtils.retrieveVisualPart(viewer, node);
            if (!(part instanceof IContentPart)) continue;
            parts.add((IContentPart)part);
        }
        return parts;
    }

    private Point getPoint(int explicitAnchorIndex) {
        Connection connection = (Connection)this.getHost().getVisual();
        int ci = this.getConnectionIndex(explicitAnchorIndex);
        return connection.getPoint(ci);
    }

    public List<Point> getSelectedInitialPositions() {
        return this.selectedIndicesInitialPositions;
    }

    @Override
    public void init() {
        this.selectedIndices.clear();
        this.selectedIndicesInitialPositions.clear();
        this.isNormalizationNeeded = false;
        super.init();
        this.initialBendPoints = this.getCurrentBendPoints();
    }

    protected void insertExplicitAnchor(int insertionIndex, Point mouseInScene) {
        Point mouseInLocal = FX2Geometry.toPoint((Point2D)this.getConnection().sceneToLocal(Geometry2FX.toFXPoint((Point)mouseInScene)));
        this.getBendOperation().getFinalBendPoints().add(insertionIndex, new IBendableContentPart.BendPoint(mouseInLocal));
        this.locallyExecuteOperation();
    }

    public boolean isExplicit(int connectionIndex) {
        IAnchor anchor = this.getConnection().getAnchor(connectionIndex);
        return !this.getConnection().getRouter().wasInserted(anchor);
    }

    private boolean isExplicitOverlay(int overlayingExplicitAnchorIndex, int overlainExplicitAnchorIndex) {
        return this.getPoint(overlayingExplicitAnchorIndex).getDistance(this.getPoint(overlainExplicitAnchorIndex)) <= this.getOverlayThreshold();
    }

    private boolean isOrthogonal() {
        int numPoints = this.selectedIndices.size();
        boolean isOrtho = numPoints == 2 && this.getConnection().getRouter() instanceof OrthogonalRouter;
        return isOrtho;
    }

    public boolean isSelectionHorizontal() {
        if (this.isOrthogonal()) {
            double y0 = this.selectedIndicesInitialPositions.get((int)0).y;
            double y1 = this.selectedIndicesInitialPositions.get((int)1).y;
            return this.isUnpreciseEquals(y0, y1);
        }
        return false;
    }

    private boolean isUnpreciseEquals(double y0, double y1) {
        return Math.abs(y0 - y1) < 1.0;
    }

    @Override
    protected void locallyExecuteOperation() {
        try {
            this.getBendOperation().execute(null, null);
        }
        catch (Exception x) {
            throw new IllegalStateException(x);
        }
    }

    public int makeExplicit(int connectionIndex) {
        return this.makeExplicit(connectionIndex, connectionIndex).get(0);
    }

    public List<Integer> makeExplicit(int startConnectionIndex, int endConnectionIndex) {
        this.isNormalizationNeeded = true;
        ArrayList<ImplicitGroup> implicitGroups = new ArrayList<ImplicitGroup>();
        boolean isStartExplicit = this.isExplicit(startConnectionIndex);
        implicitGroups.add(new ImplicitGroup(this.getExplicitIndexAtOrBefore(startConnectionIndex)));
        int i = startConnectionIndex;
        while (i <= endConnectionIndex) {
            if (this.isExplicit(i)) {
                int explicitAnchorHandle = this.getExplicitIndexAtOrBefore(i);
                implicitGroups.add(new ImplicitGroup(explicitAnchorHandle));
            } else {
                Point pointInLocal = this.getConnection().getPoint(i);
                Point pointInScene = FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2FX.toFXPoint((Point)pointInLocal)));
                ((ImplicitGroup)implicitGroups.get((int)(implicitGroups.size() - 1))).points.add(pointInScene);
            }
            ++i;
        }
        if (((ImplicitGroup)implicitGroups.get((int)0)).points.isEmpty()) {
            implicitGroups.remove(0);
        }
        int addedCount = 0;
        ArrayList<Integer> handles = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < implicitGroups.size()) {
            ImplicitGroup ig = (ImplicitGroup)implicitGroups.get(i2);
            int prec = ig.precedingExplicitIndex + addedCount;
            if (!handles.isEmpty() || isStartExplicit) {
                handles.add(prec);
            }
            for (Point p : ig.points) {
                prec = this.createAfter(prec, p);
                ++addedCount;
                handles.add(prec);
            }
            ++i2;
        }
        return handles;
    }

    public void move(Point initialMouseInScene, Point currentMouseInScene) {
        this.checkInitialized();
        this.isNormalizationNeeded = true;
        this.getBendOperation().setFinalBendPoints(this.preMoveBendPoints);
        this.locallyExecuteOperation();
        this.setNewHints(this.preMoveStartHint, this.preMoveEndHint);
        this.locallyExecuteOperation();
        Point mouseDeltaInLocal = FX2Geometry.toPoint((Point2D)this.getConnection().sceneToLocal(Geometry2FX.toFXPoint((Point)currentMouseInScene))).getTranslated(FX2Geometry.toPoint((Point2D)this.getConnection().sceneToLocal(Geometry2FX.toFXPoint((Point)initialMouseInScene))).getNegated());
        if (this.isOrthogonal()) {
            if (this.isSelectionHorizontal()) {
                mouseDeltaInLocal.x = 0.0;
            } else {
                mouseDeltaInLocal.y = 0.0;
            }
        }
        int i = 0;
        while (i < this.selectedIndices.size()) {
            Point selectedPointCurrentPositionInLocal = this.selectedIndicesInitialPositions.get(i).getTranslated(mouseDeltaInLocal);
            int explicitAnchorIndex = this.selectedIndices.get(i);
            boolean canConnect = this.canConnect(explicitAnchorIndex);
            this.getBendOperation().getFinalBendPoints().set(explicitAnchorIndex, this.findOrCreateAnchor(explicitAnchorIndex, selectedPointCurrentPositionInLocal, canConnect));
            ++i;
        }
        this.locallyExecuteOperation();
        this.removeOverlain();
    }

    public void normalize() {
        if (!(this.getConnection().getRouter() instanceof OrthogonalRouter)) {
            return;
        }
        this.locallyExecuteOperation();
        this.route();
        ObservableList anchors = this.getConnection().getAnchorsUnmodifiable();
        ObservableList positions = this.getConnection().getPointsUnmodifiable();
        int explicitIndex = 0;
        boolean removed = false;
        int i = 1;
        while (i < anchors.size() - 1) {
            IAnchor anchor = (IAnchor)anchors.get(i);
            if (!this.getConnection().getRouter().wasInserted(anchor)) {
                ++explicitIndex;
                Point prev = (Point)positions.get(i - 1);
                Point next = (Point)positions.get(i + 1);
                Point current = (Point)positions.get(i);
                Vector inDirection = new Vector(prev, current);
                Vector outDirection = new Vector(current, next);
                if (inDirection.isNull() || outDirection.isNull() || inDirection.isParallelTo(outDirection)) {
                    Point prevInScene = FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(prev.x, prev.y));
                    if (this.getConnection().getRouter().wasInserted((IAnchor)anchors.get(i + 1))) {
                        this.makeExplicit(i + 1);
                    }
                    if (this.getConnection().getRouter().wasInserted((IAnchor)anchors.get(i - 1))) {
                        this.createBefore(explicitIndex, prevInScene);
                        ++explicitIndex;
                    }
                    this.getBendOperation().getFinalBendPoints().remove(explicitIndex);
                    removed = true;
                    break;
                }
            }
            ++i;
        }
        if (removed) {
            this.normalize();
        }
    }

    private void removeOverlain() {
        if (this.getConnection().getRouter() instanceof OrthogonalRouter && this.selectedIndices.size() == 2) {
            this.removeOverlainSegments();
        } else {
            this.removeOverlainPoints();
        }
    }

    private void removeOverlainPoints() {
        int explicitAnchorsSize = this.getBendOperation().getFinalBendPoints().size();
        int i = this.selectedIndices.size() - 1;
        while (i >= 0 && explicitAnchorsSize > 2) {
            boolean isRightOverlain;
            int index = this.selectedIndices.get(i);
            boolean isLeftOverlain = index > 0 && this.isExplicitOverlay(index, index - 1);
            boolean bl = isRightOverlain = index < explicitAnchorsSize - 1 && this.isExplicitOverlay(index, index + 1);
            if (isLeftOverlain || isRightOverlain) {
                int overlainIndex;
                int n = overlainIndex = isLeftOverlain ? index - 1 : index + 1;
                if (!this.selectedIndices.contains(overlainIndex)) {
                    this.getBendOperation().getFinalBendPoints().remove(index);
                    this.locallyExecuteOperation();
                    this.route();
                }
            }
            --i;
        }
    }

    private void removeOverlainSegments() {
        int[][] possibleSegmentOverlays = new int[][]{{-2, -1, 2, 3}, {-2, -1, 2}, {-1, 2, 3}, {-1, 2}, {-2, -1}, {2, 3}, {2}, {-1}};
        boolean removed = false;
        int i = 0;
        while (i < possibleSegmentOverlays.length && !removed) {
            removed = this.testAndRemoveSegmentOverlay(possibleSegmentOverlays[i]);
            ++i;
        }
        if (removed) {
            this.locallyExecuteOperation();
            this.route();
        }
    }

    protected void route() {
        Point newStartHint = this.computeStartHint();
        Point newEndHint = this.computeEndHint();
        this.setNewHints(newStartHint, newEndHint);
        this.locallyExecuteOperation();
    }

    public void select(int explicitAnchorIndex) {
        this.checkInitialized();
        this.selectedIndices.add(explicitAnchorIndex);
        this.selectedIndicesInitialPositions.add(this.getPoint(explicitAnchorIndex));
        this.preMoveStartHint = ((Connection)this.getHost().getVisual()).getStartPointHint();
        this.preMoveEndHint = ((Connection)this.getHost().getVisual()).getEndPointHint();
        this.preMoveBendPoints.clear();
        this.preMoveBendPoints.addAll(this.getBendOperation().getFinalBendPoints());
    }

    public void selectSegment(int segmentIndex) {
        int firstSegmentIndex = segmentIndex;
        int secondSegmentIndex = segmentIndex + 1;
        Node firstAnchorage = this.getConnection().getAnchor(firstSegmentIndex).getAnchorage();
        boolean isFirstConnected = firstAnchorage != null && firstAnchorage != this.getConnection();
        Node secondAnchorage = this.getConnection().getAnchor(secondSegmentIndex).getAnchorage();
        boolean isSecondConnected = secondAnchorage != null && secondAnchorage != this.getConnection();
        List<Integer> explicit = this.makeExplicit(firstSegmentIndex, secondSegmentIndex);
        int firstAnchorHandle = explicit.get(0);
        int secondAnchorHandle = explicit.get(1);
        if (isFirstConnected) {
            firstAnchorHandle = this.createAfter(firstAnchorHandle, FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2FX.toFXPoint((Point)this.getPoint(firstAnchorHandle)))));
            ++secondAnchorHandle;
        }
        if (isSecondConnected) {
            secondAnchorHandle = this.createBefore(secondAnchorHandle, FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2FX.toFXPoint((Point)this.getPoint(secondAnchorHandle)))));
        }
        this.select(firstAnchorHandle);
        this.select(secondAnchorHandle);
    }

    protected void setNewHints(Point startHint, Point endHint) {
        List<IBendableContentPart.BendPoint> finalBendPoints = this.getBendOperation().getFinalBendPoints();
        IBendableContentPart.BendPoint bendPoint = finalBendPoints.get(0);
        if (bendPoint.isAttached() && startHint != null) {
            finalBendPoints.set(0, new IBendableContentPart.BendPoint(bendPoint.getContentAnchorage(), startHint));
        }
        if ((bendPoint = finalBendPoints.get(finalBendPoints.size() - 1)).isAttached() && endHint != null) {
            finalBendPoints.set(finalBendPoints.size() - 1, new IBendableContentPart.BendPoint(bendPoint.getContentAnchorage(), endHint));
        }
    }

    private boolean testAndRemoveSegmentOverlay(int[] overlainPointIndicesRelativeToSelection) {
        boolean isSelectionHorizontal = this.isSelectionHorizontal();
        List<Point> points = Arrays.asList(Point.getCopy((Point[])((Point[])this.getConnection().getPointsUnmodifiable().toArray((Object[])new Point[0]))));
        int firstIndex = overlainPointIndicesRelativeToSelection[0];
        int lastIndex = overlainPointIndicesRelativeToSelection[overlainPointIndicesRelativeToSelection.length - 1];
        int selectionStartIndexInConnection = this.getConnectionIndex(this.selectedIndices.get(0));
        if (selectionStartIndexInConnection + firstIndex < 0 || selectionStartIndexInConnection + firstIndex >= points.size()) {
            return false;
        }
        if (selectionStartIndexInConnection + lastIndex < 0 || selectionStartIndexInConnection + lastIndex >= points.size()) {
            return false;
        }
        ArrayList<Point> overlainPoints = new ArrayList<Point>();
        int i = 0;
        while (i < overlainPointIndicesRelativeToSelection.length) {
            overlainPoints.add(points.get(selectionStartIndexInConnection + overlainPointIndicesRelativeToSelection[i]));
            ++i;
        }
        double p = isSelectionHorizontal ? ((Point)overlainPoints.get((int)0)).y : ((Point)overlainPoints.get((int)0)).x;
        int i2 = 1;
        while (i2 < overlainPoints.size()) {
            Point q = (Point)overlainPoints.get(i2);
            if (isSelectionHorizontal && !this.isUnpreciseEquals(p, q.y) || !isSelectionHorizontal && !this.isUnpreciseEquals(p, q.x)) {
                return false;
            }
            if (isSelectionHorizontal && !this.isUnpreciseEquals(p, q.y) || !isSelectionHorizontal && !this.isUnpreciseEquals(p, q.x)) {
                return false;
            }
            ++i2;
        }
        Point resultStart = (Point)overlainPoints.get(0);
        Point resultEnd = (Point)overlainPoints.get(overlainPoints.size() - 1);
        Point selectionStart = points.get(selectionStartIndexInConnection);
        Point selectionEnd = points.get(selectionStartIndexInConnection + 1);
        double distance = Math.abs(isSelectionHorizontal ? resultStart.y - selectionStart.y : resultStart.x - selectionStart.x);
        if (distance > this.getOverlayThreshold()) {
            return false;
        }
        if (overlainPointIndicesRelativeToSelection.length <= 2) {
            if (isSelectionHorizontal) {
                if (firstIndex < 0) {
                    resultEnd.x = selectionEnd.x;
                } else {
                    resultStart.x = selectionStart.x;
                }
            } else if (firstIndex < 0) {
                resultEnd.y = selectionEnd.y;
            } else {
                resultStart.y = selectionStart.y;
            }
        }
        int overlayStartIndex = Math.min(selectionStartIndexInConnection, selectionStartIndexInConnection + firstIndex);
        int overlayEndIndex = Math.max(selectionStartIndexInConnection + 1, selectionStartIndexInConnection + lastIndex);
        List<Integer> explicit = this.makeExplicit(overlayStartIndex, overlayEndIndex);
        int removedCount = 0;
        int i3 = explicit.size() - 2;
        while (i3 >= 1) {
            this.getBendOperation().getFinalBendPoints().remove(explicit.get(i3));
            ++removedCount;
            --i3;
        }
        Integer resultStartIndex = explicit.get(0);
        IBendableContentPart.BendPoint resultStartAnchor = this.getBendOperation().getFinalBendPoints().get(resultStartIndex);
        if (resultStartIndex > 0 && !resultStartAnchor.isAttached()) {
            this.getBendOperation().getFinalBendPoints().set(resultStartIndex, new IBendableContentPart.BendPoint(resultStart));
        }
        Integer resultEndIndex = explicit.get(explicit.size() - 1) - removedCount;
        IBendableContentPart.BendPoint resultEndAnchor = this.getBendOperation().getFinalBendPoints().get(resultEndIndex);
        if (resultEndIndex < this.getBendOperation().getFinalBendPoints().size() - 1 && !resultEndAnchor.isAttached()) {
            this.getBendOperation().getFinalBendPoints().set(resultEndIndex, new IBendableContentPart.BendPoint(resultEnd));
        }
        return true;
    }

    public String toString() {
        return "BendConnectionPolicy[host=" + this.getHost() + "]";
    }

    private static class ImplicitGroup {
        int precedingExplicitIndex;
        List<Point> points = new ArrayList<Point>();

        public ImplicitGroup(int precedingExplicitIndex) {
            this.precedingExplicitIndex = precedingExplicitIndex;
        }
    }
}

