/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.uml.alf.AlfFactory;
import org.eclipse.papyrus.uml.alf.Model;
import org.eclipse.papyrus.uml.alf.impl.ModelNamespaceImpl;
import org.eclipse.uml2.uml.Namespace;

class AlfValidationContextRegistry {
    protected HashMap<URI, ModelNamespaceWithState> validationMap = new HashMap();

    protected AlfValidationContextRegistry() {
    }

    public ModelNamespaceImpl getCurrentlyUsedValidationContext() {
        ModelNamespaceImpl namespace = null;
        Iterator<URI> iterator = this.validationMap.keySet().iterator();
        while (namespace == null && iterator.hasNext()) {
            URI uri = iterator.next();
            if (!this.validationMap.get((Object)uri).used) continue;
            namespace = this.validationMap.get((Object)uri).modelNamespace;
        }
        if (namespace == null) {
            namespace = this.createEmptyValidationContext(null);
        }
        return namespace;
    }

    public ModelNamespaceImpl getValidationContext(URI uri) {
        if (this.validationMap.get(uri) != null) {
            return this.validationMap.get((Object)uri).modelNamespace;
        }
        return null;
    }

    protected ModelNamespaceImpl createEmptyValidationContext(URI uri) {
        ModelNamespaceImpl namespace = null;
        namespace = (ModelNamespaceImpl)AlfFactory.eINSTANCE.createModelNamespace();
        namespace.setContextNamespace((Namespace)new Model());
        this.add(uri, new ModelNamespaceWithState(namespace, true));
        return namespace;
    }

    private void add(URI uri, ModelNamespaceWithState modelNamespace) {
        for (URI currentURI : this.validationMap.keySet()) {
            this.validationMap.get((Object)currentURI).used = false;
        }
        this.validationMap.put(uri, modelNamespace);
    }

    protected ModelNamespaceImpl createValidationContext(URI uri, Namespace namespace) {
        ModelNamespaceImpl modelNamespace = null;
        if (uri != null && namespace != null) {
            ModelNamespaceImpl modelNamespaceImpl = modelNamespace = this.validationMap.get(uri) != null ? this.validationMap.get((Object)uri).modelNamespace : null;
            if (modelNamespace != null) {
                modelNamespace.setContextNamespace(namespace);
            } else {
                modelNamespace = (ModelNamespaceImpl)AlfFactory.eINSTANCE.createModelNamespace();
                modelNamespace.setContextNamespace(namespace);
                this.add(uri, new ModelNamespaceWithState(modelNamespace, true));
            }
        }
        return modelNamespace;
    }

    public boolean deleteValidationContext(URI uri) {
        ModelNamespaceWithState modelNamespace = this.validationMap.get(uri);
        if (modelNamespace != null) {
            this.validationMap.remove(modelNamespace);
            if (modelNamespace.modelNamespace.getContextNamespace() instanceof Model) {
                ((Model)modelNamespace.modelNamespace.getContextNamespace()).clean();
            }
            return true;
        }
        return false;
    }

    class ModelNamespaceWithState {
        public ModelNamespaceImpl modelNamespace;
        public boolean used;

        protected ModelNamespaceWithState() {
            this.used = false;
        }

        protected ModelNamespaceWithState(ModelNamespaceImpl namespace, boolean used) {
            this.used = used;
            this.modelNamespace = namespace;
        }
    }
}

