/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.providers;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateNodeViewOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.uml.diagram.activity.locator.PinPositionLocator;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLViewProvider;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.uml2.uml.ActionInputPin;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.OpaqueAction;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValuePin;

public class CustomUMLViewProvider
extends UMLViewProvider {
    @Override
    public Edge createControlFlow_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge edge = super.createControlFlow_Edge(domainElement, containerView, index, persisted, preferencesHint);
        if (edge != null) {
            EObject semanticElement = edge.getElement();
            if (semanticElement != null) {
                if (!semanticElement.eIsSet((EStructuralFeature)UMLPackage.Literals.ACTIVITY_EDGE__INTERRUPTS)) {
                    this.deleteView(edge, "ControlFlow_IconLabel");
                }
            } else {
                this.deleteView(edge, "ControlFlow_IconLabel");
            }
        }
        return edge;
    }

    @Override
    public Edge createObjectFlow_Edge(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Edge edge = super.createObjectFlow_Edge(domainElement, containerView, index, persisted, preferencesHint);
        if (edge != null) {
            EObject semanticElement = edge.getElement();
            if (semanticElement != null) {
                if (!semanticElement.eIsSet((EStructuralFeature)UMLPackage.Literals.ACTIVITY_EDGE__INTERRUPTS)) {
                    this.deleteView(edge, "ObjectFlow_IconLabel");
                }
            } else {
                this.deleteView(edge, "ObjectFlow_IconLabel");
            }
        }
        return edge;
    }

    private void deleteView(Edge edge, String semanticHint) {
        View interruptibleIconView = ViewUtil.getChildBySemanticHint((View)edge, (String)String.valueOf(semanticHint));
        if (interruptibleIconView != null) {
            ViewUtil.destroy((View)interruptibleIconView);
        }
    }

    public Node createInterruptibleEdgeIconOnControlFlow(View edge, PreferencesHint preferencesHint) {
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        Node label = this.createLabel(edge, UMLVisualIDRegistry.getType("ControlFlow_IconLabel"));
        label.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)edge, (IPreferenceStore)prefStore, (String)"ControlFlow");
        return label;
    }

    public Node createInterruptibleEdgeIconOnObjectlFlow(View containerView, PreferencesHint preferencesHint) {
        IPreferenceStore prefStore = (IPreferenceStore)preferencesHint.getPreferenceStore();
        Node label = this.createLabel(containerView, UMLVisualIDRegistry.getType("ObjectFlow_IconLabel"));
        label.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        PreferenceInitializerForElementHelper.initLabelVisibilityFromPrefs((View)containerView, (IPreferenceStore)prefStore, (String)"ObjectFlow");
        return label;
    }

    @Override
    public Node createNode(IAdaptable semanticAdapter, View containerView, String semanticHint, int index, boolean persisted, PreferencesHint preferencesHint) {
        EObject domainElement = this.getSemanticElement(semanticAdapter);
        String visualID = semanticHint == null ? UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement) : UMLVisualIDRegistry.getVisualID(semanticHint);
        Node node = this.createCustomNode(visualID, containerView, preferencesHint);
        return node != null ? node : super.createNode(semanticAdapter, containerView, semanticHint, index, persisted, preferencesHint);
    }

    @Override
    protected boolean provides(CreateNodeViewOperation op) {
        return super.provides(op) || this.isCustomNode(op);
    }

    protected boolean isCustomNode(CreateNodeViewOperation op) {
        IElementType elementType = this.getSemanticElementType(op.getSemanticAdapter());
        if (op.getContainerView() != null && op.getSemanticHint() != null && elementType == null) {
            String visualID = UMLVisualIDRegistry.getVisualID(op.getSemanticHint());
            return this.isCustomNode(visualID);
        }
        return false;
    }

    protected boolean isCustomNode(String visualID) {
        switch (visualID) {
            case "ControlFlow_IconLabel": 
            case "ObjectFlow_IconLabel": {
                return true;
            }
        }
        return false;
    }

    protected Node createCustomNode(String visualID, View containerView, PreferencesHint preferencesHint) {
        switch (visualID) {
            case "ControlFlow_IconLabel": {
                return this.createInterruptibleEdgeIconOnControlFlow(containerView, preferencesHint);
            }
            case "ObjectFlow_IconLabel": {
                return this.createInterruptibleEdgeIconOnObjectlFlow(containerView, preferencesHint);
            }
        }
        return null;
    }

    @Override
    public Node createOpaqueAction_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = super.createOpaqueAction_Shape(domainElement, containerView, index, persisted, preferencesHint);
        this.adaptActionHeight(node, domainElement);
        this.createPins(domainElement, node, persisted, preferencesHint);
        return node;
    }

    @Override
    public Node createCallBehaviorAction_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = super.createCallBehaviorAction_Shape(domainElement, containerView, index, persisted, preferencesHint);
        this.adaptActionHeight(node, domainElement);
        this.createPins(domainElement, node, persisted, preferencesHint);
        return node;
    }

    @Override
    public Node createCallOperationAction_Shape(EObject domainElement, View containerView, int index, boolean persisted, PreferencesHint preferencesHint) {
        Node node = super.createCallOperationAction_Shape(domainElement, containerView, index, persisted, preferencesHint);
        this.adaptActionHeight(node, domainElement);
        this.createPins(domainElement, node, persisted, preferencesHint);
        return node;
    }

    private void adaptActionHeight(Node node, EObject domainElement) {
        Bounds boundsConstraint = NotationFactory.eINSTANCE.createBounds();
        PinPositionLocator.adaptActionHeight(boundsConstraint, domainElement);
        node.setLayoutConstraint((LayoutConstraint)boundsConstraint);
    }

    private void createPins(EObject domainElement, Node node, boolean persisted, PreferencesHint preferencesHint) {
        block24: {
            block25: {
                block23: {
                    if (!(domainElement instanceof OpaqueAction)) break block23;
                    int index = 0;
                    for (InputPin pin : ((OpaqueAction)domainElement).getInputValues()) {
                        if (pin instanceof ValuePin) {
                            this.createValuePin_OpaqueActionInputShape((EObject)pin, (View)node, index, persisted, preferencesHint);
                        } else if (pin instanceof ActionInputPin) {
                            this.createActionInputPin_OpaqueActionInputShape((EObject)pin, (View)node, index, persisted, preferencesHint);
                        } else {
                            this.createInputPin_OpaqueActionInputShape((EObject)pin, (View)node, index, persisted, preferencesHint);
                        }
                        ++index;
                    }
                    index = 0;
                    for (InputPin pin : ((OpaqueAction)domainElement).getOutputValues()) {
                        this.createOutputPin_OpaqueActionOutputShape((EObject)pin, (View)node, index, persisted, preferencesHint);
                    }
                    break block24;
                }
                if (!(domainElement instanceof CallBehaviorAction)) break block25;
                int index = 0;
                for (InputPin pin : ((CallBehaviorAction)domainElement).getArguments()) {
                    if (pin instanceof ValuePin) {
                        this.createValuePin_CallBehaviorActionArgumentShape((EObject)pin, (View)node, index, persisted, preferencesHint);
                    } else if (pin instanceof ActionInputPin) {
                        this.createActionInputPin_CallBehaviorActionArgumentShape((EObject)pin, (View)node, index, persisted, preferencesHint);
                    } else {
                        this.createInputPin_CallBehaviorActionArgumentShape((EObject)pin, (View)node, index, persisted, preferencesHint);
                    }
                    ++index;
                }
                index = 0;
                for (InputPin pin : ((CallBehaviorAction)domainElement).getResults()) {
                    this.createOutputPin_CallBehaviorActionResultShape((EObject)pin, (View)node, index, persisted, preferencesHint);
                }
                break block24;
            }
            if (!(domainElement instanceof CallOperationAction)) break block24;
            int index = 0;
            for (InputPin pin : ((CallOperationAction)domainElement).getArguments()) {
                if (pin instanceof ValuePin) {
                    this.createValuePin_CallOperationActionArgumentShape((EObject)pin, (View)node, index, persisted, preferencesHint);
                } else if (pin instanceof ActionInputPin) {
                    this.createActionInputPin_CallOperationActionArgumentShape((EObject)pin, (View)node, index, persisted, preferencesHint);
                } else {
                    this.createInputPin_CallOperationActionArgumentShape((EObject)pin, (View)node, index, persisted, preferencesHint);
                }
                ++index;
            }
            InputPin target = ((CallOperationAction)domainElement).getTarget();
            if (target instanceof ValuePin) {
                this.createValuePin_CallOperationActionTargetShape((EObject)target, (View)node, index, persisted, preferencesHint);
            } else if (target instanceof ActionInputPin) {
                this.createActionInputPin_CallOperationActionTargetShape((EObject)target, (View)node, index, persisted, preferencesHint);
            } else if (target != null) {
                this.createInputPin_CallOperationActionTargetShape((EObject)target, (View)node, index, persisted, preferencesHint);
            }
            index = 0;
            for (OutputPin pin : ((CallOperationAction)domainElement).getResults()) {
                this.createOutputPin_CallOperationActionResultShape((EObject)pin, (View)node, index, persisted, preferencesHint);
            }
        }
    }
}

