/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.TimeConstraint;

public class TimeConstraintHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                TimeConstraint newElement = (TimeConstraint)request.getElementToConfigure();
                Object paramOccurrence = this.getRequest().getParameter("Nearest occurrence specification");
                List<OccurrenceSpecification> occList = TimeConstraintHelperAdvice.getAsOccSpecList(paramOccurrence);
                if (!occList.isEmpty()) {
                    for (OccurrenceSpecification occurrence : occList) {
                        Message mess;
                        if (occurrence instanceof MessageOccurrenceSpecification && (mess = ((MessageOccurrenceSpecification)occurrence).getMessage()) != null && occurrence.equals(mess.getReceiveEvent()) && MessageSort.SYNCH_CALL_LITERAL.equals((Object)mess.getMessageSort()) && occList.contains(mess.getSendEvent())) continue;
                        newElement.getConstrainedElements().add((Object)occurrence);
                        break;
                    }
                }
                return CommandResult.newOKCommandResult((Object)newElement);
            }
        };
    }

    public static List<OccurrenceSpecification> getAsOccSpecList(Object occurrenceSpecificationList) {
        List list;
        if (occurrenceSpecificationList instanceof List && !(list = (List)occurrenceSpecificationList).isEmpty()) {
            ArrayList<OccurrenceSpecification> newList = new ArrayList<OccurrenceSpecification>(list.size());
            for (Object elt : list) {
                if (!(elt instanceof OccurrenceSpecification)) continue;
                newList.add((OccurrenceSpecification)elt);
            }
            return newList;
        }
        return Collections.emptyList();
    }
}

