/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.command.DisposeCalculatedValueCacheCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.DisposeResourcesCommand;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.formula.FormulaErrorReporter;
import org.eclipse.nebula.widgets.nattable.formula.FormulaParser;
import org.eclipse.nebula.widgets.nattable.formula.command.DisableFormulaCachingCommand;
import org.eclipse.nebula.widgets.nattable.formula.command.DisableFormulaCachingCommandHandler;
import org.eclipse.nebula.widgets.nattable.formula.command.EnableFormulaCachingCommand;
import org.eclipse.nebula.widgets.nattable.formula.command.EnableFormulaCachingCommandHandler;
import org.eclipse.nebula.widgets.nattable.formula.function.AbstractFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionException;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.util.CalculatedValueCache;

public class FormulaDataProvider
implements IDataProvider {
    protected IDataProvider underlyingDataProvider;
    protected FormulaParser formulaParser;
    protected FormulaErrorReporter errorReporter;
    protected boolean formulaEvaluationEnabled = true;
    private CalculatedValueCache valueCache;
    private ILayer cacheLayer;
    private boolean cacheEnabled = false;

    public FormulaDataProvider(IDataProvider underlyingDataProvider) {
        this(underlyingDataProvider, new FormulaParser(underlyingDataProvider));
    }

    public FormulaDataProvider(IDataProvider underlyingDataProvider, FormulaParser parser) {
        this.underlyingDataProvider = underlyingDataProvider;
        this.formulaParser = parser;
    }

    @Override
    public Object getDataValue(int columnIndex, int rowIndex) {
        Object underlying = this.underlyingDataProvider.getDataValue(columnIndex, rowIndex);
        if (this.formulaEvaluationEnabled && underlying != null && this.formulaParser.isFunction(underlying.toString())) {
            if (this.cacheEnabled && this.valueCache != null) {
                return this.valueCache.getCalculatedValue(columnIndex, rowIndex, true, () -> this.processFormula(underlying.toString(), columnIndex, rowIndex));
            }
            return this.processFormula(underlying.toString(), columnIndex, rowIndex);
        }
        return underlying;
    }

    protected Object processFormula(String formula, int columnIndex, int rowIndex) {
        try {
            if (this.errorReporter != null) {
                this.errorReporter.clearFormulaError(columnIndex, rowIndex);
            }
            return this.formulaParser.parseFunction(formula).getValue();
        }
        catch (FunctionException e) {
            if (this.errorReporter != null) {
                this.errorReporter.addFormulaError(columnIndex, rowIndex, e.getLocalizedMessage());
            }
            return e.getErrorMarkup();
        }
        catch (Exception e) {
            if (this.errorReporter != null) {
                this.errorReporter.addFormulaError(columnIndex, rowIndex, e.getLocalizedMessage());
            }
            return "#ERROR!";
        }
    }

    public void configureCaching(ILayer layer) {
        if (this.cacheLayer != null) {
            this.cacheLayer.unregisterCommandHandler(DisposeResourcesCommand.class);
            this.cacheLayer.unregisterCommandHandler(DisableFormulaCachingCommand.class);
            this.cacheLayer.unregisterCommandHandler(EnableFormulaCachingCommand.class);
        }
        this.cacheLayer = layer;
        if (layer != null) {
            this.valueCache = new CalculatedValueCache(this.cacheLayer, true, true);
            this.cacheEnabled = true;
            this.cacheLayer.registerCommandHandler(new DisposeCalculatedValueCacheCommandHandler(this.valueCache));
            this.cacheLayer.registerCommandHandler(new DisableFormulaCachingCommandHandler(this));
            this.cacheLayer.registerCommandHandler(new EnableFormulaCachingCommandHandler(this));
        } else {
            this.valueCache = null;
            this.cacheEnabled = false;
        }
    }

    public Object getNativeDataValue(int columnIndex, int rowIndex) {
        return this.underlyingDataProvider.getDataValue(columnIndex, rowIndex);
    }

    @Override
    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
        if (this.valueCache != null) {
            this.valueCache.clearCache();
        }
        this.underlyingDataProvider.setDataValue(columnIndex, rowIndex, newValue);
    }

    @Override
    public int getColumnCount() {
        return this.underlyingDataProvider.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.underlyingDataProvider.getRowCount();
    }

    protected IDataProvider getUnderlyingDataProvider() {
        return this.underlyingDataProvider;
    }

    public void setFormulaEvaluationEnabled(boolean enabled) {
        this.formulaEvaluationEnabled = enabled;
    }

    public void setFormulaCachingEnabled(boolean enabled) {
        this.cacheEnabled = enabled;
    }

    public void registerFunction(String functionName, Class<? extends AbstractFunction> value) {
        this.formulaParser.registerFunction(functionName, value);
    }

    public Collection<String> getRegisteredFunctions() {
        return this.formulaParser.getRegisteredFunctions();
    }

    public FormulaParser getFormulaParser() {
        return this.formulaParser;
    }

    public FormulaErrorReporter getErrorReporter() {
        return this.errorReporter;
    }

    public void setErrorReporter(FormulaErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }
}

