/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.newchild.internal.checkers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.ElementCreationMenuModelPackage;
import org.eclipse.papyrus.infra.newchild.elementcreationmenumodel.Menu;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.BuildPropertiesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.CustomModelChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ExtensionsChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker2;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelDependenciesChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.ModelValidationChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.OpaqueResourceProvider;
import org.eclipse.papyrus.toolsmiths.validation.common.internal.utils.PluginErrorReporter;
import org.eclipse.papyrus.toolsmiths.validation.newchild.internal.checkers.NewChildCustomValidator;
import org.eclipse.papyrus.toolsmiths.validation.newchild.internal.checkers.NewChildMenuPluginXMLValidator;

public class NewChildMenuPluginChecker {
    public static final String NEW_CHILD_MENU_EXTENSION = "creationmenumodel";
    private static final Set<String> ADDITIONAL_REQUIREMENTS = Set.of("org.eclipse.papyrus.infra.newchild");

    public static IPluginChecker2.Factory modelDependenciesCheckerFactory() {
        return IPluginChecker2.Factory.forProject(NewChildMenuPluginChecker::createModelDependenciesChecker).or(IPluginChecker2.Factory.forEMFResource(NewChildMenuPluginChecker::createModelDependenciesChecker));
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project) {
        return new ModelDependenciesChecker(project, null, null, "org.eclipse.papyrus.toolsmiths.validation.newchild.diagnostic").addRequirements(ADDITIONAL_REQUIREMENTS).withSeverityFunction(bundle -> ADDITIONAL_REQUIREMENTS.contains(bundle) ? 2 : 4);
    }

    private static ModelDependenciesChecker createModelDependenciesChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelDependenciesChecker(project, modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.newchild.diagnostic").withReferencedResources(NewChildMenuPluginChecker.createOpaqueResourceProvider());
    }

    private static OpaqueResourceProvider.EMF createOpaqueResourceProvider() {
        return OpaqueResourceProvider.EMF.create((Object)OpaqueResourceProvider.ResourceKind.ICON, (String)"http://www.eclipse.org/papyrus/infra/newchild/elementcreationmenumodel", (EAttribute)ElementCreationMenuModelPackage.Literals.MENU__ICON);
    }

    public static IPluginChecker2.Factory modelValidationCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(NewChildMenuPluginChecker::createModelValidationChecker);
    }

    private static ModelValidationChecker createModelValidationChecker(IProject project, IFile modelFile, Resource resource) {
        return new ModelValidationChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.newchild.diagnostic");
    }

    public static IPluginChecker2.Factory customModelCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(NewChildMenuPluginChecker::createCustomModelChecker);
    }

    private static CustomModelChecker createCustomModelChecker(IProject project, IFile modelFile, Resource resource) {
        return new CustomModelChecker(modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.newchild.diagnostic").withValidator("http://www.eclipse.org/papyrus/infra/newchild/elementcreationmenumodel", NewChildCustomValidator::new);
    }

    public static IPluginChecker2.Factory buildPropertiesCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(NewChildMenuPluginChecker::createBuildPropertiesChecker);
    }

    private static BuildPropertiesChecker createBuildPropertiesChecker(IProject project, IFile modelFile, Resource resource) {
        return new BuildPropertiesChecker(project, modelFile, resource, "org.eclipse.papyrus.toolsmiths.validation.newchild.diagnostic").withReferencedResources(NewChildMenuPluginChecker.createOpaqueResourceProvider());
    }

    public static IPluginChecker2.Factory extensionsCheckerFactory() {
        return IPluginChecker2.Factory.forEMFResource(NewChildMenuPluginChecker::createExtensionsChecker);
    }

    private static ExtensionsChecker<Menu, PluginErrorReporter<Menu>> createExtensionsChecker(IProject project, IFile modelFile, Resource resource) {
        Collection menus = EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)ElementCreationMenuModelPackage.Literals.MENU);
        return new ExtensionsChecker(project, modelFile, menus, "org.eclipse.papyrus.toolsmiths.validation.newchild.diagnostic", NewChildMenuPluginChecker::createPluginErrorReporter);
    }

    private static PluginErrorReporter<Menu> createPluginErrorReporter(IFile pluginXML, IFile modelFile, Menu model) {
        NewChildMenuPluginXMLValidator validator = new NewChildMenuPluginXMLValidator(modelFile);
        return new PluginErrorReporter(pluginXML, modelFile, (EObject)model, "org.eclipse.papyrus.toolsmiths.validation.newchild.diagnostic", menu -> menu.getLabel()).requireExtensionPoint("org.eclipse.papyrus.infra.newchild", validator::matchExtension, null, validator::problemID);
    }
}

