/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.properties.common.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.eef.EEFViewDescription;
import org.eclipse.eef.core.api.EEFPage;
import org.eclipse.eef.core.api.EEFView;
import org.eclipse.eef.core.api.EEFViewFactory;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.InputDescriptor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.papyrus.sirius.properties.common.dialog.PropertiesFormDialog;
import org.eclipse.papyrus.sirius.properties.common.messages.Messages;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.common.interpreter.api.VariableManagerFactory;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.properties.AbstractOverrideDescription;
import org.eclipse.sirius.properties.Category;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.core.api.OverridesProvider;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.sirius.properties.core.api.ViewDescriptionConverter;
import org.eclipse.sirius.properties.core.api.ViewDescriptionPreprocessor;
import org.eclipse.sirius.ui.properties.internal.SiriusUIPropertiesPlugin;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PropertiesUtils {
    private static int open;
    private List<Group> activeSiriusGroup;

    public int displayCreationProperties(EditingContextAdapter contextAdapter, EObject target, IVariableManager variableManager, IInterpreter interpreter) {
        return this.displayProperties(contextAdapter, target, contextAdapter.getEditingDomain().getResourceSet(), variableManager, interpreter, Messages.PropertiesDialogTitle_createAction);
    }

    public int displayEditionProperties(EditingContextAdapter contextAdapter, EObject target, IVariableManager variableManager, IInterpreter interpreter) {
        return this.displayProperties(contextAdapter, target, target.eResource().getResourceSet(), variableManager, interpreter, Messages.PropertiesDialogTitle_editAction);
    }

    public int displayProperties(EditingContextAdapter contextAdapter, EObject target, ResourceSet resourceSet, IVariableManager variableManager, IInterpreter interpreter, String actionTitle) {
        List<EEFPage> eefPages = this.getPagesToDisplay(contextAdapter, target, resourceSet, interpreter);
        if (!eefPages.isEmpty()) {
            boolean isInUiThread;
            Runnable runnable = () -> {
                Shell shell = Display.getCurrent().getActiveShell();
                PropertiesFormDialog formDialog = new PropertiesFormDialog(shell, target, interpreter, variableManager, eefPages);
                formDialog.setActionTitle(actionTitle);
                formDialog.create();
                formDialog.getShell().setMinimumSize(600, 200);
                open = formDialog.open();
                if (open != 0) {
                    throw new OperationCanceledException();
                }
            };
            boolean bl = isInUiThread = Display.getCurrent() != null && Display.getCurrent().getActiveShell() != null;
            if (isInUiThread) {
                runnable.run();
            } else {
                Display.getDefault().syncExec(runnable);
            }
        } else {
            open = 0;
        }
        return open;
    }

    public List<EEFPage> getPagesToDisplay(EditingContextAdapter contextAdapter, final EObject target, ResourceSet resourceSet, IInterpreter interpreter) {
        ArrayList<EEFPage> eefPages = new ArrayList<EEFPage>();
        List<Group> siriusGroup = this.getActiveSiriusGroup(resourceSet);
        final Map<String, List<AbstractOverrideDescription>> descriptionToOverride = this.initiateOverrideExtension(siriusGroup);
        for (Group group : siriusGroup) {
            Optional<ViewExtensionDescription> optionalDescription = group.getExtensions().stream().filter(ViewExtensionDescription.class::isInstance).map(ViewExtensionDescription.class::cast).findFirst();
            optionalDescription.ifPresent(viewExtensionDescription -> {
                SiriusInputDescriptor input = new SiriusInputDescriptor(target){

                    public EObject getSemanticElement() {
                        EObject result = super.getSemanticElement();
                        if (result == null) {
                            return target;
                        }
                        return result;
                    }
                };
                IVariableManager variableManager = this.createVariableManagerFromDescriptor(input);
                ViewDescriptionPreprocessor preprocessor = new ViewDescriptionPreprocessor(viewExtensionDescription);
                OverridesProvider overridesProvider = new OverridesProvider(null){

                    public List<AbstractOverrideDescription> getOverrideDescriptions(EObject eObject) {
                        List overrides;
                        String name = null;
                        if (eObject instanceof IdentifiedElement) {
                            name = ((IdentifiedElement)eObject).getName();
                        }
                        if ((overrides = (List)descriptionToOverride.get(name)) == null) {
                            return new ArrayList<AbstractOverrideDescription>();
                        }
                        return overrides;
                    }
                };
                Optional optionalViewExtensionDescription = preprocessor.convert(interpreter, variableManager, overridesProvider);
                EList categories = optionalViewExtensionDescription.map(ViewExtensionDescription::getCategories).orElse((EList)new BasicEList());
                List pageDescriptions = categories.stream().map(Category::getPages).flatMap(Collection::stream).collect(Collectors.toList());
                EEFViewDescription eefViewDescription = new ViewDescriptionConverter(pageDescriptions).convert(input);
                Option optSession = input.getFullContext().getSession();
                EditingContextAdapter editingContextAdapter2 = optSession.some() ? SiriusUIPropertiesPlugin.getPlugin().getEditingContextAdapter((Session)optSession.get()) : contextAdapter;
                EEFView createEEFView = new EEFViewFactory().createEEFView(eefViewDescription, variableManager, interpreter, editingContextAdapter2, (InputDescriptor)input);
                eefPages.addAll(createEEFView.getPages());
            });
        }
        return eefPages;
    }

    public IVariableManager createVariableManagerFromDescriptor(SiriusInputDescriptor input) {
        IVariableManager variableManager = new VariableManagerFactory().createVariableManager();
        variableManager.put("self", (Object)input.getSemanticElement());
        variableManager.put("input", (Object)input);
        return variableManager;
    }

    public Map<String, List<AbstractOverrideDescription>> initiateOverrideExtension(List<Group> siriusGroup) {
        HashMap<String, List<AbstractOverrideDescription>> descriptionToOverride = new HashMap<String, List<AbstractOverrideDescription>>();
        for (Group group : siriusGroup) {
            Optional<ViewExtensionDescription> optionalDescription = group.getExtensions().stream().filter(ViewExtensionDescription.class::isInstance).map(ViewExtensionDescription.class::cast).findFirst();
            optionalDescription.ifPresent(viewExtensionDescription -> {
                List overrides = viewExtensionDescription.getCategories().stream().map(Category::getOverrides).flatMap(Collection::stream).collect(Collectors.toList());
                for (AbstractOverrideDescription override : overrides) {
                    EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)override.eCrossReferences().iterator();
                    while (featureIterator.hasNext()) {
                        featureIterator.next();
                        if (!"overrides".equals(featureIterator.feature().getName())) continue;
                        Object descriptionOverrided = override.eGet(featureIterator.feature());
                        String descriptionName = ((IdentifiedElement)descriptionOverrided).getName();
                        ArrayList<AbstractOverrideDescription> list = (ArrayList<AbstractOverrideDescription>)descriptionToOverride.get(descriptionName);
                        if (list == null) {
                            list = new ArrayList<AbstractOverrideDescription>();
                            list.add(override);
                            descriptionToOverride.put(descriptionName, list);
                            continue;
                        }
                        list.add(override);
                    }
                }
            });
        }
        return descriptionToOverride;
    }

    public List<Group> getActiveSiriusGroup(ResourceSet resourceSet) {
        if (this.activeSiriusGroup == null || this.activeSiriusGroup.isEmpty()) {
            this.activeSiriusGroup = new ArrayList<Group>();
            for (Resource resource : resourceSet.getResources()) {
                if (!"odesign".equals(resource.getURI().fileExtension())) continue;
                this.activeSiriusGroup.addAll(resource.getContents().stream().filter(Group.class::isInstance).map(Group.class::cast).collect(Collectors.toList()));
            }
        }
        return this.activeSiriusGroup;
    }

    public List<Object> getAllPossibleTypes(ComposedAdapterFactory composedAdapterFactory, EditingContextAdapter editingContextAdapter, EObject eObject, EReference eReference) {
        ArrayList<Object> values = new ArrayList<Object>();
        Adapter adapter = composedAdapterFactory.adapt((Notifier)eObject, IEditingDomainItemProvider.class);
        if (adapter instanceof IEditingDomainItemProvider) {
            IEditingDomainItemProvider itemProviderAdapter = (IEditingDomainItemProvider)adapter;
            Collection newChildDescriptors = itemProviderAdapter.getNewChildDescriptors((Object)eObject, editingContextAdapter.getEditingDomain(), null);
            for (Object newChildDescriptor : newChildDescriptors) {
                if (!(newChildDescriptor instanceof CommandParameter)) continue;
                CommandParameter commandParameter = (CommandParameter)newChildDescriptor;
                Object value = commandParameter.getValue();
                if (!commandParameter.getEReference().equals(eReference) || !(value instanceof EObject) || !eReference.getEReferenceType().isSuperTypeOf(((EObject)value).eClass())) continue;
                values.add(commandParameter.getValue());
            }
        }
        return values;
    }
}

