/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.integration.nattable.template2structure.internal.mapping;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.export.image.ImageFormat;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.ITreeNattableModelManager;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.parsers.CellIterator;
import org.eclipse.papyrus.infra.nattable.style.configattribute.PapyrusExportConfigAttributes;
import org.eclipse.papyrus.infra.nattable.tree.CollapseAndExpandActionsEnum;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.CSVPasteHelper;
import org.eclipse.papyrus.infra.nattable.utils.TableClipboardUtils;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.model2doc.core.builtintypes.BuiltInTypesFactory;
import org.eclipse.papyrus.model2doc.core.builtintypes.CellLocation;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentStructureGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.generatorconfiguration.accessors.IOutputFileAccessor;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.DocumentStructureFactory;
import org.eclipse.papyrus.model2doc.emf.documentstructure.EmptyLine;
import org.eclipse.papyrus.model2doc.emf.documentstructure.ExtendedBasicTable;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Image;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.DocumentTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodySectionPartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.utils.DocumentStructureTemplateUtils;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractBodyPartTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;
import org.eclipse.papyrus.model2doc.integration.nattable.documentstructuretemplate.PapyrusNattableDocumentStructureTemplatePackage;
import org.eclipse.papyrus.model2doc.integration.nattable.documentstructuretemplate.PapyrusTableView;
import org.eclipse.papyrus.model2doc.integration.nattable.template2structure.internal.mapping.CustomNattableLabelProvider;
import org.eclipse.papyrus_model2doc.integration.nattable.template2structure.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class PapyrusTableViewMapper
extends AbstractBodyPartTemplateToStructureMapper<PapyrusTableView> {
    private static final String TREE_LEVEL_MARKER = "  ";

    public PapyrusTableViewMapper() {
        super(PapyrusNattableDocumentStructureTemplatePackage.eINSTANCE.getPapyrusTableView(), BodyPart.class);
    }

    protected <T> List<T> doMap(IMappingService mappingService, PapyrusTableView papyrusTableView, EObject semanticModelElement, Class<T> returnedClassType) {
        if (!papyrusTableView.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        if (!papyrusTableView.isGenerate()) {
            return Collections.emptyList();
        }
        ArrayList<BodyPart> returnedValue = new ArrayList<BodyPart>();
        for (Table current : papyrusTableView.getMatchingTables(semanticModelElement)) {
            List<BodyPart> mapResult = this.mapTable(papyrusTableView, current);
            if (mapResult == null || mapResult.isEmpty()) {
                Activator.log.warn(NLS.bind((String)"We fail to import the table {0}.", (Object)current.getName()));
            }
            returnedValue.addAll(mapResult);
        }
        return this.buildMapperResult((IBodySectionPartTemplate)papyrusTableView, semanticModelElement, returnedClassType, returnedValue);
    }

    private List<BodyPart> mapTable(PapyrusTableView papyrusTableView, Table table) {
        IPageManager pageManager = this.getIPageManager(table);
        if (pageManager == null) {
            return null;
        }
        boolean closePage = false;
        if (pageManager.isOpen((Object)table)) {
            pageManager.selectPage((Object)table);
        } else {
            pageManager.openPage((Object)table);
            closePage = true;
        }
        PapyrusTableViewMapper.flushEventLoop();
        INattableModelManager manager = this.getINattableModelManager(table);
        if (manager instanceof ITreeNattableModelManager) {
            ((ITreeNattableModelManager)manager).doCollapseExpandAction(CollapseAndExpandActionsEnum.EXPAND_ALL, Collections.emptyList());
            PapyrusTableViewMapper.flushEventLoop();
        }
        ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>();
        switch (papyrusTableView.getImportMethod()) {
            case IMAGE: {
                bodyParts.add((BodyPart)this.mapTableAsImage(manager, papyrusTableView, table));
                break;
            }
            default: {
                bodyParts.add((BodyPart)this.mapTableAsTable(manager, papyrusTableView, table));
                EmptyLine emptyLine = DocumentStructureFactory.eINSTANCE.createEmptyLine();
                bodyParts.add((BodyPart)emptyLine);
            }
        }
        return bodyParts;
    }

    /*
     * Unable to fully structure code
     */
    private ExtendedBasicTable mapTableAsTable(INattableModelManager manager, PapyrusTableView papyrusTableView, Table pTable) {
        isTreeTable = manager instanceof ITreeNattableModelManager;
        manager.selectAll();
        ((NattableModelManager)manager).copyToClipboard();
        clipboardContent = TableClipboardUtils.getClipboardContentsAsString();
        reader = new StringReader(clipboardContent);
        helper = new CSVPasteHelper();
        parser = helper.createParser((Reader)reader, true);
        nat = (NatTable)manager.getAdapter(NatTable.class);
        labelProvider = new CustomNattableLabelProvider(nat.getConfigRegistry());
        basicTable = DocumentStructureFactory.eINSTANCE.createExtendedBasicTable();
        basicTable.setCaption(pTable.getName());
        columnIter = manager.getColumnElementsList().iterator();
        columnRowHeader = BuiltInTypesFactory.eINSTANCE.createBasicRow();
        basicTable.getRows().add((Object)columnRowHeader);
        cellCorner = DocumentStructureFactory.eINSTANCE.createExtendedTextCell();
        columnRowHeader.getCells().add((Object)cellCorner);
        cellCorner.setLocation(CellLocation.CORNER);
        while (columnIter.hasNext()) {
            current = columnIter.next();
            res = labelProvider.getColumnHeaderLabel(current);
            cell = DocumentStructureFactory.eINSTANCE.createExtendedTextCell();
            cell.setLocation(CellLocation.COLUMN_HEADER);
            cell.setText(res);
            columnRowHeader.getCells().add((Object)cell);
        }
        rowIterator = parser.parse();
        rowIter = manager.getRowElementsList().iterator();
        while (rowIterator.hasNext() && rowIter.hasNext()) {
            row = BuiltInTypesFactory.eINSTANCE.createBasicRow();
            basicTable.getRows().add((Object)row);
            element = rowIter.next();
            cell1 = DocumentStructureFactory.eINSTANCE.createExtendedTextCell();
            cell1.setLocation(CellLocation.ROW_HEADER);
            cellContent = labelProvider.getRowHeaderLabel(element);
            if (isTreeTable) {
                depth = 0;
                if (element instanceof ITreeItemAxis) {
                    representedElement = AxisUtils.getRepresentedElement(element);
                    if (representedElement instanceof TreeFillingConfiguration) {
                        depth = ((TreeFillingConfiguration)representedElement).getDepth() * 2;
                    } else {
                        parent = ((ITreeItemAxis)element).getParent();
                        if (parent != null && (representedElement = AxisUtils.getRepresentedElement((Object)parent)) instanceof TreeFillingConfiguration) {
                            depth = ((TreeFillingConfiguration)representedElement).getDepth() * 2 + 1;
                        }
                    }
                }
                rowHeaderCellContent = new StringBuilder();
                i = 0;
                while (i < depth) {
                    rowHeaderCellContent.append("  ");
                    ++i;
                }
                cellContent = rowHeaderCellContent.append(cellContent).toString();
            }
            cell1.setText(cellContent);
            row.getCells().add((Object)cell1);
            cellIterator = (CellIterator)rowIterator.next();
            if (cellIterator == null) continue;
            if (cellIterator.hasNext()) ** GOTO lbl71
            cell = DocumentStructureFactory.eINSTANCE.createExtendedTextCell();
            row.getCells().add((Object)cell);
            continue;
lbl-1000:
            // 1 sources

            {
                cell = DocumentStructureFactory.eINSTANCE.createExtendedTextCell();
                cell.setText((String)cellIterator.next());
                row.getCells().add((Object)cell);
lbl71:
                // 2 sources

                ** while (cellIterator.hasNext())
            }
lbl72:
            // 1 sources

        }
        return basicTable;
    }

    private Image mapTableAsImage(INattableModelManager manager, PapyrusTableView papyrusTableView, Table table) {
        String XMI_ID;
        DocumentTemplate t = DocumentStructureTemplateUtils.getDocumentTemplate((EObject)papyrusTableView);
        IDocumentStructureGeneratorConfiguration conf = t.getDocumentStructureGeneratorConfiguration();
        StringBuilder imageNameBuilder = new StringBuilder(table.getName().replaceAll("\\s+", ""));
        if (table.eResource() instanceof XMIResource && (XMI_ID = ((XMIResource)table.eResource()).getID((EObject)table)) != null && !XMI_ID.isEmpty()) {
            imageNameBuilder.append("_");
            imageNameBuilder.append(XMI_ID);
        }
        IOutputFileAccessor accessor = conf.createImageOutputAccessor();
        URI uri = accessor.createOutputFileURI(imageNameBuilder.toString(), ImageFormat.PNG.getImageExtension());
        String imagePath = accessor.convertToURL(uri).toString();
        imagePath = imagePath.replaceAll("file:/", "");
        this.generateAllIntermediateFolders(imagePath);
        NatTable natTable = (NatTable)manager.getAdapter(NatTable.class);
        if (natTable == null) {
            Activator.log.warn("The NatTable widget can't be found");
        }
        Object[] previousValues = this.configureTableForExport(natTable, false, false, imagePath, ImageFormat.PNG);
        manager.exportToImage();
        PapyrusTableViewMapper.flushEventLoop();
        Image image = DocumentStructureFactory.eINSTANCE.createImage();
        image.setCaption(table.getName());
        image.setFilePath(uri.toString());
        this.configureTableForExport(natTable, (Boolean)previousValues[0], (Boolean)previousValues[1], (String)previousValues[2], (ImageFormat)previousValues[3]);
        return image;
    }

    private Object[] configureTableForExport(NatTable natTable, boolean useExportDialog, boolean openExportResult, String outputFile, ImageFormat imageFormat) {
        IConfigRegistry configRegistry = natTable.getConfigRegistry();
        boolean previousUseExportDialog = (Boolean)configRegistry.getConfigAttribute(PapyrusExportConfigAttributes.EXPORT_IMAGE_USE_PAPYRUS_EXPORT_TABLE_DIALOG, DisplayMode.NORMAL, new String[0]);
        boolean previousOpenResult = (Boolean)configRegistry.getConfigAttribute(PapyrusExportConfigAttributes.OPEN_RESULT_AFTER_EXPORT, DisplayMode.NORMAL, new String[0]);
        String previousOutputfile = (String)configRegistry.getConfigAttribute(PapyrusExportConfigAttributes.EXPORT_IMAGE_FILENAME, DisplayMode.NORMAL, new String[0]);
        ImageFormat previouImageFormat = (ImageFormat)configRegistry.getConfigAttribute(PapyrusExportConfigAttributes.EXPORT_IMAGE_FORMAT, DisplayMode.NORMAL, new String[0]);
        configRegistry.registerConfigAttribute(PapyrusExportConfigAttributes.EXPORT_IMAGE_USE_PAPYRUS_EXPORT_TABLE_DIALOG, (Object)useExportDialog);
        configRegistry.registerConfigAttribute(PapyrusExportConfigAttributes.OPEN_RESULT_AFTER_EXPORT, (Object)openExportResult);
        configRegistry.registerConfigAttribute(PapyrusExportConfigAttributes.EXPORT_IMAGE_FILENAME, (Object)outputFile);
        configRegistry.registerConfigAttribute(PapyrusExportConfigAttributes.EXPORT_IMAGE_FORMAT, (Object)imageFormat);
        return new Object[]{previousUseExportDialog, previousOpenResult, previousOutputfile, previouImageFormat};
    }

    private IPageManager getIPageManager(Table table) {
        try {
            return ServiceUtilsForEObject.getInstance().getIPageManager((Object)table);
        }
        catch (ServiceException e) {
            Activator.log.error("The page manager can't be found", (Throwable)e);
            return null;
        }
    }

    private final INattableModelManager getINattableModelManager(Table table) {
        INattableModelManager manager;
        IMultiDiagramEditor multiDiagramEditor = this.getIMultiDiagramEditor(table);
        IEditorPart editor = multiDiagramEditor.getActiveEditor();
        if (editor == null) {
            Activator.log.warn(NLS.bind((String)"The editor for the Table {0} has not been open.", (Object)table.getName()));
        }
        if ((manager = (INattableModelManager)editor.getAdapter(INattableModelManager.class)) == null || manager.getTable() != table) {
            Activator.log.warn(NLS.bind((String)"The editor for the Table {0} can't be open.", (Object)table.getName()));
        }
        return manager;
    }

    private final IMultiDiagramEditor getIMultiDiagramEditor(Table table) {
        ServicesRegistry reg = null;
        try {
            reg = ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)table);
        }
        catch (ServiceException e) {
            Activator.log.error("ServiceRegistry not found.", (Throwable)e);
        }
        if (reg == null) {
            return null;
        }
        IMultiDiagramEditor multiDiagramEditor = null;
        try {
            multiDiagramEditor = (IMultiDiagramEditor)reg.getService(IMultiDiagramEditor.class);
        }
        catch (ServiceException e) {
            Activator.log.error("IMultiDiagramEditor not found.", (Throwable)e);
        }
        return multiDiagramEditor;
    }

    private final void generateAllIntermediateFolders(String pathRoot) {
        IPath folderPath;
        File folder;
        Path imagePath = new Path(pathRoot.toString());
        if (imagePath.segmentCount() > 1 && !(folder = (folderPath = imagePath.removeLastSegments(1)).toFile()).exists()) {
            folder.mkdirs();
        }
    }

    private static final void flushEventLoop() {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    while (display.readAndDispatch()) {
                    }
                }
                catch (Exception ex) {
                    Activator.log.error("Exceptions occured during the opening of the Table", (Throwable)ex);
                }
            }
        });
    }
}

