/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.drop.IExternalSourceToRepresentationDropChecker;
import org.eclipse.papyrus.uml.domain.services.status.CheckStatus;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class StateMachineExternalSourceToRepresentationDropChecker
implements IExternalSourceToRepresentationDropChecker {
    @Override
    public CheckStatus canDragAndDrop(EObject elementToDrop, EObject newSemanticContainer) {
        return (CheckStatus)new StateMachineDropInsideRepresentationCheckerSwitch(newSemanticContainer).doSwitch(elementToDrop);
    }

    static class StateMachineDropInsideRepresentationCheckerSwitch
    extends UMLSwitch<CheckStatus> {
        private final EObject newSemanticContainer;

        StateMachineDropInsideRepresentationCheckerSwitch(EObject target) {
            this.newSemanticContainer = target;
        }

        public CheckStatus caseComment(Comment comment) {
            CheckStatus result = !(this.newSemanticContainer instanceof Region) && !(this.newSemanticContainer instanceof StateMachine) ? CheckStatus.no("Comment can only be drag and drop on Region or diagram.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseState(State state) {
            CheckStatus result = !(this.newSemanticContainer instanceof Region) ? CheckStatus.no("State can only be drag and drop on Region.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus caseRegion(Region region) {
            CheckStatus result = !(this.newSemanticContainer instanceof StateMachine) && !(this.newSemanticContainer instanceof State) ? CheckStatus.no("Region can only be drag and drop on StateMachine or State.") : CheckStatus.YES;
            return result;
        }

        public CheckStatus casePseudostate(Pseudostate pseudostate) {
            CheckStatus result = null;
            if (pseudostate.getKind().equals((Object)PseudostateKind.ENTRY_POINT_LITERAL) || pseudostate.getKind().equals((Object)PseudostateKind.EXIT_POINT_LITERAL)) {
                if (!(this.newSemanticContainer instanceof Region || this.newSemanticContainer instanceof StateMachine || this.newSemanticContainer instanceof State)) {
                    result = CheckStatus.no("Entry or Exit Point can only be drag and drop on StateMachine or State.");
                }
            } else if (!(this.newSemanticContainer instanceof Region)) {
                result = CheckStatus.no("This Pseudostate can only be drag and drop on a Region.");
            }
            if (result == null) {
                return CheckStatus.YES;
            }
            return result;
        }

        public CheckStatus defaultCase(EObject object) {
            return CheckStatus.no("DnD is not authorized.");
        }
    }
}

