/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.create.CreationStatus;
import org.eclipse.papyrus.uml.domain.services.create.ElementConfigurer;
import org.eclipse.papyrus.uml.domain.services.create.ElementCreator;
import org.eclipse.papyrus.uml.domain.services.drop.DnDStatus;
import org.eclipse.papyrus.uml.domain.services.drop.IExternalSourceToRepresentationDropBehaviorProvider;
import org.eclipse.papyrus.uml.domain.services.modify.ElementFeatureModifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class CommunicationExternalSourceToRepresentationDropBehaviorProvider
implements IExternalSourceToRepresentationDropBehaviorProvider {
    @Override
    public DnDStatus drop(EObject droppedElement, EObject target, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        return (DnDStatus)new CommunicationDropInsideRepresentationBehaviorProviderSwitch(target, crossRef, editableChecker).doSwitch(droppedElement);
    }

    static class CommunicationDropInsideRepresentationBehaviorProviderSwitch
    extends UMLSwitch<DnDStatus> {
        private final EObject target;
        private final ECrossReferenceAdapter crossRef;
        private final IEditableChecker editableChecker;

        CommunicationDropInsideRepresentationBehaviorProviderSwitch(EObject target, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
            this.target = target;
            this.crossRef = crossRef;
            this.editableChecker = editableChecker;
        }

        public DnDStatus caseComment(Comment comment) {
            if (this.target instanceof Interaction) {
                return DnDStatus.createNothingStatus(Set.of(comment));
            }
            return (DnDStatus)super.caseComment(comment);
        }

        public DnDStatus caseConstraint(Constraint constraint) {
            if (this.target instanceof Interaction) {
                return DnDStatus.createNothingStatus(Set.of(constraint));
            }
            return (DnDStatus)super.caseConstraint(constraint);
        }

        public DnDStatus caseDurationObservation(DurationObservation durationObservation) {
            if (this.target instanceof Interaction) {
                return DnDStatus.createNothingStatus(Set.of(durationObservation));
            }
            return (DnDStatus)super.caseDurationObservation(durationObservation);
        }

        public DnDStatus caseLifeline(Lifeline lifeline) {
            if (this.target instanceof Interaction) {
                return DnDStatus.createNothingStatus(Set.of(lifeline));
            }
            return (DnDStatus)super.caseLifeline(lifeline);
        }

        public DnDStatus caseMessage(Message message) {
            return DnDStatus.createNothingStatus(Set.of(message));
        }

        public DnDStatus caseProperty(Property property) {
            if (this.target instanceof Lifeline) {
                ((Lifeline)this.target).setRepresents((ConnectableElement)property);
                return DnDStatus.createOKStatus(Collections.emptySet());
            }
            return (DnDStatus)super.caseProperty(property);
        }

        public DnDStatus caseTimeObservation(TimeObservation timeObservation) {
            if (this.target instanceof Interaction) {
                return DnDStatus.createNothingStatus(Set.of(timeObservation));
            }
            return (DnDStatus)super.caseTimeObservation(timeObservation);
        }

        public DnDStatus caseType(Type type) {
            if (this.target instanceof Interaction || this.target instanceof Lifeline) {
                ElementFeatureModifier featureModifier = new ElementFeatureModifier(this.crossRef, this.editableChecker);
                ElementCreator elementCreator = new ElementCreator(new ElementConfigurer(), featureModifier);
                Lifeline lifeLineToDrop = null;
                Property propertyToRepresents = null;
                if (this.target instanceof Interaction) {
                    createProperty = elementCreator.create(this.target, UMLPackage.eINSTANCE.getProperty().getName(), UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute().getName());
                    propertyToRepresents = (Property)createProperty.getElement();
                    CreationStatus createLifeline = elementCreator.create(this.target, UMLPackage.eINSTANCE.getLifeline().getName(), UMLPackage.eINSTANCE.getInteraction_Lifeline().getName());
                    lifeLineToDrop = (Lifeline)createLifeline.getElement();
                } else {
                    createProperty = elementCreator.create(this.getInteraction(this.target), UMLPackage.eINSTANCE.getProperty().getName(), UMLPackage.eINSTANCE.getStructuredClassifier_OwnedAttribute().getName());
                    propertyToRepresents = (Property)createProperty.getElement();
                    lifeLineToDrop = (Lifeline)this.target;
                }
                propertyToRepresents.setType(type);
                lifeLineToDrop.setRepresents((ConnectableElement)propertyToRepresents);
                DnDStatus dnDStatus = null;
                dnDStatus = this.target instanceof Interaction ? DnDStatus.createOKStatus(Set.of(lifeLineToDrop)) : DnDStatus.createOKStatus(Collections.emptySet());
                return dnDStatus;
            }
            return (DnDStatus)super.caseType(type);
        }

        public DnDStatus defaultCase(EObject obj) {
            return DnDStatus.createFailingStatus("DnD is forbidden.", Collections.emptySet());
        }

        private EObject getInteraction(EObject source) {
            EObject element = source;
            while (element != null) {
                if (element instanceof Interaction) {
                    return element;
                }
                element = element.eContainer();
            }
            return null;
        }
    }
}

